/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.api;

import discord4j.common.store.api.StoreAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;

public class ActionMapper {
    private static final ActionMapper EMPTY = new ActionMapper(Collections.emptyMap());
    private final Map<Class<? extends StoreAction<?>>, Function<StoreAction<?>, ? extends Publisher<?>>> mappings;

    private ActionMapper(Map<Class<? extends StoreAction<?>>, Function<StoreAction<?>, ? extends Publisher<?>>> mappings) {
        this.mappings = mappings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ActionMapper empty() {
        return EMPTY;
    }

    public static ActionMapper aggregate(ActionMapper ... mappers) {
        Objects.requireNonNull(mappers);
        if (mappers.length == 0) {
            return EMPTY;
        }
        if (mappers.length == 1) {
            return mappers[0];
        }
        return new ActionMapper(Arrays.stream(mappers).flatMap(mapper -> mapper.mappings.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public <R> Optional<Function<StoreAction<R>, ? extends Publisher<R>>> findHandlerForAction(StoreAction<R> action) {
        Objects.requireNonNull(action);
        return Optional.ofNullable(this.mappings.get(action.getClass())).map(handler -> a -> (Publisher)handler.apply(a));
    }

    public static class Builder {
        private final Map<Class<? extends StoreAction<?>>, Function<StoreAction<?>, ? extends Publisher<?>>> mappings = new HashMap();

        private Builder() {
        }

        public <R, S extends StoreAction<R>> Builder map(Class<S> actionType, Function<? super S, ? extends Publisher<R>> handler) {
            Objects.requireNonNull(actionType);
            Objects.requireNonNull(handler);
            this.mappings.put(actionType, action -> (Publisher)handler.apply((Object)action));
            return this;
        }

        public ActionMapper build() {
            return new ActionMapper(this.mappings);
        }
    }
}

