/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.util;

import java.math.BigInteger;
import java.time.Instant;
import reactor.util.annotation.Nullable;

public final class Snowflake
implements Comparable<Snowflake> {
    public static final long DISCORD_EPOCH = 1420070400000L;
    private final long id;

    public static Snowflake of(long id) {
        return new Snowflake(id);
    }

    public static Snowflake of(String id) {
        return new Snowflake(Long.parseUnsignedLong(id));
    }

    public static Snowflake of(Instant timestamp) {
        return Snowflake.of(timestamp.toEpochMilli() - 1420070400000L << 22);
    }

    public static Snowflake of(BigInteger id) {
        return Snowflake.of(id.longValue());
    }

    public static long asLong(String id) {
        return Long.parseUnsignedLong(id);
    }

    public static String asString(long id) {
        return Long.toUnsignedString(id);
    }

    private Snowflake(long id) {
        this.id = id;
    }

    public long asLong() {
        return this.id;
    }

    public String asString() {
        return Long.toUnsignedString(this.id);
    }

    public Instant getTimestamp() {
        return Instant.ofEpochMilli(1420070400000L + (this.id >>> 22));
    }

    public BigInteger asBigInteger() {
        return new BigInteger(this.asString());
    }

    @Override
    public int compareTo(Snowflake other) {
        return Long.signum((this.id >>> 22) - (other.id >>> 22));
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof Snowflake && ((Snowflake)obj).id == this.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "Snowflake{" + this.asString() + "}";
    }
}

