/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

public class ReactorResources {
    private static final AtomicInteger ID = new AtomicInteger();
    public static final Supplier<HttpClient> DEFAULT_HTTP_CLIENT = () -> HttpClient.create().compress(true).followRedirect(true).secure();
    public static final Supplier<Scheduler> DEFAULT_TIMER_TASK_SCHEDULER = () -> Schedulers.newParallel((String)("d4j-parallel-" + ID.incrementAndGet()), (int)Schedulers.DEFAULT_POOL_SIZE, (boolean)true);
    public static final Supplier<Scheduler> DEFAULT_BLOCKING_TASK_SCHEDULER = Schedulers::boundedElastic;
    private final HttpClient httpClient;
    private final Scheduler timerTaskScheduler;
    private final Scheduler blockingTaskScheduler;

    public ReactorResources() {
        this.httpClient = DEFAULT_HTTP_CLIENT.get();
        this.timerTaskScheduler = DEFAULT_TIMER_TASK_SCHEDULER.get();
        this.blockingTaskScheduler = DEFAULT_BLOCKING_TASK_SCHEDULER.get();
    }

    public ReactorResources(HttpClient httpClient, Scheduler timerTaskScheduler, Scheduler blockingTaskScheduler) {
        this.httpClient = httpClient;
        this.timerTaskScheduler = timerTaskScheduler;
        this.blockingTaskScheduler = blockingTaskScheduler;
    }

    protected ReactorResources(Builder builder) {
        this.httpClient = builder.httpClient == null ? DEFAULT_HTTP_CLIENT.get() : builder.httpClient;
        this.timerTaskScheduler = builder.timerTaskScheduler == null ? DEFAULT_TIMER_TASK_SCHEDULER.get() : builder.timerTaskScheduler;
        this.blockingTaskScheduler = builder.blockingTaskScheduler == null ? DEFAULT_BLOCKING_TASK_SCHEDULER.get() : builder.blockingTaskScheduler;
    }

    public static ReactorResources create() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Scheduler getTimerTaskScheduler() {
        return this.timerTaskScheduler;
    }

    public Scheduler getBlockingTaskScheduler() {
        return this.blockingTaskScheduler;
    }

    public static HttpClient newHttpClient(ConnectionProvider provider, LoopResources resources) {
        return HttpClient.create((ConnectionProvider)provider).tcpConfiguration(tcpClient -> tcpClient.runOn(resources));
    }

    public static class Builder {
        private HttpClient httpClient;
        private Scheduler timerTaskScheduler;
        private Scheduler blockingTaskScheduler;

        protected Builder() {
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder timerTaskScheduler(Scheduler timerTaskScheduler) {
            this.timerTaskScheduler = timerTaskScheduler;
            return this;
        }

        public Builder blockingTaskScheduler(Scheduler blockingTaskScheduler) {
            this.blockingTaskScheduler = blockingTaskScheduler;
            return this;
        }

        public ReactorResources build() {
            return new ReactorResources(this);
        }
    }
}

