/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.util.Logger;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class LogUtil {
    public static final String KEY_BUCKET_ID = "discord4j.bucket";
    public static final String KEY_REQUEST_ID = "discord4j.request";
    public static final String KEY_GATEWAY_ID = "discord4j.gateway";
    public static final String KEY_SHARD_ID = "discord4j.shard";
    public static final String KEY_GUILD_ID = "discord4j.guild";

    public static String format(Context context, String msg) {
        String header = Stream.of(context.getOrEmpty((Object)KEY_BUCKET_ID).map(id -> "B:" + id), context.getOrEmpty((Object)KEY_REQUEST_ID).map(id -> "R:" + id), context.getOrEmpty((Object)KEY_GATEWAY_ID).map(id -> "G:" + id), context.getOrEmpty((Object)KEY_SHARD_ID).map(id -> "S:" + id), context.getOrEmpty((Object)KEY_GUILD_ID).map(id -> "guildId:" + id)).map(opt -> opt.orElse("")).filter(str -> !str.isEmpty()).collect(Collectors.joining(", "));
        StringBuilder builder = new StringBuilder();
        if (!header.isEmpty()) {
            return builder.append('[').append(header).append("] ").append(msg).toString();
        }
        return msg;
    }

    public static String formatValue(@Nullable Object value, int maxLength) {
        String str;
        if (value == null) {
            return "";
        }
        if (value instanceof CharSequence) {
            str = String.valueOf(value);
        } else {
            try {
                str = value.toString();
            }
            catch (Throwable ex) {
                str = ex.toString();
            }
        }
        return maxLength > 0 && str.length() > maxLength ? str.substring(0, maxLength) + "..." : str;
    }

    public static void traceDebug(Logger logger, Function<Boolean, String> messageFactory) {
        if (logger.isDebugEnabled()) {
            boolean traceEnabled = logger.isTraceEnabled();
            String logMessage = messageFactory.apply(traceEnabled);
            if (traceEnabled) {
                logger.trace(logMessage);
            } else {
                logger.debug(logMessage);
            }
        }
    }

    public static Function<Context, Context> clearContext() {
        return ctx -> ctx.delete((Object)KEY_BUCKET_ID).delete((Object)KEY_REQUEST_ID).delete((Object)KEY_GATEWAY_ID).delete((Object)KEY_SHARD_ID).delete((Object)KEY_GUILD_ID);
    }
}

