/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.jackson;

import java.util.NoSuchElementException;
import reactor.util.annotation.Nullable;

public class PossibleLong {
    private static final PossibleLong ABSENT = new PossibleLong();
    private final boolean isAbsent;
    private final long value;

    private PossibleLong() {
        this.isAbsent = true;
        this.value = 0L;
    }

    private PossibleLong(long value) {
        this.isAbsent = false;
        this.value = value;
    }

    public static PossibleLong of(long value) {
        return new PossibleLong(value);
    }

    public static PossibleLong absent() {
        return ABSENT;
    }

    public long get() {
        if (this.isAbsent()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean isAbsent() {
        return this.isAbsent;
    }

    public int hashCode() {
        return this.isAbsent ? 0 : Long.hashCode(this.value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PossibleLong possible = (PossibleLong)o;
        return this.isAbsent && possible.isAbsent || this.value == possible.value;
    }
}

