/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common;

import java.time.Duration;
import reactor.core.Disposable;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class ResettableInterval {
    private final EmitterProcessor<Long> backing = EmitterProcessor.create((boolean)false);
    private volatile Disposable task;
    private volatile Duration period;

    public void start(Duration period) {
        this.period = period;
        this.task = Flux.interval((Duration)Duration.ZERO, (Duration)period, (Scheduler)Schedulers.elastic()).subscribe(arg_0 -> this.backing.onNext(arg_0));
    }

    public void stop() {
        if (this.task == null) {
            throw new IllegalStateException("Emitter has not started!");
        }
        this.task.dispose();
    }

    public Flux<Long> ticks() {
        return this.backing;
    }

    public Duration getPeriod() {
        return this.period;
    }
}

