/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.jackson;

import java.util.NoSuchElementException;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class Possible<T> {
    private static final Possible<?> ABSENT = new Possible<Object>(null);
    @Nullable
    private final T value;

    private Possible(@Nullable T value) {
        this.value = value;
    }

    public static <T> Possible<T> of(T value) {
        Objects.requireNonNull(value);
        return new Possible<T>(value);
    }

    public static <T> Possible<T> absent() {
        return ABSENT;
    }

    public T get() {
        if (this.isAbsent()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public boolean isAbsent() {
        return this.value == null;
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Possible possible = (Possible)o;
        return this.value != null ? this.value.equals(possible.value) : possible.value == null;
    }

    public String toString() {
        if (this.isAbsent()) {
            return "Possible.absent";
        }
        return "Possible[" + this.value + "]";
    }
}

