/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

public class UnsignedLongDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    public UnsignedLongDeserializer() {
        super(Object.class);
    }

    private UnsignedLongDeserializer(JavaType type) {
        super(type);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        return new UnsignedLongDeserializer(property.getType());
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Class type = this.handledType();
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return Long.parseUnsignedLong(p.getValueAsString());
        }
        if (type.equals(long[].class)) {
            String[] ary = (String[])p.readValueAs(String[].class);
            long[] ret = new long[ary.length];
            for (int i = 0; i < ary.length; ++i) {
                ret[i] = Long.parseUnsignedLong(ary[i]);
            }
            return ret;
        }
        throw new IllegalStateException("Attempt to deserialize field marked with @UnsignedJson which is not of type Long | long[]: " + type.getSimpleName());
    }
}

