/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.jackson;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.ReferenceType;
import discord4j.common.jackson.Possible;
import discord4j.common.jackson.PossibleLong;
import discord4j.common.jackson.PossibleLongSerializer;
import discord4j.common.jackson.PossibleSerializer;
import reactor.util.annotation.Nullable;

public class PossibleSerializers
extends Serializers.Base {
    @Nullable
    public JsonSerializer<?> findReferenceSerializer(SerializationConfig config, ReferenceType type, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        Class raw = type.getRawClass();
        boolean staticTyping = config.isEnabled(MapperFeature.USE_STATIC_TYPING);
        if (Possible.class.isAssignableFrom(raw)) {
            return new PossibleSerializer(type, staticTyping, contentTypeSerializer, contentValueSerializer);
        }
        if (PossibleLong.class.isAssignableFrom(raw)) {
            return new PossibleLongSerializer(type, staticTyping, contentTypeSerializer, contentValueSerializer);
        }
        return null;
    }
}

