/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import discord4j.common.jackson.Possible;
import discord4j.common.jackson.PossibleLong;
import java.io.IOException;

public class UnsignedLongSerializer
extends StdSerializer<Object> {
    public UnsignedLongSerializer() {
        super(Object.class);
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value instanceof Long) {
            gen.writeString(Long.toUnsignedString((Long)value));
        } else if (value instanceof PossibleLong) {
            PossibleLong pl = (PossibleLong)value;
            if (pl.isAbsent()) {
                provider.defaultSerializeNull(gen);
            } else {
                gen.writeString(Long.toUnsignedString(pl.get()));
            }
        } else if (value instanceof long[]) {
            UnsignedLongSerializer.writeArray((long[])value, gen);
        } else if (value instanceof Possible) {
            Possible p = (Possible)value;
            if (p.isAbsent()) {
                provider.defaultSerializeNull(gen);
            } else {
                Object o = p.get();
                if (o instanceof long[]) {
                    UnsignedLongSerializer.writeArray((long[])o, gen);
                }
            }
        } else {
            throw new IllegalStateException("Attempt to serialize field marked with @UnsignedJson which is not of type Long | PossibleLong | long[] | Possible<long[]>");
        }
    }

    private static void writeArray(long[] ary, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (long l : ary) {
            gen.writeString(Long.toUnsignedString(l));
        }
        gen.writeEndArray();
    }
}

