/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.close;

import discord4j.common.close.CloseStatus;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import java.util.concurrent.atomic.AtomicReference;
import reactor.util.Logger;

public class CloseHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private final AtomicReference<CloseStatus> closeStatus;
    private final Logger log;

    public CloseHandlerAdapter(AtomicReference<CloseStatus> closeStatus, Logger log) {
        this.closeStatus = closeStatus;
        this.log = log;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)msg).isFinalFragment()) {
            CloseWebSocketFrame close = (CloseWebSocketFrame)msg;
            this.log.debug("Close status: {} {}", new Object[]{close.statusCode(), close.reasonText()});
            this.closeStatus.set(new CloseStatus(close.statusCode(), close.reasonText()));
        }
        ctx.fireChannelRead(msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        SslCloseCompletionEvent closeEvent;
        if (evt instanceof SslCloseCompletionEvent && !(closeEvent = (SslCloseCompletionEvent)evt).isSuccess()) {
            this.log.debug("Abnormal close status: {}", new Object[]{closeEvent.cause().toString()});
            this.closeStatus.set(new CloseStatus(1006, closeEvent.cause().toString()));
        }
        ctx.fireUserEventTriggered(evt);
    }
}

