/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common;

import discord4j.common.RateLimiter;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleBucket
implements RateLimiter {
    private final long capacity;
    private final long refillPeriodMillis;
    private final AtomicLong count;
    private final AtomicLong nextRefillAt;

    public SimpleBucket(long capacity, Duration refillPeriod) {
        this.capacity = capacity;
        this.refillPeriodMillis = refillPeriod.toMillis();
        this.count = new AtomicLong(0L);
        this.nextRefillAt = new AtomicLong(0L);
    }

    @Override
    public synchronized boolean tryConsume(int numberTokens) {
        long now = System.currentTimeMillis();
        if (this.nextRefillAt.get() <= now) {
            this.count.set(0L);
            this.nextRefillAt.set(now + this.refillPeriodMillis);
        }
        if (this.count.get() + (long)numberTokens <= this.capacity) {
            this.count.addAndGet(numberTokens);
            return true;
        }
        return false;
    }

    @Override
    public synchronized long delayMillisToConsume(long tokens) {
        if (this.count.get() + tokens <= this.capacity) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long refills = (long)Math.ceil((double)tokens / (double)this.capacity - 1.0);
        return this.nextRefillAt.get() - now + this.refillPeriodMillis * refills;
    }
}

