/*
 * Decompiled with CFR 0.152.
 */
package discord4j.command.util;

import discord4j.command.Command;
import discord4j.command.CommandDispatcher;
import discord4j.command.CommandErrorHandler;
import discord4j.command.CommandProvider;
import discord4j.core.event.domain.message.MessageCreateEvent;
import java.util.Optional;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public abstract class AbstractCommandDispatcher
implements CommandDispatcher {
    @Override
    public Publisher<? extends Command<?>> dispatch(MessageCreateEvent event, Set<CommandProvider<?>> providers, CommandErrorHandler errorHandler) {
        Optional content = event.getMessage().getContent();
        return Mono.justOrEmpty((Optional)event.getMessage().getAuthor()).filter(user -> !user.isBot()).flatMapMany(ignored -> this.getPrefixes(event)).filter(((String)content.get())::startsWith).map(prefix -> ((String)content.get()).substring(prefix.length()).trim()).map(trimmed -> {
            int endIndex = trimmed.indexOf(32) < 0 ? trimmed.length() : trimmed.indexOf(32);
            String commandName = trimmed.substring(0, endIndex);
            String remaining = trimmed.substring(commandName.length()).trim();
            return Tuples.of((Object)commandName, (Object)(((String)content.get()).length() - remaining.length()));
        }).cache().zipWith((Publisher)Flux.fromIterable(providers)).concatMap(context -> {
            Tuple2 hints = (Tuple2)context.getT1();
            CommandProvider provider = (CommandProvider)context.getT2();
            return Flux.from(provider.provide(event, (String)hints.getT1(), (Integer)hints.getT2(), ((String)content.get()).length())).onErrorResume(error -> errorHandler.handle(event, (Throwable)error).then(Mono.empty()));
        }).flatMap(context -> context.getCommand().execute(event, context.getContext().orElse(null)).onErrorResume(error -> errorHandler.handle(event, (Throwable)error)).thenReturn(context.getCommand()));
    }

    protected abstract Publisher<String> getPrefixes(MessageCreateEvent var1);
}

