/*
 * Decompiled with CFR 0.152.
 */
package discord4j.command;

import discord4j.command.Command;
import discord4j.command.CommandDispatcher;
import discord4j.command.CommandErrorHandler;
import discord4j.command.CommandProvider;
import discord4j.core.DiscordClient;
import discord4j.core.event.domain.message.MessageCreateEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class CommandBootstrapper {
    private static final Logger LOGGER = Loggers.getLogger(CommandBootstrapper.class);
    private static final CommandErrorHandler DEFAULT_ERROR_HANDLER = (context, error) -> {
        LOGGER.warn(error.getMessage(), error);
        return Mono.empty();
    };
    private final CommandErrorHandler errorHandler;
    private final Set<CommandProvider<?>> providers;
    private final CommandDispatcher dispatcher;

    public CommandBootstrapper(CommandDispatcher dispatcher, CommandErrorHandler errorHandler) {
        this.dispatcher = dispatcher;
        this.errorHandler = errorHandler;
        this.providers = new CopyOnWriteArraySet();
    }

    public CommandBootstrapper(CommandDispatcher dispatcher) {
        this(dispatcher, DEFAULT_ERROR_HANDLER);
    }

    public Flux<? extends Command<?>> attach(DiscordClient client) {
        return client.getEventDispatcher().on(MessageCreateEvent.class).filter(event -> event.getMessage().getContent().isPresent()).flatMap(event -> this.dispatcher.dispatch((MessageCreateEvent)event, this.providers, this.errorHandler)).share();
    }

    public CommandDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public CommandErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Set<CommandProvider<?>> getProviders() {
        return Collections.unmodifiableSet(this.providers);
    }

    public CommandBootstrapper addProvider(CommandProvider<?> provider) {
        this.providers.add(provider);
        return this;
    }

    public CommandBootstrapper removeProvider(CommandProvider<?> provider) {
        this.providers.remove(provider);
        return this;
    }

    public CommandBootstrapper addProviders(Collection<? extends CommandProvider<?>> providers) {
        this.providers.addAll(providers);
        return this;
    }

    public CommandBootstrapper removeProviders(Collection<? extends CommandProvider<?>> providers) {
        this.providers.removeAll(providers);
        return this;
    }
}

