/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.ThreadMemberData;
import discord4j.discordjson.json.gateway.ThreadListSync;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="ThreadListSync", generator="Immutables")
public final class ImmutableThreadListSync
implements ThreadListSync {
    private final long guildId_value;
    private final List<Id> channelIds_value;
    private final boolean channelIds_absent;
    private final List<ChannelData> threads;
    private final List<ThreadMemberData> members;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableThreadListSync(Id guildId, Possible<List<Id>> channelIds, Iterable<? extends ChannelData> threads, Iterable<? extends ThreadMemberData> members) {
        Id guildId$impl = guildId;
        Possible<List<Id>> channelIds$impl = channelIds;
        this.threads = ImmutableThreadListSync.createUnmodifiableList(false, ImmutableThreadListSync.createSafeList(threads, true, false));
        this.members = ImmutableThreadListSync.createUnmodifiableList(false, ImmutableThreadListSync.createSafeList(members, true, false));
        this.guildId_value = guildId$impl.asLong();
        this.channelIds_value = channelIds$impl.toOptional().orElse(null);
        this.channelIds_absent = channelIds$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableThreadListSync(ImmutableThreadListSync original, Id guildId, Possible<List<Id>> channelIds, List<ChannelData> threads, List<ThreadMemberData> members) {
        Id guildId$impl = guildId;
        Possible<List<Id>> channelIds$impl = channelIds;
        this.threads = threads;
        this.members = members;
        this.guildId_value = guildId$impl.asLong();
        this.channelIds_value = channelIds$impl.toOptional().orElse(null);
        this.channelIds_absent = channelIds$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="channel_ids")
    public Possible<List<Id>> channelIds() {
        return this.channelIds_absent ? Possible.absent() : Possible.of(this.channelIds_value);
    }

    @Override
    @JsonProperty(value="threads")
    public List<ChannelData> threads() {
        return this.threads;
    }

    @Override
    @JsonProperty(value="members")
    public List<ThreadMemberData> members() {
        return this.members;
    }

    public ImmutableThreadListSync withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableThreadListSync(this, newValue, this.channelIds(), this.threads, this.members);
    }

    public ImmutableThreadListSync withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableThreadListSync(this, newValue, this.channelIds(), this.threads, this.members);
    }

    public ImmutableThreadListSync withChannelIds(Possible<? extends List<? extends Id>> possible) {
        Possible<? extends List<? extends Id>> newValue = Objects.requireNonNull(possible);
        return new ImmutableThreadListSync(this, this.guildId(), newValue, this.threads, this.members);
    }

    public ImmutableThreadListSync withChannelIds(Iterable<? extends Id> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableThreadListSync(this, this.guildId(), (Possible<List<Id>>)newValue, this.threads, this.members);
    }

    @SafeVarargs
    public final ImmutableThreadListSync withChannelIds(Id ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableThreadListSync(this, this.guildId(), (Possible<List<Id>>)newValue, this.threads, this.members);
    }

    public final ImmutableThreadListSync withThreads(ChannelData ... elements) {
        List<ChannelData> newValue = ImmutableThreadListSync.createUnmodifiableList(false, ImmutableThreadListSync.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableThreadListSync(this, this.guildId(), this.channelIds(), newValue, this.members);
    }

    public final ImmutableThreadListSync withThreads(Iterable<? extends ChannelData> elements) {
        if (this.threads == elements) {
            return this;
        }
        List<ChannelData> newValue = ImmutableThreadListSync.createUnmodifiableList(false, ImmutableThreadListSync.createSafeList(elements, true, false));
        return new ImmutableThreadListSync(this, this.guildId(), this.channelIds(), newValue, this.members);
    }

    public final ImmutableThreadListSync withMembers(ThreadMemberData ... elements) {
        List<ThreadMemberData> newValue = ImmutableThreadListSync.createUnmodifiableList(false, ImmutableThreadListSync.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableThreadListSync(this, this.guildId(), this.channelIds(), this.threads, newValue);
    }

    public final ImmutableThreadListSync withMembers(Iterable<? extends ThreadMemberData> elements) {
        if (this.members == elements) {
            return this;
        }
        List<ThreadMemberData> newValue = ImmutableThreadListSync.createUnmodifiableList(false, ImmutableThreadListSync.createSafeList(elements, true, false));
        return new ImmutableThreadListSync(this, this.guildId(), this.channelIds(), this.threads, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThreadListSync && this.equalTo(0, (ImmutableThreadListSync)another);
    }

    private boolean equalTo(int synthetic, ImmutableThreadListSync another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && Objects.equals(this.channelIds_value, another.channelIds_value) && this.threads.equals(another.threads) && this.members.equals(another.members);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + Objects.hashCode(this.channelIds_value);
        h += (h << 5) + this.threads.hashCode();
        h += (h << 5) + this.members.hashCode();
        return h;
    }

    public String toString() {
        return "ThreadListSync{guildId=" + Objects.toString(this.guildId_value) + ", channelIds=" + Objects.toString(this.channelIds_value) + ", threads=" + this.threads + ", members=" + this.members + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableThreadListSync fromJson(Json json) {
        Builder builder = ImmutableThreadListSync.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.channelIds != null) {
            builder.channelIds(json.channelIds);
        }
        if (json.threads != null) {
            builder.addAllThreads(json.threads);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        return builder.build();
    }

    public static ImmutableThreadListSync of(Id guildId, Possible<List<Id>> channelIds, List<ChannelData> threads, List<ThreadMemberData> members) {
        return ImmutableThreadListSync.of(guildId, channelIds, threads, members);
    }

    public static ImmutableThreadListSync of(Id guildId, Possible<List<Id>> channelIds, Iterable<? extends ChannelData> threads, Iterable<? extends ThreadMemberData> members) {
        return new ImmutableThreadListSync(guildId, channelIds, threads, members);
    }

    public static ImmutableThreadListSync copyOf(ThreadListSync instance) {
        if (instance instanceof ImmutableThreadListSync) {
            return (ImmutableThreadListSync)instance;
        }
        return ImmutableThreadListSync.builder().from(instance).build();
    }

    public boolean isChannelIdsPresent() {
        return !this.channelIds_absent;
    }

    public List<Id> channelIdsOrElse(List<Id> defaultValue) {
        return !this.channelIds_absent ? this.channelIds_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ThreadListSync", generator="Immutables")
    public static final class Builder {
        private Id guildId_id = null;
        private List<Id> channelIds_list = null;
        private List<ChannelData> threads = new ArrayList<ChannelData>();
        private List<ThreadMemberData> members = new ArrayList<ThreadMemberData>();

        private Builder() {
        }

        public final Builder from(ThreadListSync instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.channelIds(instance.channelIds());
            this.addAllThreads(instance.threads());
            this.addAllMembers(instance.members());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public Builder addChannelId(Id element) {
            this.channelIds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllChannelIds(Collection<? extends Id> elements) {
            this.channelIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="channel_ids")
        public Builder channelIds(Possible<? extends Collection<? extends Id>> elements) {
            this.channelIds_list = null;
            elements.toOptional().ifPresent(e -> this.channelIds_getOrCreate().addAll((Collection<Id>)e));
            return this;
        }

        public Builder channelIds(Iterable<? extends Id> elements) {
            this.channelIds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        public final Builder channelIds(Id ... elements) {
            this.channelIds_list = Arrays.asList(elements);
            return this;
        }

        public final Builder addThread(ChannelData element) {
            this.threads.add(Objects.requireNonNull(element, "threads element"));
            return this;
        }

        public final Builder addThreads(ChannelData ... elements) {
            for (ChannelData element : elements) {
                this.threads.add(Objects.requireNonNull(element, "threads element"));
            }
            return this;
        }

        @JsonProperty(value="threads")
        public final Builder threads(Iterable<? extends ChannelData> elements) {
            this.threads.clear();
            return this.addAllThreads(elements);
        }

        public final Builder addAllThreads(Iterable<? extends ChannelData> elements) {
            for (ChannelData channelData : elements) {
                this.threads.add(Objects.requireNonNull(channelData, "threads element"));
            }
            return this;
        }

        public final Builder addMember(ThreadMemberData element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(ThreadMemberData ... elements) {
            for (ThreadMemberData element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends ThreadMemberData> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends ThreadMemberData> elements) {
            for (ThreadMemberData threadMemberData : elements) {
                this.members.add(Objects.requireNonNull(threadMemberData, "members element"));
            }
            return this;
        }

        public ImmutableThreadListSync build() {
            return new ImmutableThreadListSync(null, this.guildId_build(), this.channelIds_build(), ImmutableThreadListSync.createUnmodifiableList(true, this.threads), ImmutableThreadListSync.createUnmodifiableList(true, this.members));
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Possible<List<Id>> channelIds_build() {
            return this.channelIds_list == null ? Possible.absent() : Possible.of(this.channelIds_list);
        }

        private List<Id> channelIds_getOrCreate() {
            if (this.channelIds_list == null) {
                this.channelIds_list = new ArrayList<Id>();
            }
            return this.channelIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ThreadListSync", generator="Immutables")
    static final class Json
    implements ThreadListSync {
        Id guildId;
        Possible<List<Id>> channelIds = Possible.absent();
        List<ChannelData> threads = Collections.emptyList();
        List<ThreadMemberData> members = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="channel_ids")
        public void setChannelIds(Possible<List<Id>> channelIds) {
            this.channelIds = channelIds;
        }

        @JsonProperty(value="threads")
        public void setThreads(List<ChannelData> threads) {
            this.threads = threads;
        }

        @JsonProperty(value="members")
        public void setMembers(List<ThreadMemberData> members) {
            this.members = members;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<Id>> channelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ChannelData> threads() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ThreadMemberData> members() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ThreadListSync", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ThreadListSync, attribute initializers form cycle " + attributes;
        }
    }
}

