/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ThreadMetadata;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ThreadMetadata", generator="Immutables")
public final class ImmutableThreadMetadata
implements ThreadMetadata {
    private final boolean archived;
    private final int autoArchiveDuration;
    private final String archiveTimestamp;
    private final Boolean locked_value;
    private final boolean locked_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableThreadMetadata(boolean archived, int autoArchiveDuration, String archiveTimestamp, Possible<Boolean> locked) {
        this.archived = archived;
        this.autoArchiveDuration = autoArchiveDuration;
        this.archiveTimestamp = Objects.requireNonNull(archiveTimestamp, "archiveTimestamp");
        Possible<Boolean> locked$impl = locked;
        this.locked_value = locked$impl.toOptional().orElse(null);
        this.locked_absent = locked$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableThreadMetadata(ImmutableThreadMetadata original, boolean archived, int autoArchiveDuration, String archiveTimestamp, Possible<Boolean> locked) {
        this.archived = archived;
        this.autoArchiveDuration = autoArchiveDuration;
        this.archiveTimestamp = archiveTimestamp;
        Possible<Boolean> locked$impl = locked;
        this.locked_value = locked$impl.toOptional().orElse(null);
        this.locked_absent = locked$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="archived")
    public boolean archived() {
        return this.archived;
    }

    @Override
    @JsonProperty(value="auto_archive_duration")
    public int autoArchiveDuration() {
        return this.autoArchiveDuration;
    }

    @Override
    @JsonProperty(value="archive_timestamp")
    public String archiveTimestamp() {
        return this.archiveTimestamp;
    }

    @Override
    @JsonProperty(value="locked")
    public Possible<Boolean> locked() {
        return this.locked_absent ? Possible.absent() : Possible.of((Object)this.locked_value);
    }

    public final ImmutableThreadMetadata withArchived(boolean value) {
        if (this.archived == value) {
            return this;
        }
        return new ImmutableThreadMetadata(this, value, this.autoArchiveDuration, this.archiveTimestamp, this.locked());
    }

    public final ImmutableThreadMetadata withAutoArchiveDuration(int value) {
        if (this.autoArchiveDuration == value) {
            return this;
        }
        return new ImmutableThreadMetadata(this, this.archived, value, this.archiveTimestamp, this.locked());
    }

    public final ImmutableThreadMetadata withArchiveTimestamp(String value) {
        String newValue = Objects.requireNonNull(value, "archiveTimestamp");
        if (this.archiveTimestamp.equals(newValue)) {
            return this;
        }
        return new ImmutableThreadMetadata(this, this.archived, this.autoArchiveDuration, newValue, this.locked());
    }

    public ImmutableThreadMetadata withLocked(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableThreadMetadata(this, this.archived, this.autoArchiveDuration, this.archiveTimestamp, newValue);
    }

    public ImmutableThreadMetadata withLocked(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableThreadMetadata(this, this.archived, this.autoArchiveDuration, this.archiveTimestamp, (Possible<Boolean>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableThreadMetadata && this.equalTo(0, (ImmutableThreadMetadata)another);
    }

    private boolean equalTo(int synthetic, ImmutableThreadMetadata another) {
        return this.archived == another.archived && this.autoArchiveDuration == another.autoArchiveDuration && this.archiveTimestamp.equals(another.archiveTimestamp) && this.locked().equals(another.locked());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.archived);
        h += (h << 5) + this.autoArchiveDuration;
        h += (h << 5) + this.archiveTimestamp.hashCode();
        h += (h << 5) + this.locked().hashCode();
        return h;
    }

    public String toString() {
        return "ThreadMetadata{archived=" + this.archived + ", autoArchiveDuration=" + this.autoArchiveDuration + ", archiveTimestamp=" + this.archiveTimestamp + ", locked=" + this.locked().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableThreadMetadata fromJson(Json json) {
        Builder builder = ImmutableThreadMetadata.builder();
        if (json.archivedIsSet) {
            builder.archived(json.archived);
        }
        if (json.autoArchiveDurationIsSet) {
            builder.autoArchiveDuration(json.autoArchiveDuration);
        }
        if (json.archiveTimestamp != null) {
            builder.archiveTimestamp(json.archiveTimestamp);
        }
        if (json.locked != null) {
            builder.locked(json.locked);
        }
        return builder.build();
    }

    public static ImmutableThreadMetadata of(boolean archived, int autoArchiveDuration, String archiveTimestamp, Possible<Boolean> locked) {
        return new ImmutableThreadMetadata(archived, autoArchiveDuration, archiveTimestamp, locked);
    }

    public static ImmutableThreadMetadata copyOf(ThreadMetadata instance) {
        if (instance instanceof ImmutableThreadMetadata) {
            return (ImmutableThreadMetadata)instance;
        }
        return ImmutableThreadMetadata.builder().from(instance).build();
    }

    public boolean isLockedPresent() {
        return !this.locked_absent;
    }

    public Boolean lockedOrElse(Boolean defaultValue) {
        return !this.locked_absent ? this.locked_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ThreadMetadata", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ARCHIVED = 1L;
        private static final long INIT_BIT_AUTO_ARCHIVE_DURATION = 2L;
        private static final long INIT_BIT_ARCHIVE_TIMESTAMP = 4L;
        private long initBits = 7L;
        private Possible<Boolean> locked_possible = Possible.absent();
        private boolean archived;
        private int autoArchiveDuration;
        private String archiveTimestamp;

        private Builder() {
        }

        public final Builder from(ThreadMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.archived(instance.archived());
            this.autoArchiveDuration(instance.autoArchiveDuration());
            this.archiveTimestamp(instance.archiveTimestamp());
            this.locked(instance.locked());
            return this;
        }

        @JsonProperty(value="archived")
        public final Builder archived(boolean archived) {
            this.archived = archived;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="auto_archive_duration")
        public final Builder autoArchiveDuration(int autoArchiveDuration) {
            this.autoArchiveDuration = autoArchiveDuration;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="archive_timestamp")
        public final Builder archiveTimestamp(String archiveTimestamp) {
            this.archiveTimestamp = Objects.requireNonNull(archiveTimestamp, "archiveTimestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="locked")
        public Builder locked(Possible<Boolean> value) {
            this.locked_possible = value;
            return this;
        }

        public Builder locked(Boolean value) {
            this.locked_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableThreadMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableThreadMetadata(null, this.archived, this.autoArchiveDuration, this.archiveTimestamp, this.locked_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("archived");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("autoArchiveDuration");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("archiveTimestamp");
            }
            return "Cannot build ThreadMetadata, some of required attributes are not set " + attributes;
        }

        private Possible<Boolean> locked_build() {
            return this.locked_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ThreadMetadata", generator="Immutables")
    static final class Json
    implements ThreadMetadata {
        boolean archived;
        boolean archivedIsSet;
        int autoArchiveDuration;
        boolean autoArchiveDurationIsSet;
        String archiveTimestamp;
        Possible<Boolean> locked = Possible.absent();

        Json() {
        }

        @JsonProperty(value="archived")
        public void setArchived(boolean archived) {
            this.archived = archived;
            this.archivedIsSet = true;
        }

        @JsonProperty(value="auto_archive_duration")
        public void setAutoArchiveDuration(int autoArchiveDuration) {
            this.autoArchiveDuration = autoArchiveDuration;
            this.autoArchiveDurationIsSet = true;
        }

        @JsonProperty(value="archive_timestamp")
        public void setArchiveTimestamp(String archiveTimestamp) {
            this.archiveTimestamp = archiveTimestamp;
        }

        @JsonProperty(value="locked")
        public void setLocked(Possible<Boolean> locked) {
            this.locked = locked;
        }

        @Override
        public boolean archived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int autoArchiveDuration() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String archiveTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> locked() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ThreadMetadata", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ThreadMetadata, attribute initializers form cycle " + attributes;
        }
    }
}

