/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ReadyData;
import discord4j.discordjson.json.UnavailableGuildData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="ReadyData", generator="Immutables")
public final class ImmutableReadyData
implements ReadyData {
    private final int v;
    private final UserData user;
    private final List<UnavailableGuildData> guilds;
    private final String sessionId;
    private final List<Integer> shard_value;
    private final boolean shard_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReadyData(int v, UserData user, Iterable<? extends UnavailableGuildData> guilds, String sessionId, Possible<List<Integer>> shard) {
        this.v = v;
        this.user = Objects.requireNonNull(user, "user");
        this.guilds = ImmutableReadyData.createUnmodifiableList(false, ImmutableReadyData.createSafeList(guilds, true, false));
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId");
        Possible<List<Integer>> shard$impl = shard;
        this.shard_value = shard$impl.toOptional().orElse(null);
        this.shard_absent = shard$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableReadyData(ImmutableReadyData original, int v, UserData user, List<UnavailableGuildData> guilds, String sessionId, Possible<List<Integer>> shard) {
        this.v = v;
        this.user = user;
        this.guilds = guilds;
        this.sessionId = sessionId;
        Possible<List<Integer>> shard$impl = shard;
        this.shard_value = shard$impl.toOptional().orElse(null);
        this.shard_absent = shard$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="v")
    public int v() {
        return this.v;
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="guilds")
    public List<UnavailableGuildData> guilds() {
        return this.guilds;
    }

    @Override
    @JsonProperty(value="session_id")
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="shard")
    public Possible<List<Integer>> shard() {
        return this.shard_absent ? Possible.absent() : Possible.of(this.shard_value);
    }

    public final ImmutableReadyData withV(int value) {
        if (this.v == value) {
            return this;
        }
        return new ImmutableReadyData(this, value, this.user, this.guilds, this.sessionId, this.shard());
    }

    public final ImmutableReadyData withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableReadyData(this, this.v, newValue, this.guilds, this.sessionId, this.shard());
    }

    public final ImmutableReadyData withGuilds(UnavailableGuildData ... elements) {
        List<UnavailableGuildData> newValue = ImmutableReadyData.createUnmodifiableList(false, ImmutableReadyData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReadyData(this, this.v, this.user, newValue, this.sessionId, this.shard());
    }

    public final ImmutableReadyData withGuilds(Iterable<? extends UnavailableGuildData> elements) {
        if (this.guilds == elements) {
            return this;
        }
        List<UnavailableGuildData> newValue = ImmutableReadyData.createUnmodifiableList(false, ImmutableReadyData.createSafeList(elements, true, false));
        return new ImmutableReadyData(this, this.v, this.user, newValue, this.sessionId, this.shard());
    }

    public final ImmutableReadyData withSessionId(String value) {
        String newValue = Objects.requireNonNull(value, "sessionId");
        if (this.sessionId.equals(newValue)) {
            return this;
        }
        return new ImmutableReadyData(this, this.v, this.user, this.guilds, newValue, this.shard());
    }

    public ImmutableReadyData withShard(Possible<? extends List<? extends Integer>> possible) {
        Possible<? extends List<? extends Integer>> newValue = Objects.requireNonNull(possible);
        return new ImmutableReadyData(this, this.v, this.user, this.guilds, this.sessionId, newValue);
    }

    public ImmutableReadyData withShard(Iterable<? extends Integer> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableReadyData(this, this.v, this.user, this.guilds, this.sessionId, (Possible<List<Integer>>)newValue);
    }

    @SafeVarargs
    public final ImmutableReadyData withShard(Integer ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableReadyData(this, this.v, this.user, this.guilds, this.sessionId, (Possible<List<Integer>>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReadyData && this.equalTo(0, (ImmutableReadyData)another);
    }

    private boolean equalTo(int synthetic, ImmutableReadyData another) {
        return this.v == another.v && this.user.equals(another.user) && this.guilds.equals(another.guilds) && this.sessionId.equals(another.sessionId) && Objects.equals(this.shard_value, another.shard_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.v;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.guilds.hashCode();
        h += (h << 5) + this.sessionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.shard_value);
        return h;
    }

    public String toString() {
        return "ReadyData{v=" + this.v + ", user=" + this.user + ", guilds=" + this.guilds + ", sessionId=" + this.sessionId + ", shard=" + Objects.toString(this.shard_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReadyData fromJson(Json json) {
        Builder builder = ImmutableReadyData.builder();
        if (json.vIsSet) {
            builder.v(json.v);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.guilds != null) {
            builder.addAllGuilds(json.guilds);
        }
        if (json.sessionId != null) {
            builder.sessionId(json.sessionId);
        }
        if (json.shard != null) {
            builder.shard(json.shard);
        }
        return builder.build();
    }

    public static ImmutableReadyData of(int v, UserData user, List<UnavailableGuildData> guilds, String sessionId, Possible<List<Integer>> shard) {
        return ImmutableReadyData.of(v, user, guilds, sessionId, shard);
    }

    public static ImmutableReadyData of(int v, UserData user, Iterable<? extends UnavailableGuildData> guilds, String sessionId, Possible<List<Integer>> shard) {
        return new ImmutableReadyData(v, user, guilds, sessionId, shard);
    }

    public static ImmutableReadyData copyOf(ReadyData instance) {
        if (instance instanceof ImmutableReadyData) {
            return (ImmutableReadyData)instance;
        }
        return ImmutableReadyData.builder().from(instance).build();
    }

    public boolean isShardPresent() {
        return !this.shard_absent;
    }

    public List<Integer> shardOrElse(List<Integer> defaultValue) {
        return !this.shard_absent ? this.shard_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ReadyData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_V = 1L;
        private static final long INIT_BIT_USER = 2L;
        private static final long INIT_BIT_SESSION_ID = 4L;
        private long initBits = 7L;
        private List<Integer> shard_list = null;
        private int v;
        private UserData user;
        private List<UnavailableGuildData> guilds = new ArrayList<UnavailableGuildData>();
        private String sessionId;

        private Builder() {
        }

        public final Builder from(ReadyData instance) {
            Objects.requireNonNull(instance, "instance");
            this.v(instance.v());
            this.user(instance.user());
            this.addAllGuilds(instance.guilds());
            this.sessionId(instance.sessionId());
            this.shard(instance.shard());
            return this;
        }

        @JsonProperty(value="v")
        public final Builder v(int v) {
            this.v = v;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addGuild(UnavailableGuildData element) {
            this.guilds.add(Objects.requireNonNull(element, "guilds element"));
            return this;
        }

        public final Builder addGuilds(UnavailableGuildData ... elements) {
            for (UnavailableGuildData element : elements) {
                this.guilds.add(Objects.requireNonNull(element, "guilds element"));
            }
            return this;
        }

        @JsonProperty(value="guilds")
        public final Builder guilds(Iterable<? extends UnavailableGuildData> elements) {
            this.guilds.clear();
            return this.addAllGuilds(elements);
        }

        public final Builder addAllGuilds(Iterable<? extends UnavailableGuildData> elements) {
            for (UnavailableGuildData unavailableGuildData : elements) {
                this.guilds.add(Objects.requireNonNull(unavailableGuildData, "guilds element"));
            }
            return this;
        }

        @JsonProperty(value="session_id")
        public final Builder sessionId(String sessionId) {
            this.sessionId = Objects.requireNonNull(sessionId, "sessionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder addShard(Integer element) {
            this.shard_getOrCreate().add(element);
            return this;
        }

        public Builder addAllShard(Collection<? extends Integer> elements) {
            this.shard_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="shard")
        public Builder shard(Possible<? extends Collection<? extends Integer>> elements) {
            this.shard_list = null;
            elements.toOptional().ifPresent(e -> this.shard_getOrCreate().addAll((Collection<Integer>)e));
            return this;
        }

        public Builder shard(Iterable<? extends Integer> elements) {
            this.shard_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @SafeVarargs
        public final Builder shard(Integer ... elements) {
            this.shard_list = Arrays.asList(elements);
            return this;
        }

        public ImmutableReadyData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReadyData(null, this.v, this.user, ImmutableReadyData.createUnmodifiableList(true, this.guilds), this.sessionId, this.shard_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("v");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sessionId");
            }
            return "Cannot build ReadyData, some of required attributes are not set " + attributes;
        }

        private Possible<List<Integer>> shard_build() {
            return this.shard_list == null ? Possible.absent() : Possible.of(this.shard_list);
        }

        private List<Integer> shard_getOrCreate() {
            if (this.shard_list == null) {
                this.shard_list = new ArrayList<Integer>();
            }
            return this.shard_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReadyData", generator="Immutables")
    static final class Json
    implements ReadyData {
        int v;
        boolean vIsSet;
        UserData user;
        List<UnavailableGuildData> guilds = Collections.emptyList();
        String sessionId;
        Possible<List<Integer>> shard = Possible.absent();

        Json() {
        }

        @JsonProperty(value="v")
        public void setV(int v) {
            this.v = v;
            this.vIsSet = true;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="guilds")
        public void setGuilds(List<UnavailableGuildData> guilds) {
            this.guilds = guilds;
        }

        @JsonProperty(value="session_id")
        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @JsonProperty(value="shard")
        public void setShard(Possible<List<Integer>> shard) {
            this.shard = shard;
        }

        @Override
        public int v() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UnavailableGuildData> guilds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<Integer>> shard() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ReadyData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ReadyData, attribute initializers form cycle " + attributes;
        }
    }
}

