/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.OnboardingData;
import discord4j.discordjson.json.OnboardingPromptData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="OnboardingData", generator="Immutables")
public final class ImmutableOnboardingData
implements OnboardingData {
    private final long guildId_value;
    private final List<OnboardingPromptData> prompts;
    private final long[] defaultChannelIds_value;
    private final boolean enabled;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOnboardingData(Id guildId, Iterable<? extends OnboardingPromptData> prompts, List<Id> defaultChannelIds, boolean enabled) {
        Id guildId$impl = guildId;
        this.prompts = ImmutableOnboardingData.createUnmodifiableList(false, ImmutableOnboardingData.createSafeList(prompts, true, false));
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.guildId_value = guildId$impl.asLong();
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableOnboardingData(ImmutableOnboardingData original, Id guildId, List<OnboardingPromptData> prompts, List<Id> defaultChannelIds, boolean enabled) {
        Id guildId$impl = guildId;
        this.prompts = prompts;
        List<Id> defaultChannelIds$impl = defaultChannelIds;
        this.enabled = enabled;
        this.guildId_value = guildId$impl.asLong();
        this.defaultChannelIds_value = defaultChannelIds$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="prompts")
    public List<OnboardingPromptData> prompts() {
        return this.prompts;
    }

    @Override
    @JsonProperty(value="default_channel_ids")
    public List<Id> defaultChannelIds() {
        return LongStream.of(this.defaultChannelIds_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    public ImmutableOnboardingData withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableOnboardingData(this, newValue, this.prompts, this.defaultChannelIds(), this.enabled);
    }

    public ImmutableOnboardingData withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableOnboardingData(this, newValue, this.prompts, this.defaultChannelIds(), this.enabled);
    }

    public final ImmutableOnboardingData withPrompts(OnboardingPromptData ... elements) {
        List<OnboardingPromptData> newValue = ImmutableOnboardingData.createUnmodifiableList(false, ImmutableOnboardingData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableOnboardingData(this, this.guildId(), newValue, this.defaultChannelIds(), this.enabled);
    }

    public final ImmutableOnboardingData withPrompts(Iterable<? extends OnboardingPromptData> elements) {
        if (this.prompts == elements) {
            return this;
        }
        List<OnboardingPromptData> newValue = ImmutableOnboardingData.createUnmodifiableList(false, ImmutableOnboardingData.createSafeList(elements, true, false));
        return new ImmutableOnboardingData(this, this.guildId(), newValue, this.defaultChannelIds(), this.enabled);
    }

    public ImmutableOnboardingData withDefaultChannelIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableOnboardingData(this, this.guildId(), this.prompts, newValue, this.enabled);
    }

    public final ImmutableOnboardingData withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableOnboardingData(this, this.guildId(), this.prompts, this.defaultChannelIds(), value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnboardingData && this.equalTo(0, (ImmutableOnboardingData)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnboardingData another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && this.prompts.equals(another.prompts) && Objects.equals(this.defaultChannelIds_value, another.defaultChannelIds_value) && this.enabled == another.enabled;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.prompts.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultChannelIds_value);
        h += (h << 5) + Boolean.hashCode(this.enabled);
        return h;
    }

    public String toString() {
        return "OnboardingData{guildId=" + Objects.toString(this.guildId_value) + ", prompts=" + this.prompts + ", defaultChannelIds=" + Objects.toString(this.defaultChannelIds_value) + ", enabled=" + this.enabled + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnboardingData fromJson(Json json) {
        Builder builder = ImmutableOnboardingData.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.prompts != null) {
            builder.addAllPrompts(json.prompts);
        }
        if (json.defaultChannelIds != null) {
            builder.defaultChannelIds(json.defaultChannelIds);
        }
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        return builder.build();
    }

    public static ImmutableOnboardingData of(Id guildId, List<OnboardingPromptData> prompts, List<Id> defaultChannelIds, boolean enabled) {
        return ImmutableOnboardingData.of(guildId, prompts, defaultChannelIds, enabled);
    }

    public static ImmutableOnboardingData of(Id guildId, Iterable<? extends OnboardingPromptData> prompts, List<Id> defaultChannelIds, boolean enabled) {
        return new ImmutableOnboardingData(guildId, prompts, defaultChannelIds, enabled);
    }

    public static ImmutableOnboardingData copyOf(OnboardingData instance) {
        if (instance instanceof ImmutableOnboardingData) {
            return (ImmutableOnboardingData)instance;
        }
        return ImmutableOnboardingData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="OnboardingData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private long initBits = 1L;
        private Id guildId_id = null;
        private List<Long> defaultChannelIds_list = null;
        private List<OnboardingPromptData> prompts = new ArrayList<OnboardingPromptData>();
        private boolean enabled;

        private Builder() {
        }

        public final Builder from(OnboardingData instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.addAllPrompts(instance.prompts());
            this.defaultChannelIds(instance.defaultChannelIds());
            this.enabled(instance.enabled());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        public final Builder addPrompt(OnboardingPromptData element) {
            this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            return this;
        }

        public final Builder addPrompts(OnboardingPromptData ... elements) {
            for (OnboardingPromptData element : elements) {
                this.prompts.add(Objects.requireNonNull(element, "prompts element"));
            }
            return this;
        }

        @JsonProperty(value="prompts")
        public final Builder prompts(Iterable<? extends OnboardingPromptData> elements) {
            this.prompts.clear();
            return this.addAllPrompts(elements);
        }

        public final Builder addAllPrompts(Iterable<? extends OnboardingPromptData> elements) {
            for (OnboardingPromptData onboardingPromptData : elements) {
                this.prompts.add(Objects.requireNonNull(onboardingPromptData, "prompts element"));
            }
            return this;
        }

        public Builder addDefaultChannelId(long element) {
            this.defaultChannelIds_getOrCreate().add(element);
            return this;
        }

        public Builder addDefaultChannelId(String element) {
            this.defaultChannelIds_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addDefaultChannelId(Id element) {
            this.defaultChannelIds_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllDefaultChannelIds(List<Long> elements) {
            this.defaultChannelIds_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="default_channel_ids")
        public Builder defaultChannelIds(List<Id> elements) {
            this.defaultChannelIds_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder defaultChannelIds(Iterable<Id> elements) {
            this.defaultChannelIds_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="enabled")
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableOnboardingData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnboardingData(null, this.guildId_build(), ImmutableOnboardingData.createUnmodifiableList(true, this.prompts), this.defaultChannelIds_build(), this.enabled);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build OnboardingData, some of required attributes are not set " + attributes;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private List<Id> defaultChannelIds_build() {
            return this.defaultChannelIds_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> defaultChannelIds_getOrCreate() {
            if (this.defaultChannelIds_list == null) {
                this.defaultChannelIds_list = new ArrayList<Long>();
            }
            return this.defaultChannelIds_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OnboardingData", generator="Immutables")
    static final class Json
    implements OnboardingData {
        Id guildId;
        List<OnboardingPromptData> prompts = Collections.emptyList();
        List<Id> defaultChannelIds;
        boolean enabled;
        boolean enabledIsSet;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="prompts")
        public void setPrompts(List<OnboardingPromptData> prompts) {
            this.prompts = prompts;
        }

        @JsonProperty(value="default_channel_ids")
        public void setDefaultChannelIds(List<Id> defaultChannelIds) {
            this.defaultChannelIds = defaultChannelIds;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OnboardingPromptData> prompts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> defaultChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="OnboardingData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingData, attribute initializers form cycle " + attributes;
        }
    }
}

