/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.AccessTokenData;
import discord4j.discordjson.json.GuildUpdateData;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AccessTokenData", generator="Immutables")
public final class ImmutableAccessTokenData
implements AccessTokenData {
    private final String accessToken;
    private final String tokenType;
    private final long expiresIn;
    private final GuildUpdateData guild_value;
    private final boolean guild_absent;
    private final String refreshToken_value;
    private final boolean refreshToken_absent;
    private final String scope;
    private final WebhookData webhook_value;
    private final boolean webhook_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccessTokenData(String accessToken, String tokenType, long expiresIn, Possible<GuildUpdateData> guild, Possible<String> refreshToken, String scope, Possible<WebhookData> webhook) {
        this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
        this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
        this.expiresIn = expiresIn;
        Possible<GuildUpdateData> guild$impl = guild;
        Possible<String> refreshToken$impl = refreshToken;
        this.scope = Objects.requireNonNull(scope, "scope");
        Possible<WebhookData> webhook$impl = webhook;
        this.guild_value = guild$impl.toOptional().orElse(null);
        this.guild_absent = guild$impl.isAbsent();
        this.refreshToken_value = refreshToken$impl.toOptional().orElse(null);
        this.refreshToken_absent = refreshToken$impl.isAbsent();
        this.webhook_value = webhook$impl.toOptional().orElse(null);
        this.webhook_absent = webhook$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableAccessTokenData(ImmutableAccessTokenData original, String accessToken, String tokenType, long expiresIn, Possible<GuildUpdateData> guild, Possible<String> refreshToken, String scope, Possible<WebhookData> webhook) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
        Possible<GuildUpdateData> guild$impl = guild;
        Possible<String> refreshToken$impl = refreshToken;
        this.scope = scope;
        Possible<WebhookData> webhook$impl = webhook;
        this.guild_value = guild$impl.toOptional().orElse(null);
        this.guild_absent = guild$impl.isAbsent();
        this.refreshToken_value = refreshToken$impl.toOptional().orElse(null);
        this.refreshToken_absent = refreshToken$impl.isAbsent();
        this.webhook_value = webhook$impl.toOptional().orElse(null);
        this.webhook_absent = webhook$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="access_token")
    public String accessToken() {
        return this.accessToken;
    }

    @Override
    @JsonProperty(value="token_type")
    public String tokenType() {
        return this.tokenType;
    }

    @Override
    @JsonProperty(value="expires_in")
    public long expiresIn() {
        return this.expiresIn;
    }

    @Override
    @JsonProperty(value="guild")
    public Possible<GuildUpdateData> guild() {
        return this.guild_absent ? Possible.absent() : Possible.of((Object)this.guild_value);
    }

    @Override
    @JsonProperty(value="refresh_token")
    public Possible<String> refreshToken() {
        return this.refreshToken_absent ? Possible.absent() : Possible.of((Object)this.refreshToken_value);
    }

    @Override
    @JsonProperty(value="scope")
    public String scope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="webhook")
    public Possible<WebhookData> webhook() {
        return this.webhook_absent ? Possible.absent() : Possible.of((Object)this.webhook_value);
    }

    public final ImmutableAccessTokenData withAccessToken(String value) {
        String newValue = Objects.requireNonNull(value, "accessToken");
        if (this.accessToken.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessTokenData(this, newValue, this.tokenType, this.expiresIn, this.guild(), this.refreshToken(), this.scope, this.webhook());
    }

    public final ImmutableAccessTokenData withTokenType(String value) {
        String newValue = Objects.requireNonNull(value, "tokenType");
        if (this.tokenType.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessTokenData(this, this.accessToken, newValue, this.expiresIn, this.guild(), this.refreshToken(), this.scope, this.webhook());
    }

    public final ImmutableAccessTokenData withExpiresIn(long value) {
        if (this.expiresIn == value) {
            return this;
        }
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, value, this.guild(), this.refreshToken(), this.scope, this.webhook());
    }

    public ImmutableAccessTokenData withGuild(Possible<GuildUpdateData> value) {
        Possible<GuildUpdateData> newValue = Objects.requireNonNull(value);
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, this.expiresIn, newValue, this.refreshToken(), this.scope, this.webhook());
    }

    public ImmutableAccessTokenData withGuild(GuildUpdateData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, this.expiresIn, (Possible<GuildUpdateData>)newValue, this.refreshToken(), this.scope, this.webhook());
    }

    public ImmutableAccessTokenData withRefreshToken(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, this.expiresIn, this.guild(), newValue, this.scope, this.webhook());
    }

    public ImmutableAccessTokenData withRefreshToken(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, this.expiresIn, this.guild(), (Possible<String>)newValue, this.scope, this.webhook());
    }

    public final ImmutableAccessTokenData withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (this.scope.equals(newValue)) {
            return this;
        }
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, this.expiresIn, this.guild(), this.refreshToken(), newValue, this.webhook());
    }

    public ImmutableAccessTokenData withWebhook(Possible<WebhookData> value) {
        Possible<WebhookData> newValue = Objects.requireNonNull(value);
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, this.expiresIn, this.guild(), this.refreshToken(), this.scope, newValue);
    }

    public ImmutableAccessTokenData withWebhook(WebhookData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableAccessTokenData(this, this.accessToken, this.tokenType, this.expiresIn, this.guild(), this.refreshToken(), this.scope, (Possible<WebhookData>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccessTokenData && this.equalTo(0, (ImmutableAccessTokenData)another);
    }

    private boolean equalTo(int synthetic, ImmutableAccessTokenData another) {
        return this.accessToken.equals(another.accessToken) && this.tokenType.equals(another.tokenType) && this.expiresIn == another.expiresIn && this.guild().equals(another.guild()) && this.refreshToken().equals(another.refreshToken()) && this.scope.equals(another.scope) && this.webhook().equals(another.webhook());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessToken.hashCode();
        h += (h << 5) + this.tokenType.hashCode();
        h += (h << 5) + Long.hashCode(this.expiresIn);
        h += (h << 5) + this.guild().hashCode();
        h += (h << 5) + this.refreshToken().hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.webhook().hashCode();
        return h;
    }

    public String toString() {
        return "AccessTokenData{accessToken=" + this.accessToken + ", tokenType=" + this.tokenType + ", expiresIn=" + this.expiresIn + ", guild=" + this.guild().toString() + ", refreshToken=" + this.refreshToken().toString() + ", scope=" + this.scope + ", webhook=" + this.webhook().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccessTokenData fromJson(Json json) {
        Builder builder = ImmutableAccessTokenData.builder();
        if (json.accessToken != null) {
            builder.accessToken(json.accessToken);
        }
        if (json.tokenType != null) {
            builder.tokenType(json.tokenType);
        }
        if (json.expiresInIsSet) {
            builder.expiresIn(json.expiresIn);
        }
        if (json.guild != null) {
            builder.guild(json.guild);
        }
        if (json.refreshToken != null) {
            builder.refreshToken(json.refreshToken);
        }
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.webhook != null) {
            builder.webhook(json.webhook);
        }
        return builder.build();
    }

    public static ImmutableAccessTokenData of(String accessToken, String tokenType, long expiresIn, Possible<GuildUpdateData> guild, Possible<String> refreshToken, String scope, Possible<WebhookData> webhook) {
        return new ImmutableAccessTokenData(accessToken, tokenType, expiresIn, guild, refreshToken, scope, webhook);
    }

    public static ImmutableAccessTokenData copyOf(AccessTokenData instance) {
        if (instance instanceof ImmutableAccessTokenData) {
            return (ImmutableAccessTokenData)instance;
        }
        return ImmutableAccessTokenData.builder().from(instance).build();
    }

    public boolean isGuildPresent() {
        return !this.guild_absent;
    }

    public GuildUpdateData guildOrElse(GuildUpdateData defaultValue) {
        return !this.guild_absent ? this.guild_value : defaultValue;
    }

    public boolean isRefreshTokenPresent() {
        return !this.refreshToken_absent;
    }

    public String refreshTokenOrElse(String defaultValue) {
        return !this.refreshToken_absent ? this.refreshToken_value : defaultValue;
    }

    public boolean isWebhookPresent() {
        return !this.webhook_absent;
    }

    public WebhookData webhookOrElse(WebhookData defaultValue) {
        return !this.webhook_absent ? this.webhook_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccessTokenData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACCESS_TOKEN = 1L;
        private static final long INIT_BIT_TOKEN_TYPE = 2L;
        private static final long INIT_BIT_EXPIRES_IN = 4L;
        private static final long INIT_BIT_SCOPE = 8L;
        private long initBits = 15L;
        private Possible<GuildUpdateData> guild_possible = Possible.absent();
        private Possible<String> refreshToken_possible = Possible.absent();
        private Possible<WebhookData> webhook_possible = Possible.absent();
        private String accessToken;
        private String tokenType;
        private long expiresIn;
        private String scope;

        private Builder() {
        }

        public final Builder from(AccessTokenData instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessToken(instance.accessToken());
            this.tokenType(instance.tokenType());
            this.expiresIn(instance.expiresIn());
            this.guild(instance.guild());
            this.refreshToken(instance.refreshToken());
            this.scope(instance.scope());
            this.webhook(instance.webhook());
            return this;
        }

        @JsonProperty(value="access_token")
        public final Builder accessToken(String accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="token_type")
        public final Builder tokenType(String tokenType) {
            this.tokenType = Objects.requireNonNull(tokenType, "tokenType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expires_in")
        public final Builder expiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="guild")
        public Builder guild(Possible<GuildUpdateData> value) {
            this.guild_possible = value;
            return this;
        }

        public Builder guild(GuildUpdateData value) {
            this.guild_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="refresh_token")
        public Builder refreshToken(Possible<String> value) {
            this.refreshToken_possible = value;
            return this;
        }

        public Builder refreshToken(String value) {
            this.refreshToken_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="scope")
        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="webhook")
        public Builder webhook(Possible<WebhookData> value) {
            this.webhook_possible = value;
            return this;
        }

        public Builder webhook(WebhookData value) {
            this.webhook_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableAccessTokenData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccessTokenData(null, this.accessToken, this.tokenType, this.expiresIn, this.guild_build(), this.refreshToken_build(), this.scope, this.webhook_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessToken");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expiresIn");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build AccessTokenData, some of required attributes are not set " + attributes;
        }

        private Possible<GuildUpdateData> guild_build() {
            return this.guild_possible;
        }

        private Possible<String> refreshToken_build() {
            return this.refreshToken_possible;
        }

        private Possible<WebhookData> webhook_build() {
            return this.webhook_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccessTokenData", generator="Immutables")
    static final class Json
    implements AccessTokenData {
        String accessToken;
        String tokenType;
        long expiresIn;
        boolean expiresInIsSet;
        Possible<GuildUpdateData> guild = Possible.absent();
        Possible<String> refreshToken = Possible.absent();
        String scope;
        Possible<WebhookData> webhook = Possible.absent();

        Json() {
        }

        @JsonProperty(value="access_token")
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @JsonProperty(value="token_type")
        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        @JsonProperty(value="expires_in")
        public void setExpiresIn(long expiresIn) {
            this.expiresIn = expiresIn;
            this.expiresInIsSet = true;
        }

        @JsonProperty(value="guild")
        public void setGuild(Possible<GuildUpdateData> guild) {
            this.guild = guild;
        }

        @JsonProperty(value="refresh_token")
        public void setRefreshToken(Possible<String> refreshToken) {
            this.refreshToken = refreshToken;
        }

        @JsonProperty(value="scope")
        public void setScope(String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="webhook")
        public void setWebhook(Possible<WebhookData> webhook) {
            this.webhook = webhook;
        }

        @Override
        public String accessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String tokenType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long expiresIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<GuildUpdateData> guild() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> refreshToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String scope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<WebhookData> webhook() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccessTokenData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build AccessTokenData, attribute initializers form cycle " + attributes;
        }
    }
}

