/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.PartialApplicationInfoData;
import discord4j.discordjson.json.UnavailableGuildData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="Ready", generator="Immutables")
public final class ImmutableReady
implements Ready {
    private final int v;
    private final UserData user;
    private final List<ChannelData> privateChannels;
    private final List<UnavailableGuildData> guilds;
    private final String sessionId;
    private final int[] shard_value;
    private final boolean shard_absent;
    private final List<String> trace;
    private final PartialApplicationInfoData application;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableReady(int v, UserData user, Iterable<? extends ChannelData> privateChannels, Iterable<? extends UnavailableGuildData> guilds, String sessionId, Possible<int[]> shard, Iterable<String> trace, PartialApplicationInfoData application) {
        this.v = v;
        this.user = Objects.requireNonNull(user, "user");
        this.privateChannels = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(privateChannels, true, false));
        this.guilds = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(guilds, true, false));
        this.sessionId = Objects.requireNonNull(sessionId, "sessionId");
        Possible<int[]> shard$impl = shard;
        this.trace = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(trace, true, false));
        this.application = Objects.requireNonNull(application, "application");
        this.shard_value = shard$impl.toOptional().orElse(null);
        this.shard_absent = shard$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableReady(ImmutableReady original, int v, UserData user, List<ChannelData> privateChannels, List<UnavailableGuildData> guilds, String sessionId, Possible<int[]> shard, List<String> trace, PartialApplicationInfoData application) {
        this.v = v;
        this.user = user;
        this.privateChannels = privateChannels;
        this.guilds = guilds;
        this.sessionId = sessionId;
        Possible<int[]> shard$impl = shard;
        this.trace = trace;
        this.application = application;
        this.shard_value = shard$impl.toOptional().orElse(null);
        this.shard_absent = shard$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="v")
    public int v() {
        return this.v;
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="private_channels")
    public List<ChannelData> privateChannels() {
        return this.privateChannels;
    }

    @Override
    @JsonProperty(value="guilds")
    public List<UnavailableGuildData> guilds() {
        return this.guilds;
    }

    @Override
    @JsonProperty(value="session_id")
    public String sessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="shard")
    public Possible<int[]> shard() {
        return this.shard_absent ? Possible.absent() : Possible.of((Object)this.shard_value);
    }

    @Override
    @JsonProperty(value="_trace")
    public List<String> trace() {
        return this.trace;
    }

    @Override
    @JsonProperty(value="application")
    public PartialApplicationInfoData application() {
        return this.application;
    }

    public final ImmutableReady withV(int value) {
        if (this.v == value) {
            return this;
        }
        return new ImmutableReady(this, value, this.user, this.privateChannels, this.guilds, this.sessionId, this.shard(), this.trace, this.application);
    }

    public final ImmutableReady withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableReady(this, this.v, newValue, this.privateChannels, this.guilds, this.sessionId, this.shard(), this.trace, this.application);
    }

    public final ImmutableReady withPrivateChannels(ChannelData ... elements) {
        List<ChannelData> newValue = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReady(this, this.v, this.user, newValue, this.guilds, this.sessionId, this.shard(), this.trace, this.application);
    }

    public final ImmutableReady withPrivateChannels(Iterable<? extends ChannelData> elements) {
        if (this.privateChannels == elements) {
            return this;
        }
        List<ChannelData> newValue = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(elements, true, false));
        return new ImmutableReady(this, this.v, this.user, newValue, this.guilds, this.sessionId, this.shard(), this.trace, this.application);
    }

    public final ImmutableReady withGuilds(UnavailableGuildData ... elements) {
        List<UnavailableGuildData> newValue = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, newValue, this.sessionId, this.shard(), this.trace, this.application);
    }

    public final ImmutableReady withGuilds(Iterable<? extends UnavailableGuildData> elements) {
        if (this.guilds == elements) {
            return this;
        }
        List<UnavailableGuildData> newValue = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(elements, true, false));
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, newValue, this.sessionId, this.shard(), this.trace, this.application);
    }

    public final ImmutableReady withSessionId(String value) {
        String newValue = Objects.requireNonNull(value, "sessionId");
        if (this.sessionId.equals(newValue)) {
            return this;
        }
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, this.guilds, newValue, this.shard(), this.trace, this.application);
    }

    public ImmutableReady withShard(Possible<int[]> value) {
        Possible<int[]> newValue = Objects.requireNonNull(value);
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, this.guilds, this.sessionId, newValue, this.trace, this.application);
    }

    public ImmutableReady withShard(int[] value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, this.guilds, this.sessionId, (Possible<int[]>)newValue, this.trace, this.application);
    }

    public final ImmutableReady withTrace(String ... elements) {
        List<String> newValue = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, this.guilds, this.sessionId, this.shard(), newValue, this.application);
    }

    public final ImmutableReady withTrace(Iterable<String> elements) {
        if (this.trace == elements) {
            return this;
        }
        List<String> newValue = ImmutableReady.createUnmodifiableList(false, ImmutableReady.createSafeList(elements, true, false));
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, this.guilds, this.sessionId, this.shard(), newValue, this.application);
    }

    public final ImmutableReady withApplication(PartialApplicationInfoData value) {
        if (this.application == value) {
            return this;
        }
        PartialApplicationInfoData newValue = Objects.requireNonNull(value, "application");
        return new ImmutableReady(this, this.v, this.user, this.privateChannels, this.guilds, this.sessionId, this.shard(), this.trace, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReady && this.equalTo((ImmutableReady)another);
    }

    private boolean equalTo(ImmutableReady another) {
        return this.v == another.v && this.user.equals(another.user) && this.privateChannels.equals(another.privateChannels) && this.guilds.equals(another.guilds) && this.sessionId.equals(another.sessionId) && this.shard().equals(another.shard()) && this.trace.equals(another.trace) && this.application.equals(another.application);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.v;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.privateChannels.hashCode();
        h += (h << 5) + this.guilds.hashCode();
        h += (h << 5) + this.sessionId.hashCode();
        h += (h << 5) + this.shard().hashCode();
        h += (h << 5) + this.trace.hashCode();
        h += (h << 5) + this.application.hashCode();
        return h;
    }

    public String toString() {
        return "Ready{v=" + this.v + ", user=" + this.user + ", privateChannels=" + this.privateChannels + ", guilds=" + this.guilds + ", sessionId=" + this.sessionId + ", shard=" + this.shard().toString() + ", trace=" + this.trace + ", application=" + this.application + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReady fromJson(Json json) {
        Builder builder = ImmutableReady.builder();
        if (json.vIsSet) {
            builder.v(json.v);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.privateChannels != null) {
            builder.addAllPrivateChannels(json.privateChannels);
        }
        if (json.guilds != null) {
            builder.addAllGuilds(json.guilds);
        }
        if (json.sessionId != null) {
            builder.sessionId(json.sessionId);
        }
        if (json.shard != null) {
            builder.shard(json.shard);
        }
        if (json.trace != null) {
            builder.addAllTrace(json.trace);
        }
        if (json.application != null) {
            builder.application(json.application);
        }
        return builder.build();
    }

    public static ImmutableReady of(int v, UserData user, List<ChannelData> privateChannels, List<UnavailableGuildData> guilds, String sessionId, Possible<int[]> shard, List<String> trace, PartialApplicationInfoData application) {
        return ImmutableReady.of(v, user, privateChannels, guilds, sessionId, shard, trace, application);
    }

    public static ImmutableReady of(int v, UserData user, Iterable<? extends ChannelData> privateChannels, Iterable<? extends UnavailableGuildData> guilds, String sessionId, Possible<int[]> shard, Iterable<String> trace, PartialApplicationInfoData application) {
        return new ImmutableReady(v, user, privateChannels, guilds, sessionId, shard, trace, application);
    }

    public static ImmutableReady copyOf(Ready instance) {
        if (instance instanceof ImmutableReady) {
            return (ImmutableReady)instance;
        }
        return ImmutableReady.builder().from(instance).build();
    }

    public boolean isShardPresent() {
        return !this.shard_absent;
    }

    public int[] shardOrElse(int[] defaultValue) {
        return !this.shard_absent ? this.shard_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Ready", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_V = 1L;
        private static final long INIT_BIT_USER = 2L;
        private static final long INIT_BIT_SESSION_ID = 4L;
        private static final long INIT_BIT_APPLICATION = 8L;
        private long initBits = 15L;
        private Possible<int[]> shard_possible = Possible.absent();
        private int v;
        private UserData user;
        private List<ChannelData> privateChannels = new ArrayList<ChannelData>();
        private List<UnavailableGuildData> guilds = new ArrayList<UnavailableGuildData>();
        private String sessionId;
        private List<String> trace = new ArrayList<String>();
        private PartialApplicationInfoData application;

        private Builder() {
        }

        public final Builder from(Ready instance) {
            Objects.requireNonNull(instance, "instance");
            this.v(instance.v());
            this.user(instance.user());
            this.addAllPrivateChannels(instance.privateChannels());
            this.addAllGuilds(instance.guilds());
            this.sessionId(instance.sessionId());
            this.shard(instance.shard());
            this.addAllTrace(instance.trace());
            this.application(instance.application());
            return this;
        }

        @JsonProperty(value="v")
        public final Builder v(int v) {
            this.v = v;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addPrivateChannel(ChannelData element) {
            this.privateChannels.add(Objects.requireNonNull(element, "privateChannels element"));
            return this;
        }

        public final Builder addPrivateChannels(ChannelData ... elements) {
            for (ChannelData element : elements) {
                this.privateChannels.add(Objects.requireNonNull(element, "privateChannels element"));
            }
            return this;
        }

        @JsonProperty(value="private_channels")
        public final Builder privateChannels(Iterable<? extends ChannelData> elements) {
            this.privateChannels.clear();
            return this.addAllPrivateChannels(elements);
        }

        public final Builder addAllPrivateChannels(Iterable<? extends ChannelData> elements) {
            for (ChannelData channelData : elements) {
                this.privateChannels.add(Objects.requireNonNull(channelData, "privateChannels element"));
            }
            return this;
        }

        public final Builder addGuild(UnavailableGuildData element) {
            this.guilds.add(Objects.requireNonNull(element, "guilds element"));
            return this;
        }

        public final Builder addGuilds(UnavailableGuildData ... elements) {
            for (UnavailableGuildData element : elements) {
                this.guilds.add(Objects.requireNonNull(element, "guilds element"));
            }
            return this;
        }

        @JsonProperty(value="guilds")
        public final Builder guilds(Iterable<? extends UnavailableGuildData> elements) {
            this.guilds.clear();
            return this.addAllGuilds(elements);
        }

        public final Builder addAllGuilds(Iterable<? extends UnavailableGuildData> elements) {
            for (UnavailableGuildData unavailableGuildData : elements) {
                this.guilds.add(Objects.requireNonNull(unavailableGuildData, "guilds element"));
            }
            return this;
        }

        @JsonProperty(value="session_id")
        public final Builder sessionId(String sessionId) {
            this.sessionId = Objects.requireNonNull(sessionId, "sessionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="shard")
        public Builder shard(Possible<int[]> value) {
            this.shard_possible = value;
            return this;
        }

        public Builder shard(int[] value) {
            this.shard_possible = Possible.of((Object)value);
            return this;
        }

        public final Builder addTrace(String element) {
            this.trace.add(Objects.requireNonNull(element, "trace element"));
            return this;
        }

        public final Builder addTrace(String ... elements) {
            for (String element : elements) {
                this.trace.add(Objects.requireNonNull(element, "trace element"));
            }
            return this;
        }

        @JsonProperty(value="_trace")
        public final Builder trace(Iterable<String> elements) {
            this.trace.clear();
            return this.addAllTrace(elements);
        }

        public final Builder addAllTrace(Iterable<String> elements) {
            for (String element : elements) {
                this.trace.add(Objects.requireNonNull(element, "trace element"));
            }
            return this;
        }

        @JsonProperty(value="application")
        public final Builder application(PartialApplicationInfoData application) {
            this.application = Objects.requireNonNull(application, "application");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableReady build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReady(null, this.v, this.user, ImmutableReady.createUnmodifiableList(true, this.privateChannels), ImmutableReady.createUnmodifiableList(true, this.guilds), this.sessionId, this.shard_build(), ImmutableReady.createUnmodifiableList(true, this.trace), this.application);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("v");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("sessionId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("application");
            }
            return "Cannot build Ready, some of required attributes are not set " + attributes;
        }

        private Possible<int[]> shard_build() {
            return this.shard_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Ready", generator="Immutables")
    static final class Json
    implements Ready {
        int v;
        boolean vIsSet;
        UserData user;
        List<ChannelData> privateChannels = Collections.emptyList();
        List<UnavailableGuildData> guilds = Collections.emptyList();
        String sessionId;
        Possible<int[]> shard = Possible.absent();
        List<String> trace = Collections.emptyList();
        PartialApplicationInfoData application;

        Json() {
        }

        @JsonProperty(value="v")
        public void setV(int v) {
            this.v = v;
            this.vIsSet = true;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="private_channels")
        public void setPrivateChannels(List<ChannelData> privateChannels) {
            this.privateChannels = privateChannels;
        }

        @JsonProperty(value="guilds")
        public void setGuilds(List<UnavailableGuildData> guilds) {
            this.guilds = guilds;
        }

        @JsonProperty(value="session_id")
        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @JsonProperty(value="shard")
        public void setShard(Possible<int[]> shard) {
            this.shard = shard;
        }

        @JsonProperty(value="_trace")
        public void setTrace(List<String> trace) {
            this.trace = trace;
        }

        @JsonProperty(value="application")
        public void setApplication(PartialApplicationInfoData application) {
            this.application = application;
        }

        @Override
        public int v() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ChannelData> privateChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UnavailableGuildData> guilds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String sessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<int[]> shard() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> trace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PartialApplicationInfoData application() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="Ready", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build Ready, attribute initializers form cycle " + attributes;
        }
    }
}

