/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import discord4j.discordjson.json.TokenRefreshRequest;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="TokenRefreshRequest", generator="Immutables")
public final class ImmutableTokenRefreshRequest
extends TokenRefreshRequest {
    private final long clientId;
    private final String clientSecret;
    private final String refreshToken;

    private ImmutableTokenRefreshRequest(long clientId, String clientSecret, String refreshToken) {
        this.clientId = clientId;
        this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
        this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
    }

    private ImmutableTokenRefreshRequest(ImmutableTokenRefreshRequest original, long clientId, String clientSecret, String refreshToken) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.refreshToken = refreshToken;
    }

    @Override
    public long clientId() {
        return this.clientId;
    }

    @Override
    public String clientSecret() {
        return this.clientSecret;
    }

    @Override
    public String refreshToken() {
        return this.refreshToken;
    }

    public final ImmutableTokenRefreshRequest withClientId(long value) {
        if (this.clientId == value) {
            return this;
        }
        return new ImmutableTokenRefreshRequest(this, value, this.clientSecret, this.refreshToken);
    }

    public final ImmutableTokenRefreshRequest withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenRefreshRequest(this, this.clientId, newValue, this.refreshToken);
    }

    public final ImmutableTokenRefreshRequest withRefreshToken(String value) {
        String newValue = Objects.requireNonNull(value, "refreshToken");
        if (this.refreshToken.equals(newValue)) {
            return this;
        }
        return new ImmutableTokenRefreshRequest(this, this.clientId, this.clientSecret, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenRefreshRequest && this.equalTo((ImmutableTokenRefreshRequest)another);
    }

    private boolean equalTo(ImmutableTokenRefreshRequest another) {
        return this.clientId == another.clientId && this.clientSecret.equals(another.clientSecret) && this.refreshToken.equals(another.refreshToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.clientId);
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + this.refreshToken.hashCode();
        return h;
    }

    public static ImmutableTokenRefreshRequest of(long clientId, String clientSecret, String refreshToken) {
        return new ImmutableTokenRefreshRequest(clientId, clientSecret, refreshToken);
    }

    public static ImmutableTokenRefreshRequest copyOf(TokenRefreshRequest instance) {
        if (instance instanceof ImmutableTokenRefreshRequest) {
            return (ImmutableTokenRefreshRequest)instance;
        }
        return ImmutableTokenRefreshRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TokenRefreshRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private static final long INIT_BIT_REFRESH_TOKEN = 4L;
        private long initBits = 7L;
        private long clientId;
        private String clientSecret;
        private String refreshToken;

        private Builder() {
        }

        public final Builder from(TokenRefreshRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.clientId());
            this.clientSecret(instance.clientSecret());
            this.refreshToken(instance.refreshToken());
            return this;
        }

        public final Builder clientId(long clientId) {
            this.clientId = clientId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTokenRefreshRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTokenRefreshRequest(null, this.clientId, this.clientSecret, this.refreshToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("refreshToken");
            }
            return "Cannot build TokenRefreshRequest, some of required attributes are not set " + attributes;
        }
    }
}

