/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.TemplateCreateRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="TemplateCreateRequest", generator="Immutables")
public final class ImmutableTemplateCreateRequest
implements TemplateCreateRequest {
    private final String name;
    private final String description_value;
    private final boolean description_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTemplateCreateRequest(String name, Possible<Optional<String>> description) {
        this.name = Objects.requireNonNull(name, "name");
        Possible<Optional<String>> description$impl = description;
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableTemplateCreateRequest(ImmutableTemplateCreateRequest original, String name, Possible<Optional<String>> description) {
        this.name = name;
        Possible<Optional<String>> description$impl = description;
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public Possible<Optional<String>> description() {
        return this.description_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.description_value));
    }

    public final ImmutableTemplateCreateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableTemplateCreateRequest(this, newValue, this.description());
    }

    public ImmutableTemplateCreateRequest withDescription(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableTemplateCreateRequest(this, this.name, newValue);
    }

    @Deprecated
    public ImmutableTemplateCreateRequest withDescription(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableTemplateCreateRequest(this, this.name, (Possible<Optional<String>>)newValue);
    }

    public ImmutableTemplateCreateRequest withDescriptionOrNull(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableTemplateCreateRequest(this, this.name, (Possible<Optional<String>>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTemplateCreateRequest && this.equalTo((ImmutableTemplateCreateRequest)another);
    }

    private boolean equalTo(ImmutableTemplateCreateRequest another) {
        return this.name.equals(another.name) && this.description().equals(another.description());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description().hashCode();
        return h;
    }

    public String toString() {
        return "TemplateCreateRequest{name=" + this.name + ", description=" + this.description().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTemplateCreateRequest fromJson(Json json) {
        Builder builder = ImmutableTemplateCreateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        return builder.build();
    }

    public static ImmutableTemplateCreateRequest of(String name, Possible<Optional<String>> description) {
        return new ImmutableTemplateCreateRequest(name, description);
    }

    public static ImmutableTemplateCreateRequest copyOf(TemplateCreateRequest instance) {
        if (instance instanceof ImmutableTemplateCreateRequest) {
            return (ImmutableTemplateCreateRequest)instance;
        }
        return ImmutableTemplateCreateRequest.builder().from(instance).build();
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TemplateCreateRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private Possible<Optional<String>> description_possible = Possible.absent();
        private String name;

        private Builder() {
        }

        public final Builder from(TemplateCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.description(instance.description());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(Possible<Optional<String>> value) {
            this.description_possible = value;
            return this;
        }

        @Deprecated
        public Builder description(String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder descriptionOrNull(String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableTemplateCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTemplateCreateRequest(null, this.name, this.description_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build TemplateCreateRequest, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> description_build() {
            return this.description_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TemplateCreateRequest", generator="Immutables")
    static final class Json
    implements TemplateCreateRequest {
        String name;
        Possible<Optional<String>> description = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(Possible<Optional<String>> description) {
            this.description = description;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> description() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="TemplateCreateRequest", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build TemplateCreateRequest, attribute initializers form cycle " + attributes;
        }
    }
}

