/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ActivityData;
import discord4j.discordjson.json.ClientStatusData;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.json.PresenceData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="PresenceData", generator="Immutables")
public final class ImmutablePresenceData
implements PresenceData {
    private final PartialUserData user;
    private final String status;
    private final List<ActivityData> activities;
    private final ClientStatusData clientStatus;

    private ImmutablePresenceData(PartialUserData user, String status, Iterable<? extends ActivityData> activities, ClientStatusData clientStatus) {
        this.user = Objects.requireNonNull(user, "user");
        this.status = Objects.requireNonNull(status, "status");
        this.activities = ImmutablePresenceData.createUnmodifiableList(false, ImmutablePresenceData.createSafeList(activities, true, false));
        this.clientStatus = Objects.requireNonNull(clientStatus, "clientStatus");
    }

    private ImmutablePresenceData(ImmutablePresenceData original, PartialUserData user, String status, List<ActivityData> activities, ClientStatusData clientStatus) {
        this.user = user;
        this.status = status;
        this.activities = activities;
        this.clientStatus = clientStatus;
    }

    @Override
    @JsonProperty(value="user")
    public PartialUserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="status")
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="activities")
    public List<ActivityData> activities() {
        return this.activities;
    }

    @Override
    @JsonProperty(value="client_status")
    public ClientStatusData clientStatus() {
        return this.clientStatus;
    }

    public final ImmutablePresenceData withUser(PartialUserData value) {
        if (this.user == value) {
            return this;
        }
        PartialUserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutablePresenceData(this, newValue, this.status, this.activities, this.clientStatus);
    }

    public final ImmutablePresenceData withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutablePresenceData(this, this.user, newValue, this.activities, this.clientStatus);
    }

    public final ImmutablePresenceData withActivities(ActivityData ... elements) {
        List<ActivityData> newValue = ImmutablePresenceData.createUnmodifiableList(false, ImmutablePresenceData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePresenceData(this, this.user, this.status, newValue, this.clientStatus);
    }

    public final ImmutablePresenceData withActivities(Iterable<? extends ActivityData> elements) {
        if (this.activities == elements) {
            return this;
        }
        List<ActivityData> newValue = ImmutablePresenceData.createUnmodifiableList(false, ImmutablePresenceData.createSafeList(elements, true, false));
        return new ImmutablePresenceData(this, this.user, this.status, newValue, this.clientStatus);
    }

    public final ImmutablePresenceData withClientStatus(ClientStatusData value) {
        if (this.clientStatus == value) {
            return this;
        }
        ClientStatusData newValue = Objects.requireNonNull(value, "clientStatus");
        return new ImmutablePresenceData(this, this.user, this.status, this.activities, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePresenceData && this.equalTo((ImmutablePresenceData)another);
    }

    private boolean equalTo(ImmutablePresenceData another) {
        return this.user.equals(another.user) && this.status.equals(another.status) && this.activities.equals(another.activities) && this.clientStatus.equals(another.clientStatus);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.activities.hashCode();
        h += (h << 5) + this.clientStatus.hashCode();
        return h;
    }

    public String toString() {
        return "PresenceData{user=" + this.user + ", status=" + this.status + ", activities=" + this.activities + ", clientStatus=" + this.clientStatus + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePresenceData fromJson(Json json) {
        Builder builder = ImmutablePresenceData.builder();
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.activities != null) {
            builder.addAllActivities(json.activities);
        }
        if (json.clientStatus != null) {
            builder.clientStatus(json.clientStatus);
        }
        return builder.build();
    }

    public static ImmutablePresenceData of(PartialUserData user, String status, List<ActivityData> activities, ClientStatusData clientStatus) {
        return ImmutablePresenceData.of(user, status, activities, clientStatus);
    }

    public static ImmutablePresenceData of(PartialUserData user, String status, Iterable<? extends ActivityData> activities, ClientStatusData clientStatus) {
        return new ImmutablePresenceData(user, status, activities, clientStatus);
    }

    public static ImmutablePresenceData copyOf(PresenceData instance) {
        if (instance instanceof ImmutablePresenceData) {
            return (ImmutablePresenceData)instance;
        }
        return ImmutablePresenceData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PresenceData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private static final long INIT_BIT_CLIENT_STATUS = 4L;
        private long initBits = 7L;
        private PartialUserData user;
        private String status;
        private List<ActivityData> activities = new ArrayList<ActivityData>();
        private ClientStatusData clientStatus;

        private Builder() {
        }

        public final Builder from(PresenceData instance) {
            Objects.requireNonNull(instance, "instance");
            this.user(instance.user());
            this.status(instance.status());
            this.addAllActivities(instance.activities());
            this.clientStatus(instance.clientStatus());
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(PartialUserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addActivity(ActivityData element) {
            this.activities.add(Objects.requireNonNull(element, "activities element"));
            return this;
        }

        public final Builder addActivities(ActivityData ... elements) {
            for (ActivityData element : elements) {
                this.activities.add(Objects.requireNonNull(element, "activities element"));
            }
            return this;
        }

        @JsonProperty(value="activities")
        public final Builder activities(Iterable<? extends ActivityData> elements) {
            this.activities.clear();
            return this.addAllActivities(elements);
        }

        public final Builder addAllActivities(Iterable<? extends ActivityData> elements) {
            for (ActivityData activityData : elements) {
                this.activities.add(Objects.requireNonNull(activityData, "activities element"));
            }
            return this;
        }

        @JsonProperty(value="client_status")
        public final Builder clientStatus(ClientStatusData clientStatus) {
            this.clientStatus = Objects.requireNonNull(clientStatus, "clientStatus");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePresenceData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePresenceData(null, this.user, this.status, ImmutablePresenceData.createUnmodifiableList(true, this.activities), this.clientStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("clientStatus");
            }
            return "Cannot build PresenceData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PresenceData", generator="Immutables")
    static final class Json
    implements PresenceData {
        PartialUserData user;
        String status;
        List<ActivityData> activities = Collections.emptyList();
        ClientStatusData clientStatus;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUser(PartialUserData user) {
            this.user = user;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="activities")
        public void setActivities(List<ActivityData> activities) {
            this.activities = activities;
        }

        @JsonProperty(value="client_status")
        public void setClientStatus(ClientStatusData clientStatus) {
            this.clientStatus = clientStatus;
        }

        @Override
        public PartialUserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ActivityData> activities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClientStatusData clientStatus() {
            throw new UnsupportedOperationException();
        }
    }
}

