/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="PartialMemberData", generator="Immutables")
public final class ImmutablePartialMemberData
implements PartialMemberData {
    private final String nick_value;
    private final boolean nick_absent;
    private final long[] roles_value;
    private final String joinedAt;
    private final String premiumSince_value;
    private final boolean premiumSince_absent;
    private final String hoistedRole;
    private final boolean deaf;
    private final boolean mute;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePartialMemberData(Possible<Optional<String>> nick, List<Id> roles, String joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute) {
        Possible<Optional<String>> nick$impl = nick;
        List<Id> roles$impl = roles;
        this.joinedAt = Objects.requireNonNull(joinedAt, "joinedAt");
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole.orElse(null);
        this.deaf = deaf;
        this.mute = mute;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.roles_value = roles$impl.stream().mapToLong(Id::asLong).toArray();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutablePartialMemberData(ImmutablePartialMemberData original, Possible<Optional<String>> nick, List<Id> roles, String joinedAt, Possible<Optional<String>> premiumSince, String hoistedRole, boolean deaf, boolean mute) {
        Possible<Optional<String>> nick$impl = nick;
        List<Id> roles$impl = roles;
        this.joinedAt = joinedAt;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole;
        this.deaf = deaf;
        this.mute = mute;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.roles_value = roles$impl.stream().mapToLong(Id::asLong).toArray();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="nick")
    public Possible<Optional<String>> nick() {
        return this.nick_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nick_value));
    }

    @Override
    @JsonProperty(value="roles")
    public List<Id> roles() {
        return LongStream.of(this.roles_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="joined_at")
    public String joinedAt() {
        return this.joinedAt;
    }

    @Override
    @JsonProperty(value="premium_since")
    public Possible<Optional<String>> premiumSince() {
        return this.premiumSince_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.premiumSince_value));
    }

    @Override
    @JsonProperty(value="hoisted_role")
    public Optional<String> hoistedRole() {
        return Optional.ofNullable(this.hoistedRole);
    }

    @Override
    @JsonProperty(value="deaf")
    public boolean deaf() {
        return this.deaf;
    }

    @Override
    @JsonProperty(value="mute")
    public boolean mute() {
        return this.mute;
    }

    public ImmutablePartialMemberData withNick(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePartialMemberData(this, newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    @Deprecated
    public ImmutablePartialMemberData withNick(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, (Possible<Optional<String>>)newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutablePartialMemberData withNickOrNull(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, (Possible<Optional<String>>)newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutablePartialMemberData withRoles(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutablePartialMemberData(this, this.nick(), newValue, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public final ImmutablePartialMemberData withJoinedAt(String value) {
        String newValue = Objects.requireNonNull(value, "joinedAt");
        if (this.joinedAt.equals(newValue)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), newValue, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutablePartialMemberData withPremiumSince(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), this.joinedAt, newValue, this.hoistedRole, this.deaf, this.mute);
    }

    @Deprecated
    public ImmutablePartialMemberData withPremiumSince(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), this.joinedAt, (Possible<Optional<String>>)newValue, this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutablePartialMemberData withPremiumSinceOrNull(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), this.joinedAt, (Possible<Optional<String>>)newValue, this.hoistedRole, this.deaf, this.mute);
    }

    public final ImmutablePartialMemberData withHoistedRole(String value) {
        String newValue = Objects.requireNonNull(value, "hoistedRole");
        if (Objects.equals(this.hoistedRole, newValue)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), newValue, this.deaf, this.mute);
    }

    public final ImmutablePartialMemberData withHoistedRole(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hoistedRole, value)) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), value, this.deaf, this.mute);
    }

    public final ImmutablePartialMemberData withDeaf(boolean value) {
        if (this.deaf == value) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, value, this.mute);
    }

    public final ImmutablePartialMemberData withMute(boolean value) {
        if (this.mute == value) {
            return this;
        }
        return new ImmutablePartialMemberData(this, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePartialMemberData && this.equalTo((ImmutablePartialMemberData)another);
    }

    private boolean equalTo(ImmutablePartialMemberData another) {
        return this.nick().equals(another.nick()) && Objects.equals(this.roles_value, another.roles_value) && this.joinedAt.equals(another.joinedAt) && this.premiumSince().equals(another.premiumSince()) && Objects.equals(this.hoistedRole, another.hoistedRole) && this.deaf == another.deaf && this.mute == another.mute;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.nick().hashCode();
        h += (h << 5) + Objects.hashCode(this.roles_value);
        h += (h << 5) + this.joinedAt.hashCode();
        h += (h << 5) + this.premiumSince().hashCode();
        h += (h << 5) + Objects.hashCode(this.hoistedRole);
        h += (h << 5) + Boolean.hashCode(this.deaf);
        h += (h << 5) + Boolean.hashCode(this.mute);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PartialMemberData{");
        builder.append("nick=").append(this.nick().toString());
        builder.append(", ");
        builder.append("roles=").append(Objects.toString(this.roles_value));
        builder.append(", ");
        builder.append("joinedAt=").append(this.joinedAt);
        builder.append(", ");
        builder.append("premiumSince=").append(this.premiumSince().toString());
        if (this.hoistedRole != null) {
            builder.append(", ");
            builder.append("hoistedRole=").append(this.hoistedRole);
        }
        builder.append(", ");
        builder.append("deaf=").append(this.deaf);
        builder.append(", ");
        builder.append("mute=").append(this.mute);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePartialMemberData fromJson(Json json) {
        Builder builder = ImmutablePartialMemberData.builder();
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        if (json.roles != null) {
            builder.roles(json.roles);
        }
        if (json.joinedAt != null) {
            builder.joinedAt(json.joinedAt);
        }
        if (json.premiumSince != null) {
            builder.premiumSince(json.premiumSince);
        }
        if (json.hoistedRole != null) {
            builder.hoistedRole(json.hoistedRole);
        }
        if (json.deafIsSet) {
            builder.deaf(json.deaf);
        }
        if (json.muteIsSet) {
            builder.mute(json.mute);
        }
        return builder.build();
    }

    public static ImmutablePartialMemberData of(Possible<Optional<String>> nick, List<Id> roles, String joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute) {
        return new ImmutablePartialMemberData(nick, roles, joinedAt, premiumSince, hoistedRole, deaf, mute);
    }

    public static ImmutablePartialMemberData copyOf(PartialMemberData instance) {
        if (instance instanceof ImmutablePartialMemberData) {
            return (ImmutablePartialMemberData)instance;
        }
        return ImmutablePartialMemberData.builder().from(instance).build();
    }

    public boolean isNickPresent() {
        return !this.nick_absent;
    }

    public String nickOrElse(String defaultValue) {
        return !this.nick_absent ? this.nick_value : defaultValue;
    }

    public boolean isPremiumSincePresent() {
        return !this.premiumSince_absent;
    }

    public String premiumSinceOrElse(String defaultValue) {
        return !this.premiumSince_absent ? this.premiumSince_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PartialMemberData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_JOINED_AT = 1L;
        private static final long INIT_BIT_DEAF = 2L;
        private static final long INIT_BIT_MUTE = 4L;
        private long initBits = 7L;
        private Possible<Optional<String>> nick_possible = Possible.absent();
        private List<Long> roles_list = null;
        private Possible<Optional<String>> premiumSince_possible = Possible.absent();
        private String joinedAt;
        private String hoistedRole;
        private boolean deaf;
        private boolean mute;

        private Builder() {
        }

        public final Builder from(PartialMemberData instance) {
            Objects.requireNonNull(instance, "instance");
            this.nick(instance.nick());
            this.roles(instance.roles());
            this.joinedAt(instance.joinedAt());
            this.premiumSince(instance.premiumSince());
            Optional<String> hoistedRoleOptional = instance.hoistedRole();
            if (hoistedRoleOptional.isPresent()) {
                this.hoistedRole(hoistedRoleOptional);
            }
            this.deaf(instance.deaf());
            this.mute(instance.mute());
            return this;
        }

        @JsonProperty(value="nick")
        public Builder nick(Possible<Optional<String>> value) {
            this.nick_possible = value;
            return this;
        }

        @Deprecated
        public Builder nick(String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder nickOrNull(String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addRole(long element) {
            this.roles_getOrCreate().add(element);
            return this;
        }

        public Builder addRole(String element) {
            this.roles_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addRole(Id element) {
            this.roles_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllRoles(List<Long> elements) {
            this.roles_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="roles")
        public Builder roles(List<Id> elements) {
            this.roles_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder roles(Iterable<Id> elements) {
            this.roles_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="joined_at")
        public final Builder joinedAt(String joinedAt) {
            this.joinedAt = Objects.requireNonNull(joinedAt, "joinedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="premium_since")
        public Builder premiumSince(Possible<Optional<String>> value) {
            this.premiumSince_possible = value;
            return this;
        }

        @Deprecated
        public Builder premiumSince(String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder premiumSinceOrNull(String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder hoistedRole(String hoistedRole) {
            this.hoistedRole = Objects.requireNonNull(hoistedRole, "hoistedRole");
            return this;
        }

        @JsonProperty(value="hoisted_role")
        public final Builder hoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole.orElse(null);
            return this;
        }

        @JsonProperty(value="deaf")
        public final Builder deaf(boolean deaf) {
            this.deaf = deaf;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="mute")
        public final Builder mute(boolean mute) {
            this.mute = mute;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePartialMemberData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePartialMemberData(null, this.nick_build(), this.roles_build(), this.joinedAt, this.premiumSince_build(), this.hoistedRole, this.deaf, this.mute);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("joinedAt");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("deaf");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mute");
            }
            return "Cannot build PartialMemberData, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> nick_build() {
            return this.nick_possible;
        }

        private List<Id> roles_build() {
            return this.roles_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> roles_getOrCreate() {
            if (this.roles_list == null) {
                this.roles_list = new ArrayList<Long>();
            }
            return this.roles_list;
        }

        private Possible<Optional<String>> premiumSince_build() {
            return this.premiumSince_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PartialMemberData", generator="Immutables")
    static final class Json
    implements PartialMemberData {
        Possible<Optional<String>> nick = Possible.absent();
        List<Id> roles;
        String joinedAt;
        Possible<Optional<String>> premiumSince = Possible.absent();
        Optional<String> hoistedRole = Optional.empty();
        boolean deaf;
        boolean deafIsSet;
        boolean mute;
        boolean muteIsSet;

        Json() {
        }

        @JsonProperty(value="nick")
        public void setNick(Possible<Optional<String>> nick) {
            this.nick = nick;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<Id> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="joined_at")
        public void setJoinedAt(String joinedAt) {
            this.joinedAt = joinedAt;
        }

        @JsonProperty(value="premium_since")
        public void setPremiumSince(Possible<Optional<String>> premiumSince) {
            this.premiumSince = premiumSince;
        }

        @JsonProperty(value="hoisted_role")
        public void setHoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole;
        }

        @JsonProperty(value="deaf")
        public void setDeaf(boolean deaf) {
            this.deaf = deaf;
            this.deafIsSet = true;
        }

        @JsonProperty(value="mute")
        public void setMute(boolean mute) {
            this.mute = mute;
            this.muteIsSet = true;
        }

        @Override
        public Possible<Optional<String>> nick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String joinedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> premiumSince() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> hoistedRole() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deaf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mute() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="PartialMemberData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PartialMemberData, attribute initializers form cycle " + attributes;
        }
    }
}

