/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ConnectionData;
import discord4j.discordjson.json.IntegrationData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="ConnectionData", generator="Immutables")
public final class ImmutableConnectionData
implements ConnectionData {
    private final String id;
    private final String name;
    private final String type;
    private final Boolean revoked_value;
    private final boolean revoked_absent;
    private final List<IntegrationData> integrations_value;
    private final boolean integrations_absent;
    private final boolean verified;
    private final boolean friendSync;
    private final boolean showActivity;
    private final int visibility;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableConnectionData(String id, String name, String type, Possible<Boolean> revoked, Possible<List<IntegrationData>> integrations, boolean verified, boolean friendSync, boolean showActivity, int visibility) {
        this.id = Objects.requireNonNull(id, "id");
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        Possible<Boolean> revoked$impl = revoked;
        Possible<List<IntegrationData>> integrations$impl = integrations;
        this.verified = verified;
        this.friendSync = friendSync;
        this.showActivity = showActivity;
        this.visibility = visibility;
        this.revoked_value = revoked$impl.toOptional().orElse(null);
        this.revoked_absent = revoked$impl.isAbsent();
        this.integrations_value = integrations$impl.toOptional().orElse(null);
        this.integrations_absent = integrations$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableConnectionData(ImmutableConnectionData original, String id, String name, String type, Possible<Boolean> revoked, Possible<List<IntegrationData>> integrations, boolean verified, boolean friendSync, boolean showActivity, int visibility) {
        this.id = id;
        this.name = name;
        this.type = type;
        Possible<Boolean> revoked$impl = revoked;
        Possible<List<IntegrationData>> integrations$impl = integrations;
        this.verified = verified;
        this.friendSync = friendSync;
        this.showActivity = showActivity;
        this.visibility = visibility;
        this.revoked_value = revoked$impl.toOptional().orElse(null);
        this.revoked_absent = revoked$impl.isAbsent();
        this.integrations_value = integrations$impl.toOptional().orElse(null);
        this.integrations_absent = integrations$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="revoked")
    public Possible<Boolean> revoked() {
        return this.revoked_absent ? Possible.absent() : Possible.of((Object)this.revoked_value);
    }

    @Override
    @JsonProperty(value="integrations")
    public Possible<List<IntegrationData>> integrations() {
        return this.integrations_absent ? Possible.absent() : Possible.of(this.integrations_value);
    }

    @Override
    @JsonProperty(value="verified")
    public boolean verified() {
        return this.verified;
    }

    @Override
    @JsonProperty(value="friend_sync")
    public boolean friendSync() {
        return this.friendSync;
    }

    @Override
    @JsonProperty(value="show_activity")
    public boolean showActivity() {
        return this.showActivity;
    }

    @Override
    @JsonProperty(value="visibility")
    public int visibility() {
        return this.visibility;
    }

    public final ImmutableConnectionData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectionData(this, newValue, this.name, this.type, this.revoked(), this.integrations(), this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    public final ImmutableConnectionData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectionData(this, this.id, newValue, this.type, this.revoked(), this.integrations(), this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    public final ImmutableConnectionData withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectionData(this, this.id, this.name, newValue, this.revoked(), this.integrations(), this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    public ImmutableConnectionData withRevoked(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableConnectionData(this, this.id, this.name, this.type, newValue, this.integrations(), this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    public ImmutableConnectionData withRevoked(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableConnectionData(this, this.id, this.name, this.type, (Possible<Boolean>)newValue, this.integrations(), this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    public ImmutableConnectionData withIntegrations(Possible<List<IntegrationData>> possible) {
        Possible<List<IntegrationData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableConnectionData(this, this.id, this.name, this.type, this.revoked(), newValue, this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    public ImmutableConnectionData withIntegrations(Iterable<IntegrationData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableConnectionData(this, this.id, this.name, this.type, this.revoked(), (Possible<List<IntegrationData>>)newValue, this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    @SafeVarargs
    public final ImmutableConnectionData withIntegrations(IntegrationData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableConnectionData(this, this.id, this.name, this.type, this.revoked(), (Possible<List<IntegrationData>>)newValue, this.verified, this.friendSync, this.showActivity, this.visibility);
    }

    public final ImmutableConnectionData withVerified(boolean value) {
        if (this.verified == value) {
            return this;
        }
        return new ImmutableConnectionData(this, this.id, this.name, this.type, this.revoked(), this.integrations(), value, this.friendSync, this.showActivity, this.visibility);
    }

    public final ImmutableConnectionData withFriendSync(boolean value) {
        if (this.friendSync == value) {
            return this;
        }
        return new ImmutableConnectionData(this, this.id, this.name, this.type, this.revoked(), this.integrations(), this.verified, value, this.showActivity, this.visibility);
    }

    public final ImmutableConnectionData withShowActivity(boolean value) {
        if (this.showActivity == value) {
            return this;
        }
        return new ImmutableConnectionData(this, this.id, this.name, this.type, this.revoked(), this.integrations(), this.verified, this.friendSync, value, this.visibility);
    }

    public final ImmutableConnectionData withVisibility(int value) {
        if (this.visibility == value) {
            return this;
        }
        return new ImmutableConnectionData(this, this.id, this.name, this.type, this.revoked(), this.integrations(), this.verified, this.friendSync, this.showActivity, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectionData && this.equalTo((ImmutableConnectionData)another);
    }

    private boolean equalTo(ImmutableConnectionData another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.type.equals(another.type) && this.revoked().equals(another.revoked()) && Objects.equals(this.integrations_value, another.integrations_value) && this.verified == another.verified && this.friendSync == another.friendSync && this.showActivity == another.showActivity && this.visibility == another.visibility;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.revoked().hashCode();
        h += (h << 5) + Objects.hashCode(this.integrations_value);
        h += (h << 5) + Boolean.hashCode(this.verified);
        h += (h << 5) + Boolean.hashCode(this.friendSync);
        h += (h << 5) + Boolean.hashCode(this.showActivity);
        h += (h << 5) + this.visibility;
        return h;
    }

    public String toString() {
        return "ConnectionData{id=" + this.id + ", name=" + this.name + ", type=" + this.type + ", revoked=" + this.revoked().toString() + ", integrations=" + Objects.toString(this.integrations_value) + ", verified=" + this.verified + ", friendSync=" + this.friendSync + ", showActivity=" + this.showActivity + ", visibility=" + this.visibility + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableConnectionData fromJson(Json json) {
        Builder builder = ImmutableConnectionData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.revoked != null) {
            builder.revoked(json.revoked);
        }
        if (json.integrations != null) {
            builder.integrations(json.integrations);
        }
        if (json.verifiedIsSet) {
            builder.verified(json.verified);
        }
        if (json.friendSyncIsSet) {
            builder.friendSync(json.friendSync);
        }
        if (json.showActivityIsSet) {
            builder.showActivity(json.showActivity);
        }
        if (json.visibilityIsSet) {
            builder.visibility(json.visibility);
        }
        return builder.build();
    }

    public static ImmutableConnectionData of(String id, String name, String type, Possible<Boolean> revoked, Possible<List<IntegrationData>> integrations, boolean verified, boolean friendSync, boolean showActivity, int visibility) {
        return new ImmutableConnectionData(id, name, type, revoked, integrations, verified, friendSync, showActivity, visibility);
    }

    public static ImmutableConnectionData copyOf(ConnectionData instance) {
        if (instance instanceof ImmutableConnectionData) {
            return (ImmutableConnectionData)instance;
        }
        return ImmutableConnectionData.builder().from(instance).build();
    }

    public boolean isRevokedPresent() {
        return !this.revoked_absent;
    }

    public Boolean revokedOrElse(Boolean defaultValue) {
        return !this.revoked_absent ? this.revoked_value : defaultValue;
    }

    public boolean isIntegrationsPresent() {
        return !this.integrations_absent;
    }

    public List<IntegrationData> integrationsOrElse(List<IntegrationData> defaultValue) {
        return !this.integrations_absent ? this.integrations_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectionData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_VERIFIED = 8L;
        private static final long INIT_BIT_FRIEND_SYNC = 16L;
        private static final long INIT_BIT_SHOW_ACTIVITY = 32L;
        private static final long INIT_BIT_VISIBILITY = 64L;
        private long initBits = 127L;
        private Possible<Boolean> revoked_possible = Possible.absent();
        private List<IntegrationData> integrations_list = null;
        private String id;
        private String name;
        private String type;
        private boolean verified;
        private boolean friendSync;
        private boolean showActivity;
        private int visibility;

        private Builder() {
        }

        public final Builder from(ConnectionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            this.type(instance.type());
            this.revoked(instance.revoked());
            this.integrations(instance.integrations());
            this.verified(instance.verified());
            this.friendSync(instance.friendSync());
            this.showActivity(instance.showActivity());
            this.visibility(instance.visibility());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="revoked")
        public Builder revoked(Possible<Boolean> value) {
            this.revoked_possible = value;
            return this;
        }

        public Builder revoked(Boolean value) {
            this.revoked_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addIntegration(IntegrationData element) {
            this.integrations_getOrCreate().add(element);
            return this;
        }

        public Builder addAllIntegrations(List<IntegrationData> elements) {
            this.integrations_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="integrations")
        public Builder integrations(Possible<List<IntegrationData>> elements) {
            this.integrations_list = null;
            elements.toOptional().ifPresent(e -> this.integrations_getOrCreate().addAll((Collection<IntegrationData>)e));
            return this;
        }

        public Builder integrations(List<IntegrationData> elements) {
            this.integrations_list = new ArrayList<IntegrationData>(elements);
            return this;
        }

        public Builder integrations(Iterable<IntegrationData> elements) {
            this.integrations_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="verified")
        public final Builder verified(boolean verified) {
            this.verified = verified;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="friend_sync")
        public final Builder friendSync(boolean friendSync) {
            this.friendSync = friendSync;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="show_activity")
        public final Builder showActivity(boolean showActivity) {
            this.showActivity = showActivity;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="visibility")
        public final Builder visibility(int visibility) {
            this.visibility = visibility;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableConnectionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConnectionData(null, this.id, this.name, this.type, this.revoked_build(), this.integrations_build(), this.verified, this.friendSync, this.showActivity, this.visibility);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("verified");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("friendSync");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("showActivity");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("visibility");
            }
            return "Cannot build ConnectionData, some of required attributes are not set " + attributes;
        }

        private Possible<Boolean> revoked_build() {
            return this.revoked_possible;
        }

        private Possible<List<IntegrationData>> integrations_build() {
            return this.integrations_list == null ? Possible.absent() : Possible.of(this.integrations_list);
        }

        private List<IntegrationData> integrations_getOrCreate() {
            if (this.integrations_list == null) {
                this.integrations_list = new ArrayList<IntegrationData>();
            }
            return this.integrations_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConnectionData", generator="Immutables")
    static final class Json
    implements ConnectionData {
        String id;
        String name;
        String type;
        Possible<Boolean> revoked = Possible.absent();
        Possible<List<IntegrationData>> integrations = Possible.absent();
        boolean verified;
        boolean verifiedIsSet;
        boolean friendSync;
        boolean friendSyncIsSet;
        boolean showActivity;
        boolean showActivityIsSet;
        int visibility;
        boolean visibilityIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="revoked")
        public void setRevoked(Possible<Boolean> revoked) {
            this.revoked = revoked;
        }

        @JsonProperty(value="integrations")
        public void setIntegrations(Possible<List<IntegrationData>> integrations) {
            this.integrations = integrations;
        }

        @JsonProperty(value="verified")
        public void setVerified(boolean verified) {
            this.verified = verified;
            this.verifiedIsSet = true;
        }

        @JsonProperty(value="friend_sync")
        public void setFriendSync(boolean friendSync) {
            this.friendSync = friendSync;
            this.friendSyncIsSet = true;
        }

        @JsonProperty(value="show_activity")
        public void setShowActivity(boolean showActivity) {
            this.showActivity = showActivity;
            this.showActivityIsSet = true;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(int visibility) {
            this.visibility = visibility;
            this.visibilityIsSet = true;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> revoked() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<IntegrationData>> integrations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean verified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean friendSync() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean showActivity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int visibility() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ConnectionData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ConnectionData, attribute initializers form cycle " + attributes;
        }
    }
}

