/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import discord4j.discordjson.json.ClientCredentialsGrantRequest;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ClientCredentialsGrantRequest", generator="Immutables")
public final class ImmutableClientCredentialsGrantRequest
extends ClientCredentialsGrantRequest {
    private final long clientId;
    private final String clientSecret;
    private final String scope;

    private ImmutableClientCredentialsGrantRequest(long clientId, String clientSecret, String scope) {
        this.clientId = clientId;
        this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    private ImmutableClientCredentialsGrantRequest(ImmutableClientCredentialsGrantRequest original, long clientId, String clientSecret, String scope) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
    }

    @Override
    public long clientId() {
        return this.clientId;
    }

    @Override
    public String clientSecret() {
        return this.clientSecret;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    public final ImmutableClientCredentialsGrantRequest withClientId(long value) {
        if (this.clientId == value) {
            return this;
        }
        return new ImmutableClientCredentialsGrantRequest(this, value, this.clientSecret, this.scope);
    }

    public final ImmutableClientCredentialsGrantRequest withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCredentialsGrantRequest(this, this.clientId, newValue, this.scope);
    }

    public final ImmutableClientCredentialsGrantRequest withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (this.scope.equals(newValue)) {
            return this;
        }
        return new ImmutableClientCredentialsGrantRequest(this, this.clientId, this.clientSecret, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientCredentialsGrantRequest && this.equalTo((ImmutableClientCredentialsGrantRequest)another);
    }

    private boolean equalTo(ImmutableClientCredentialsGrantRequest another) {
        return this.clientId == another.clientId && this.clientSecret.equals(another.clientSecret) && this.scope.equals(another.scope);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.clientId);
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + this.scope.hashCode();
        return h;
    }

    public static ImmutableClientCredentialsGrantRequest of(long clientId, String clientSecret, String scope) {
        return new ImmutableClientCredentialsGrantRequest(clientId, clientSecret, scope);
    }

    public static ImmutableClientCredentialsGrantRequest copyOf(ClientCredentialsGrantRequest instance) {
        if (instance instanceof ImmutableClientCredentialsGrantRequest) {
            return (ImmutableClientCredentialsGrantRequest)instance;
        }
        return ImmutableClientCredentialsGrantRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientCredentialsGrantRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private static final long INIT_BIT_SCOPE = 4L;
        private long initBits = 7L;
        private long clientId;
        private String clientSecret;
        private String scope;

        private Builder() {
        }

        public final Builder from(ClientCredentialsGrantRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.clientId());
            this.clientSecret(instance.clientSecret());
            this.scope(instance.scope());
            return this;
        }

        public final Builder clientId(long clientId) {
            this.clientId = clientId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableClientCredentialsGrantRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClientCredentialsGrantRequest(null, this.clientId, this.clientSecret, this.scope);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build ClientCredentialsGrantRequest, some of required attributes are not set " + attributes;
        }
    }
}

