/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationCommandOptionData;
import discord4j.discordjson.json.ApplicationCommandRequest;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="ApplicationCommandRequest", generator="Immutables")
public final class ImmutableApplicationCommandRequest
implements ApplicationCommandRequest {
    private final String name;
    private final String description;
    private final List<ApplicationCommandOptionData> options_value;
    private final boolean options_absent;
    private final Boolean defaultPermission_value;
    private final boolean defaultPermission_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableApplicationCommandRequest(String name, String description, Possible<List<ApplicationCommandOptionData>> options, Possible<Boolean> defaultPermission) {
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        Possible<List<ApplicationCommandOptionData>> options$impl = options;
        Possible<Boolean> defaultPermission$impl = defaultPermission;
        this.options_value = options$impl.toOptional().orElse(null);
        this.options_absent = options$impl.isAbsent();
        this.defaultPermission_value = defaultPermission$impl.toOptional().orElse(null);
        this.defaultPermission_absent = defaultPermission$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableApplicationCommandRequest(ImmutableApplicationCommandRequest original, String name, String description, Possible<List<ApplicationCommandOptionData>> options, Possible<Boolean> defaultPermission) {
        this.name = name;
        this.description = description;
        Possible<List<ApplicationCommandOptionData>> options$impl = options;
        Possible<Boolean> defaultPermission$impl = defaultPermission;
        this.options_value = options$impl.toOptional().orElse(null);
        this.options_absent = options$impl.isAbsent();
        this.defaultPermission_value = defaultPermission$impl.toOptional().orElse(null);
        this.defaultPermission_absent = defaultPermission$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="options")
    public Possible<List<ApplicationCommandOptionData>> options() {
        return this.options_absent ? Possible.absent() : Possible.of(this.options_value);
    }

    @Override
    @JsonProperty(value="default_permission")
    public Possible<Boolean> defaultPermission() {
        return this.defaultPermission_absent ? Possible.absent() : Possible.of((Object)this.defaultPermission_value);
    }

    public final ImmutableApplicationCommandRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationCommandRequest(this, newValue, this.description, this.options(), this.defaultPermission());
    }

    public final ImmutableApplicationCommandRequest withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationCommandRequest(this, this.name, newValue, this.options(), this.defaultPermission());
    }

    public ImmutableApplicationCommandRequest withOptions(Possible<List<ApplicationCommandOptionData>> possible) {
        Possible<List<ApplicationCommandOptionData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableApplicationCommandRequest(this, this.name, this.description, newValue, this.defaultPermission());
    }

    public ImmutableApplicationCommandRequest withOptions(Iterable<ApplicationCommandOptionData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableApplicationCommandRequest(this, this.name, this.description, (Possible<List<ApplicationCommandOptionData>>)newValue, this.defaultPermission());
    }

    @SafeVarargs
    public final ImmutableApplicationCommandRequest withOptions(ApplicationCommandOptionData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableApplicationCommandRequest(this, this.name, this.description, (Possible<List<ApplicationCommandOptionData>>)newValue, this.defaultPermission());
    }

    public ImmutableApplicationCommandRequest withDefaultPermission(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableApplicationCommandRequest(this, this.name, this.description, this.options(), newValue);
    }

    public ImmutableApplicationCommandRequest withDefaultPermission(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableApplicationCommandRequest(this, this.name, this.description, this.options(), (Possible<Boolean>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationCommandRequest && this.equalTo((ImmutableApplicationCommandRequest)another);
    }

    private boolean equalTo(ImmutableApplicationCommandRequest another) {
        return this.name.equals(another.name) && this.description.equals(another.description) && Objects.equals(this.options_value, another.options_value) && this.defaultPermission().equals(another.defaultPermission());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Objects.hashCode(this.options_value);
        h += (h << 5) + this.defaultPermission().hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationCommandRequest{name=" + this.name + ", description=" + this.description + ", options=" + Objects.toString(this.options_value) + ", defaultPermission=" + this.defaultPermission().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationCommandRequest fromJson(Json json) {
        Builder builder = ImmutableApplicationCommandRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.options != null) {
            builder.options(json.options);
        }
        if (json.defaultPermission != null) {
            builder.defaultPermission(json.defaultPermission);
        }
        return builder.build();
    }

    public static ImmutableApplicationCommandRequest of(String name, String description, Possible<List<ApplicationCommandOptionData>> options, Possible<Boolean> defaultPermission) {
        return new ImmutableApplicationCommandRequest(name, description, options, defaultPermission);
    }

    public static ImmutableApplicationCommandRequest copyOf(ApplicationCommandRequest instance) {
        if (instance instanceof ImmutableApplicationCommandRequest) {
            return (ImmutableApplicationCommandRequest)instance;
        }
        return ImmutableApplicationCommandRequest.builder().from(instance).build();
    }

    public boolean isOptionsPresent() {
        return !this.options_absent;
    }

    public List<ApplicationCommandOptionData> optionsOrElse(List<ApplicationCommandOptionData> defaultValue) {
        return !this.options_absent ? this.options_value : defaultValue;
    }

    public boolean isDefaultPermissionPresent() {
        return !this.defaultPermission_absent;
    }

    public Boolean defaultPermissionOrElse(Boolean defaultValue) {
        return !this.defaultPermission_absent ? this.defaultPermission_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ApplicationCommandRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private long initBits = 3L;
        private List<ApplicationCommandOptionData> options_list = null;
        private Possible<Boolean> defaultPermission_possible = Possible.absent();
        private String name;
        private String description;

        private Builder() {
        }

        public final Builder from(ApplicationCommandRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.description(instance.description());
            this.options(instance.options());
            this.defaultPermission(instance.defaultPermission());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder addOption(ApplicationCommandOptionData element) {
            this.options_getOrCreate().add(element);
            return this;
        }

        public Builder addAllOptions(List<ApplicationCommandOptionData> elements) {
            this.options_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="options")
        public Builder options(Possible<List<ApplicationCommandOptionData>> elements) {
            this.options_list = null;
            elements.toOptional().ifPresent(e -> this.options_getOrCreate().addAll((Collection<ApplicationCommandOptionData>)e));
            return this;
        }

        public Builder options(List<ApplicationCommandOptionData> elements) {
            this.options_list = new ArrayList<ApplicationCommandOptionData>(elements);
            return this;
        }

        public Builder options(Iterable<ApplicationCommandOptionData> elements) {
            this.options_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="default_permission")
        public Builder defaultPermission(Possible<Boolean> value) {
            this.defaultPermission_possible = value;
            return this;
        }

        public Builder defaultPermission(Boolean value) {
            this.defaultPermission_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableApplicationCommandRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationCommandRequest(null, this.name, this.description, this.options_build(), this.defaultPermission_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build ApplicationCommandRequest, some of required attributes are not set " + attributes;
        }

        private Possible<List<ApplicationCommandOptionData>> options_build() {
            return this.options_list == null ? Possible.absent() : Possible.of(this.options_list);
        }

        private List<ApplicationCommandOptionData> options_getOrCreate() {
            if (this.options_list == null) {
                this.options_list = new ArrayList<ApplicationCommandOptionData>();
            }
            return this.options_list;
        }

        private Possible<Boolean> defaultPermission_build() {
            return this.defaultPermission_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ApplicationCommandRequest", generator="Immutables")
    static final class Json
    implements ApplicationCommandRequest {
        String name;
        String description;
        Possible<List<ApplicationCommandOptionData>> options = Possible.absent();
        Possible<Boolean> defaultPermission = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="options")
        public void setOptions(Possible<List<ApplicationCommandOptionData>> options) {
            this.options = options;
        }

        @JsonProperty(value="default_permission")
        public void setDefaultPermission(Possible<Boolean> defaultPermission) {
            this.defaultPermission = defaultPermission;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<ApplicationCommandOptionData>> options() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> defaultPermission() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ApplicationCommandRequest", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ApplicationCommandRequest, attribute initializers form cycle " + attributes;
        }
    }
}

