/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleDataFields;
import discord4j.discordjson.json.RoleTagsData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableRoleData
implements RoleData {
    private final long id_value;
    private final String name;
    private final int color;
    private final boolean hoist;
    private final long permissions;
    private final boolean mentionable;
    private final String icon_value;
    private final boolean icon_absent;
    private final String unicodeEmoji_value;
    private final boolean unicodeEmoji_absent;
    private final RoleTagsData tags_value;
    private final boolean tags_absent;
    private final int flags;
    private final int position;
    private final boolean managed;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRoleData(Id id, String name, int color, boolean hoist, long permissions, boolean mentionable, Possible<Optional<String>> icon, Possible<Optional<String>> unicodeEmoji, Possible<RoleTagsData> tags, int flags, int position, boolean managed) {
        Id id$impl = id;
        this.name = Objects.requireNonNull(name, "name");
        this.color = color;
        this.hoist = hoist;
        this.permissions = permissions;
        this.mentionable = mentionable;
        Possible<Optional<String>> icon$impl = icon;
        Possible<Optional<String>> unicodeEmoji$impl = unicodeEmoji;
        Possible<RoleTagsData> tags$impl = tags;
        this.flags = flags;
        this.position = position;
        this.managed = managed;
        this.id_value = id$impl.asLong();
        this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.unicodeEmoji_value = Possible.flatOpt(unicodeEmoji$impl).orElse(null);
        this.unicodeEmoji_absent = unicodeEmoji$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableRoleData(ImmutableRoleData original, Id id, String name, int color, boolean hoist, long permissions, boolean mentionable, Possible<Optional<String>> icon, Possible<Optional<String>> unicodeEmoji, Possible<RoleTagsData> tags, int flags, int position, boolean managed) {
        Id id$impl = id;
        this.name = name;
        this.color = color;
        this.hoist = hoist;
        this.permissions = permissions;
        this.mentionable = mentionable;
        Possible<Optional<String>> icon$impl = icon;
        Possible<Optional<String>> unicodeEmoji$impl = unicodeEmoji;
        Possible<RoleTagsData> tags$impl = tags;
        this.flags = flags;
        this.position = position;
        this.managed = managed;
        this.id_value = id$impl.asLong();
        this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.unicodeEmoji_value = Possible.flatOpt(unicodeEmoji$impl).orElse(null);
        this.unicodeEmoji_absent = unicodeEmoji$impl.isAbsent();
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="color")
    public int color() {
        return this.color;
    }

    @Override
    @JsonProperty(value="hoist")
    public boolean hoist() {
        return this.hoist;
    }

    @Override
    @JsonProperty(value="permissions")
    public long permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty(value="mentionable")
    public boolean mentionable() {
        return this.mentionable;
    }

    @Override
    @JsonProperty(value="icon")
    public Possible<Optional<String>> icon() {
        return this.icon_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.icon_value));
    }

    @Override
    @JsonProperty(value="unicode_emoji")
    public Possible<Optional<String>> unicodeEmoji() {
        return this.unicodeEmoji_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.unicodeEmoji_value));
    }

    @Override
    @JsonProperty(value="tags")
    public Possible<RoleTagsData> tags() {
        return this.tags_absent ? Possible.absent() : Possible.of((Object)this.tags_value);
    }

    @Override
    @JsonProperty(value="flags")
    public int flags() {
        return this.flags;
    }

    @Override
    @JsonProperty(value="position")
    public int position() {
        return this.position;
    }

    @Override
    @JsonProperty(value="managed")
    public boolean managed() {
        return this.managed;
    }

    public ImmutableRoleData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableRoleData(this, newValue, this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public ImmutableRoleData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableRoleData(this, newValue, this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public final ImmutableRoleData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), newValue, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public final ImmutableRoleData withColor(int value) {
        if (this.color == value) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), this.name, value, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public final ImmutableRoleData withHoist(boolean value) {
        if (this.hoist == value) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), this.name, this.color, value, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public final ImmutableRoleData withPermissions(long value) {
        if (this.permissions == value) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, value, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public final ImmutableRoleData withMentionable(boolean value) {
        if (this.mentionable == value) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, value, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public ImmutableRoleData withIcon(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, newValue, this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    @Deprecated
    public ImmutableRoleData withIcon(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, (Possible<Optional<String>>)newValue, this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public ImmutableRoleData withIconOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, (Possible<Optional<String>>)newValue, this.unicodeEmoji(), this.tags(), this.flags, this.position, this.managed);
    }

    public ImmutableRoleData withUnicodeEmoji(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), newValue, this.tags(), this.flags, this.position, this.managed);
    }

    @Deprecated
    public ImmutableRoleData withUnicodeEmoji(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), (Possible<Optional<String>>)newValue, this.tags(), this.flags, this.position, this.managed);
    }

    public ImmutableRoleData withUnicodeEmojiOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), (Possible<Optional<String>>)newValue, this.tags(), this.flags, this.position, this.managed);
    }

    public ImmutableRoleData withTags(Possible<RoleTagsData> value) {
        Possible<RoleTagsData> newValue = Objects.requireNonNull(value);
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), newValue, this.flags, this.position, this.managed);
    }

    public ImmutableRoleData withTags(RoleTagsData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), (Possible<RoleTagsData>)newValue, this.flags, this.position, this.managed);
    }

    public final ImmutableRoleData withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), value, this.position, this.managed);
    }

    public final ImmutableRoleData withPosition(int value) {
        if (this.position == value) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, value, this.managed);
    }

    public final ImmutableRoleData withManaged(boolean value) {
        if (this.managed == value) {
            return this;
        }
        return new ImmutableRoleData(this, this.id(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon(), this.unicodeEmoji(), this.tags(), this.flags, this.position, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleData && this.equalTo(0, (ImmutableRoleData)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleData another) {
        return Objects.equals(this.id_value, another.id_value) && this.name.equals(another.name) && this.color == another.color && this.hoist == another.hoist && this.permissions == another.permissions && this.mentionable == another.mentionable && this.icon().equals(another.icon()) && this.unicodeEmoji().equals(another.unicodeEmoji()) && this.tags().equals(another.tags()) && this.flags == another.flags && this.position == another.position && this.managed == another.managed;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.color;
        h += (h << 5) + Boolean.hashCode(this.hoist);
        h += (h << 5) + Long.hashCode(this.permissions);
        h += (h << 5) + Boolean.hashCode(this.mentionable);
        h += (h << 5) + this.icon().hashCode();
        h += (h << 5) + this.unicodeEmoji().hashCode();
        h += (h << 5) + this.tags().hashCode();
        h += (h << 5) + this.flags;
        h += (h << 5) + this.position;
        h += (h << 5) + Boolean.hashCode(this.managed);
        return h;
    }

    public String toString() {
        return "RoleData{id=" + Objects.toString(this.id_value) + ", name=" + this.name + ", color=" + this.color + ", hoist=" + this.hoist + ", permissions=" + this.permissions + ", mentionable=" + this.mentionable + ", icon=" + this.icon().toString() + ", unicodeEmoji=" + this.unicodeEmoji().toString() + ", tags=" + this.tags().toString() + ", flags=" + this.flags + ", position=" + this.position + ", managed=" + this.managed + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRoleData fromJson(Json json) {
        Builder builder = ImmutableRoleData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.colorIsSet) {
            builder.color(json.color);
        }
        if (json.hoistIsSet) {
            builder.hoist(json.hoist);
        }
        if (json.permissionsIsSet) {
            builder.permissions(json.permissions);
        }
        if (json.mentionableIsSet) {
            builder.mentionable(json.mentionable);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.unicodeEmoji != null) {
            builder.unicodeEmoji(json.unicodeEmoji);
        }
        if (json.tags != null) {
            builder.tags(json.tags);
        }
        if (json.flagsIsSet) {
            builder.flags(json.flags);
        }
        if (json.positionIsSet) {
            builder.position(json.position);
        }
        if (json.managedIsSet) {
            builder.managed(json.managed);
        }
        return builder.build();
    }

    public static ImmutableRoleData of(Id id, String name, int color, boolean hoist, long permissions, boolean mentionable, Possible<Optional<String>> icon, Possible<Optional<String>> unicodeEmoji, Possible<RoleTagsData> tags, int flags, int position, boolean managed) {
        return new ImmutableRoleData(id, name, color, hoist, permissions, mentionable, icon, unicodeEmoji, tags, flags, position, managed);
    }

    public static ImmutableRoleData copyOf(RoleData instance) {
        if (instance instanceof ImmutableRoleData) {
            return (ImmutableRoleData)instance;
        }
        return ImmutableRoleData.builder().from(instance).build();
    }

    public boolean isIconPresent() {
        return !this.icon_absent;
    }

    public String iconOrElse(String defaultValue) {
        return !this.icon_absent ? this.icon_value : defaultValue;
    }

    public boolean isUnicodeEmojiPresent() {
        return !this.unicodeEmoji_absent;
    }

    public String unicodeEmojiOrElse(String defaultValue) {
        return !this.unicodeEmoji_absent ? this.unicodeEmoji_value : defaultValue;
    }

    public boolean isTagsPresent() {
        return !this.tags_absent;
    }

    public RoleTagsData tagsOrElse(RoleTagsData defaultValue) {
        return !this.tags_absent ? this.tags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_COLOR = 2L;
        private static final long INIT_BIT_HOIST = 4L;
        private static final long INIT_BIT_PERMISSIONS = 8L;
        private static final long INIT_BIT_MENTIONABLE = 16L;
        private static final long INIT_BIT_FLAGS = 32L;
        private static final long INIT_BIT_POSITION = 64L;
        private static final long INIT_BIT_MANAGED = 128L;
        private long initBits = 255L;
        private Id id_id = null;
        private Possible<Optional<String>> icon_possible = Possible.absent();
        private Possible<Optional<String>> unicodeEmoji_possible = Possible.absent();
        private Possible<RoleTagsData> tags_possible = Possible.absent();
        @Nullable
        private String name;
        private int color;
        private boolean hoist;
        private long permissions;
        private boolean mentionable;
        private int flags;
        private int position;
        private boolean managed;

        private Builder() {
        }

        public final Builder from(RoleDataFields instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(RoleData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            RoleDataFields instance;
            long bits = 0L;
            if (object instanceof RoleDataFields) {
                instance = (RoleDataFields)object;
                if ((bits & 1L) == 0L) {
                    this.color(instance.color());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.permissions(instance.permissions());
                    bits |= 0x20L;
                }
                if ((bits & 2L) == 0L) {
                    this.icon(instance.icon());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.mentionable(instance.mentionable());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x100L;
                }
                if ((bits & 8L) == 0L) {
                    this.hoist(instance.hoist());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.tags(instance.tags());
                    bits |= 0x10L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.unicodeEmoji(instance.unicodeEmoji());
                    bits |= 0x200L;
                }
            }
            if (object instanceof RoleData) {
                instance = (RoleData)object;
                if ((bits & 1L) == 0L) {
                    this.color(instance.color());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.permissions(instance.permissions());
                    bits |= 0x20L;
                }
                this.managed(instance.managed());
                if ((bits & 2L) == 0L) {
                    this.icon(instance.icon());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.flags(instance.flags());
                    bits |= 4L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.name(instance.name());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.mentionable(instance.mentionable());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.id(instance.id());
                    bits |= 0x100L;
                }
                this.position(instance.position());
                if ((bits & 8L) == 0L) {
                    this.hoist(instance.hoist());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.tags(instance.tags());
                    bits |= 0x10L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.unicodeEmoji(instance.unicodeEmoji());
                    bits |= 0x200L;
                }
            }
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="color")
        public final Builder color(int color) {
            this.color = color;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="hoist")
        public final Builder hoist(boolean hoist) {
            this.hoist = hoist;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="permissions")
        public final Builder permissions(long permissions) {
            this.permissions = permissions;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="mentionable")
        public final Builder mentionable(boolean mentionable) {
            this.mentionable = mentionable;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="icon")
        public Builder icon(Possible<Optional<String>> value) {
            this.icon_possible = value;
            return this;
        }

        @Deprecated
        public Builder icon(@Nullable String value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder iconOrNull(@Nullable String value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="unicode_emoji")
        public Builder unicodeEmoji(Possible<Optional<String>> value) {
            this.unicodeEmoji_possible = value;
            return this;
        }

        @Deprecated
        public Builder unicodeEmoji(@Nullable String value) {
            this.unicodeEmoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder unicodeEmojiOrNull(@Nullable String value) {
            this.unicodeEmoji_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="tags")
        public Builder tags(Possible<RoleTagsData> value) {
            this.tags_possible = value;
            return this;
        }

        public Builder tags(RoleTagsData value) {
            this.tags_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="flags")
        public final Builder flags(int flags) {
            this.flags = flags;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="position")
        public final Builder position(int position) {
            this.position = position;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="managed")
        public final Builder managed(boolean managed) {
            this.managed = managed;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableRoleData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoleData(null, this.id_build(), this.name, this.color, this.hoist, this.permissions, this.mentionable, this.icon_build(), this.unicodeEmoji_build(), this.tags_build(), this.flags, this.position, this.managed);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("color");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hoist");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("permissions");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("mentionable");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("flags");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("position");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("managed");
            }
            return "Cannot build RoleData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Possible<Optional<String>> icon_build() {
            return this.icon_possible;
        }

        private Possible<Optional<String>> unicodeEmoji_build() {
            return this.unicodeEmoji_possible;
        }

        private Possible<RoleTagsData> tags_build() {
            return this.tags_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RoleData {
        @Nullable
        Id id;
        @Nullable
        String name;
        int color;
        boolean colorIsSet;
        boolean hoist;
        boolean hoistIsSet;
        long permissions;
        boolean permissionsIsSet;
        boolean mentionable;
        boolean mentionableIsSet;
        Possible<Optional<String>> icon = Possible.absent();
        Possible<Optional<String>> unicodeEmoji = Possible.absent();
        Possible<RoleTagsData> tags = Possible.absent();
        int flags;
        boolean flagsIsSet;
        int position;
        boolean positionIsSet;
        boolean managed;
        boolean managedIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="color")
        public void setColor(int color) {
            this.color = color;
            this.colorIsSet = true;
        }

        @JsonProperty(value="hoist")
        public void setHoist(boolean hoist) {
            this.hoist = hoist;
            this.hoistIsSet = true;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(long permissions) {
            this.permissions = permissions;
            this.permissionsIsSet = true;
        }

        @JsonProperty(value="mentionable")
        public void setMentionable(boolean mentionable) {
            this.mentionable = mentionable;
            this.mentionableIsSet = true;
        }

        @JsonProperty(value="icon")
        public void setIcon(Possible<Optional<String>> icon) {
            this.icon = icon;
        }

        @JsonProperty(value="unicode_emoji")
        public void setUnicodeEmoji(Possible<Optional<String>> unicodeEmoji) {
            this.unicodeEmoji = unicodeEmoji;
        }

        @JsonProperty(value="tags")
        public void setTags(Possible<RoleTagsData> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="flags")
        public void setFlags(int flags) {
            this.flags = flags;
            this.flagsIsSet = true;
        }

        @JsonProperty(value="position")
        public void setPosition(int position) {
            this.position = position;
            this.positionIsSet = true;
        }

        @JsonProperty(value="managed")
        public void setManaged(boolean managed) {
            this.managed = managed;
            this.managedIsSet = true;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int color() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hoist() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mentionable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> unicodeEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<RoleTagsData> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int position() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean managed() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build RoleData, attribute initializers form cycle " + attributes;
        }
    }
}

