/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.PollAnswerCountObject;
import discord4j.discordjson.json.PollResultObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutablePollResultObject
implements PollResultObject {
    private final boolean isFinalized;
    private final List<PollAnswerCountObject> answerCounts;

    private ImmutablePollResultObject(boolean isFinalized, Iterable<? extends PollAnswerCountObject> answerCounts) {
        this.isFinalized = isFinalized;
        this.answerCounts = ImmutablePollResultObject.createUnmodifiableList(false, ImmutablePollResultObject.createSafeList(answerCounts, true, false));
    }

    private ImmutablePollResultObject(ImmutablePollResultObject original, boolean isFinalized, List<PollAnswerCountObject> answerCounts) {
        this.isFinalized = isFinalized;
        this.answerCounts = answerCounts;
    }

    @Override
    @JsonProperty(value="is_finalized")
    public boolean isFinalized() {
        return this.isFinalized;
    }

    @Override
    @JsonProperty(value="answer_counts")
    public List<PollAnswerCountObject> answerCounts() {
        return this.answerCounts;
    }

    public final ImmutablePollResultObject withIsFinalized(boolean value) {
        if (this.isFinalized == value) {
            return this;
        }
        return new ImmutablePollResultObject(this, value, this.answerCounts);
    }

    public final ImmutablePollResultObject withAnswerCounts(PollAnswerCountObject ... elements) {
        List<PollAnswerCountObject> newValue = ImmutablePollResultObject.createUnmodifiableList(false, ImmutablePollResultObject.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePollResultObject(this, this.isFinalized, newValue);
    }

    public final ImmutablePollResultObject withAnswerCounts(Iterable<? extends PollAnswerCountObject> elements) {
        if (this.answerCounts == elements) {
            return this;
        }
        List<PollAnswerCountObject> newValue = ImmutablePollResultObject.createUnmodifiableList(false, ImmutablePollResultObject.createSafeList(elements, true, false));
        return new ImmutablePollResultObject(this, this.isFinalized, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollResultObject && this.equalTo(0, (ImmutablePollResultObject)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollResultObject another) {
        return this.isFinalized == another.isFinalized && this.answerCounts.equals(another.answerCounts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.isFinalized);
        h += (h << 5) + this.answerCounts.hashCode();
        return h;
    }

    public String toString() {
        return "PollResultObject{isFinalized=" + this.isFinalized + ", answerCounts=" + this.answerCounts + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePollResultObject fromJson(Json json) {
        Builder builder = ImmutablePollResultObject.builder();
        if (json.isFinalizedIsSet) {
            builder.isFinalized(json.isFinalized);
        }
        if (json.answerCounts != null) {
            builder.addAllAnswerCounts(json.answerCounts);
        }
        return builder.build();
    }

    public static ImmutablePollResultObject of(boolean isFinalized, List<PollAnswerCountObject> answerCounts) {
        return ImmutablePollResultObject.of(isFinalized, answerCounts);
    }

    public static ImmutablePollResultObject of(boolean isFinalized, Iterable<? extends PollAnswerCountObject> answerCounts) {
        return new ImmutablePollResultObject(isFinalized, answerCounts);
    }

    public static ImmutablePollResultObject copyOf(PollResultObject instance) {
        if (instance instanceof ImmutablePollResultObject) {
            return (ImmutablePollResultObject)instance;
        }
        return ImmutablePollResultObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_IS_FINALIZED = 1L;
        private long initBits = 1L;
        private boolean isFinalized;
        private List<PollAnswerCountObject> answerCounts = new ArrayList<PollAnswerCountObject>();

        private Builder() {
        }

        public final Builder from(PollResultObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.isFinalized(instance.isFinalized());
            this.addAllAnswerCounts(instance.answerCounts());
            return this;
        }

        @JsonProperty(value="is_finalized")
        public final Builder isFinalized(boolean isFinalized) {
            this.isFinalized = isFinalized;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAnswerCount(PollAnswerCountObject element) {
            this.answerCounts.add(Objects.requireNonNull(element, "answerCounts element"));
            return this;
        }

        public final Builder addAnswerCounts(PollAnswerCountObject ... elements) {
            for (PollAnswerCountObject element : elements) {
                this.answerCounts.add(Objects.requireNonNull(element, "answerCounts element"));
            }
            return this;
        }

        @JsonProperty(value="answer_counts")
        public final Builder answerCounts(Iterable<? extends PollAnswerCountObject> elements) {
            this.answerCounts.clear();
            return this.addAllAnswerCounts(elements);
        }

        public final Builder addAllAnswerCounts(Iterable<? extends PollAnswerCountObject> elements) {
            for (PollAnswerCountObject pollAnswerCountObject : elements) {
                this.answerCounts.add(Objects.requireNonNull(pollAnswerCountObject, "answerCounts element"));
            }
            return this;
        }

        public ImmutablePollResultObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePollResultObject(null, this.isFinalized, ImmutablePollResultObject.createUnmodifiableList(true, this.answerCounts));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isFinalized");
            }
            return "Cannot build PollResultObject, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements PollResultObject {
        boolean isFinalized;
        boolean isFinalizedIsSet;
        @Nullable
        List<PollAnswerCountObject> answerCounts = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="is_finalized")
        public void setIsFinalized(boolean isFinalized) {
            this.isFinalized = isFinalized;
            this.isFinalizedIsSet = true;
        }

        @JsonProperty(value="answer_counts")
        public void setAnswerCounts(List<PollAnswerCountObject> answerCounts) {
            this.answerCounts = answerCounts;
        }

        @Override
        public boolean isFinalized() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PollAnswerCountObject> answerCounts() {
            throw new UnsupportedOperationException();
        }
    }
}

