/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModRuleModifyRequest;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="AutoModRuleModifyRequest", generator="Immutables")
public final class ImmutableAutoModRuleModifyRequest
implements AutoModRuleModifyRequest {
    private final String name;
    private final int eventType;
    private final AutoModTriggerMetaData triggerMetadata_value;
    private final boolean triggerMetadata_absent;
    private final List<AutoModActionData> actions;
    private final boolean enabled;
    private final long[] exemptRoles_value;
    private final long[] exemptChannels_value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAutoModRuleModifyRequest(String name, int eventType, Possible<AutoModTriggerMetaData> triggerMetadata, Iterable<? extends AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        this.name = Objects.requireNonNull(name, "name");
        this.eventType = eventType;
        Possible<AutoModTriggerMetaData> triggerMetadata$impl = triggerMetadata;
        this.actions = ImmutableAutoModRuleModifyRequest.createUnmodifiableList(false, ImmutableAutoModRuleModifyRequest.createSafeList(actions, true, false));
        this.enabled = enabled;
        List<Id> exemptRoles$impl = exemptRoles;
        List<Id> exemptChannels$impl = exemptChannels;
        this.triggerMetadata_value = triggerMetadata$impl.toOptional().orElse(null);
        this.triggerMetadata_absent = triggerMetadata$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.stream().mapToLong(Id::asLong).toArray();
        this.exemptChannels_value = exemptChannels$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableAutoModRuleModifyRequest(ImmutableAutoModRuleModifyRequest original, String name, int eventType, Possible<AutoModTriggerMetaData> triggerMetadata, List<AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        this.name = name;
        this.eventType = eventType;
        Possible<AutoModTriggerMetaData> triggerMetadata$impl = triggerMetadata;
        this.actions = actions;
        this.enabled = enabled;
        List<Id> exemptRoles$impl = exemptRoles;
        List<Id> exemptChannels$impl = exemptChannels;
        this.triggerMetadata_value = triggerMetadata$impl.toOptional().orElse(null);
        this.triggerMetadata_absent = triggerMetadata$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.stream().mapToLong(Id::asLong).toArray();
        this.exemptChannels_value = exemptChannels$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="event_type")
    public int eventType() {
        return this.eventType;
    }

    @Override
    @JsonProperty(value="trigger_metadata")
    public Possible<AutoModTriggerMetaData> triggerMetadata() {
        return this.triggerMetadata_absent ? Possible.absent() : Possible.of((Object)this.triggerMetadata_value);
    }

    @Override
    @JsonProperty(value="actions")
    public List<AutoModActionData> actions() {
        return this.actions;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="exempt_roles")
    public List<Id> exemptRoles() {
        return LongStream.of(this.exemptRoles_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="exempt_channels")
    public List<Id> exemptChannels() {
        return LongStream.of(this.exemptChannels_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    public final ImmutableAutoModRuleModifyRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAutoModRuleModifyRequest(this, newValue, this.eventType, this.triggerMetadata(), this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleModifyRequest withEventType(int value) {
        if (this.eventType == value) {
            return this;
        }
        return new ImmutableAutoModRuleModifyRequest(this, this.name, value, this.triggerMetadata(), this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleModifyRequest withTriggerMetadata(Possible<AutoModTriggerMetaData> value) {
        Possible<AutoModTriggerMetaData> newValue = Objects.requireNonNull(value);
        return new ImmutableAutoModRuleModifyRequest(this, this.name, this.eventType, newValue, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleModifyRequest withTriggerMetadata(AutoModTriggerMetaData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableAutoModRuleModifyRequest(this, this.name, this.eventType, (Possible<AutoModTriggerMetaData>)newValue, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleModifyRequest withActions(AutoModActionData ... elements) {
        List<AutoModActionData> newValue = ImmutableAutoModRuleModifyRequest.createUnmodifiableList(false, ImmutableAutoModRuleModifyRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAutoModRuleModifyRequest(this, this.name, this.eventType, this.triggerMetadata(), newValue, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleModifyRequest withActions(Iterable<? extends AutoModActionData> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<AutoModActionData> newValue = ImmutableAutoModRuleModifyRequest.createUnmodifiableList(false, ImmutableAutoModRuleModifyRequest.createSafeList(elements, true, false));
        return new ImmutableAutoModRuleModifyRequest(this, this.name, this.eventType, this.triggerMetadata(), newValue, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleModifyRequest withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableAutoModRuleModifyRequest(this, this.name, this.eventType, this.triggerMetadata(), this.actions, value, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleModifyRequest withExemptRoles(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableAutoModRuleModifyRequest(this, this.name, this.eventType, this.triggerMetadata(), this.actions, this.enabled, newValue, this.exemptChannels());
    }

    public ImmutableAutoModRuleModifyRequest withExemptChannels(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableAutoModRuleModifyRequest(this, this.name, this.eventType, this.triggerMetadata(), this.actions, this.enabled, this.exemptRoles(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAutoModRuleModifyRequest && this.equalTo(0, (ImmutableAutoModRuleModifyRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableAutoModRuleModifyRequest another) {
        return this.name.equals(another.name) && this.eventType == another.eventType && this.triggerMetadata().equals(another.triggerMetadata()) && this.actions.equals(another.actions) && this.enabled == another.enabled && Objects.equals(this.exemptRoles_value, another.exemptRoles_value) && Objects.equals(this.exemptChannels_value, another.exemptChannels_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.eventType;
        h += (h << 5) + this.triggerMetadata().hashCode();
        h += (h << 5) + this.actions.hashCode();
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.exemptRoles_value);
        h += (h << 5) + Objects.hashCode(this.exemptChannels_value);
        return h;
    }

    public String toString() {
        return "AutoModRuleModifyRequest{name=" + this.name + ", eventType=" + this.eventType + ", triggerMetadata=" + this.triggerMetadata().toString() + ", actions=" + this.actions + ", enabled=" + this.enabled + ", exemptRoles=" + Objects.toString(this.exemptRoles_value) + ", exemptChannels=" + Objects.toString(this.exemptChannels_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAutoModRuleModifyRequest fromJson(Json json) {
        Builder builder = ImmutableAutoModRuleModifyRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.eventTypeIsSet) {
            builder.eventType(json.eventType);
        }
        if (json.triggerMetadata != null) {
            builder.triggerMetadata(json.triggerMetadata);
        }
        if (json.actions != null) {
            builder.addAllActions(json.actions);
        }
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        if (json.exemptRoles != null) {
            builder.exemptRoles(json.exemptRoles);
        }
        if (json.exemptChannels != null) {
            builder.exemptChannels(json.exemptChannels);
        }
        return builder.build();
    }

    public static ImmutableAutoModRuleModifyRequest of(String name, int eventType, Possible<AutoModTriggerMetaData> triggerMetadata, List<AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        return ImmutableAutoModRuleModifyRequest.of(name, eventType, triggerMetadata, actions, enabled, exemptRoles, exemptChannels);
    }

    public static ImmutableAutoModRuleModifyRequest of(String name, int eventType, Possible<AutoModTriggerMetaData> triggerMetadata, Iterable<? extends AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        return new ImmutableAutoModRuleModifyRequest(name, eventType, triggerMetadata, actions, enabled, exemptRoles, exemptChannels);
    }

    public static ImmutableAutoModRuleModifyRequest copyOf(AutoModRuleModifyRequest instance) {
        if (instance instanceof ImmutableAutoModRuleModifyRequest) {
            return (ImmutableAutoModRuleModifyRequest)instance;
        }
        return ImmutableAutoModRuleModifyRequest.builder().from(instance).build();
    }

    public boolean isTriggerMetadataPresent() {
        return !this.triggerMetadata_absent;
    }

    public AutoModTriggerMetaData triggerMetadataOrElse(AutoModTriggerMetaData defaultValue) {
        return !this.triggerMetadata_absent ? this.triggerMetadata_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AutoModRuleModifyRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_EVENT_TYPE = 2L;
        private static final long INIT_BIT_ENABLED = 4L;
        private long initBits = 7L;
        private Possible<AutoModTriggerMetaData> triggerMetadata_possible = Possible.absent();
        private List<Long> exemptRoles_list = null;
        private List<Long> exemptChannels_list = null;
        private String name;
        private int eventType;
        private List<AutoModActionData> actions = new ArrayList<AutoModActionData>();
        private boolean enabled;

        private Builder() {
        }

        public final Builder from(AutoModRuleModifyRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.eventType(instance.eventType());
            this.triggerMetadata(instance.triggerMetadata());
            this.addAllActions(instance.actions());
            this.enabled(instance.enabled());
            this.exemptRoles(instance.exemptRoles());
            this.exemptChannels(instance.exemptChannels());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="event_type")
        public final Builder eventType(int eventType) {
            this.eventType = eventType;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="trigger_metadata")
        public Builder triggerMetadata(Possible<AutoModTriggerMetaData> value) {
            this.triggerMetadata_possible = value;
            return this;
        }

        public Builder triggerMetadata(AutoModTriggerMetaData value) {
            this.triggerMetadata_possible = Possible.of((Object)value);
            return this;
        }

        public final Builder addAction(AutoModActionData element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return this;
        }

        public final Builder addActions(AutoModActionData ... elements) {
            for (AutoModActionData element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        @JsonProperty(value="actions")
        public final Builder actions(Iterable<? extends AutoModActionData> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        public final Builder addAllActions(Iterable<? extends AutoModActionData> elements) {
            for (AutoModActionData autoModActionData : elements) {
                this.actions.add(Objects.requireNonNull(autoModActionData, "actions element"));
            }
            return this;
        }

        @JsonProperty(value="enabled")
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder addExemptRole(long element) {
            this.exemptRoles_getOrCreate().add(element);
            return this;
        }

        public Builder addExemptRole(String element) {
            this.exemptRoles_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addExemptRole(Id element) {
            this.exemptRoles_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllExemptRoles(List<Long> elements) {
            this.exemptRoles_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="exempt_roles")
        public Builder exemptRoles(List<Id> elements) {
            this.exemptRoles_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder exemptRoles(Iterable<Id> elements) {
            this.exemptRoles_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addExemptChannel(long element) {
            this.exemptChannels_getOrCreate().add(element);
            return this;
        }

        public Builder addExemptChannel(String element) {
            this.exemptChannels_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addExemptChannel(Id element) {
            this.exemptChannels_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllExemptChannels(List<Long> elements) {
            this.exemptChannels_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="exempt_channels")
        public Builder exemptChannels(List<Id> elements) {
            this.exemptChannels_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder exemptChannels(Iterable<Id> elements) {
            this.exemptChannels_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public ImmutableAutoModRuleModifyRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAutoModRuleModifyRequest(null, this.name, this.eventType, this.triggerMetadata_build(), ImmutableAutoModRuleModifyRequest.createUnmodifiableList(true, this.actions), this.enabled, this.exemptRoles_build(), this.exemptChannels_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("eventType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build AutoModRuleModifyRequest, some of required attributes are not set " + attributes;
        }

        private Possible<AutoModTriggerMetaData> triggerMetadata_build() {
            return this.triggerMetadata_possible;
        }

        private List<Id> exemptRoles_build() {
            return this.exemptRoles_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> exemptRoles_getOrCreate() {
            if (this.exemptRoles_list == null) {
                this.exemptRoles_list = new ArrayList<Long>();
            }
            return this.exemptRoles_list;
        }

        private List<Id> exemptChannels_build() {
            return this.exemptChannels_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> exemptChannels_getOrCreate() {
            if (this.exemptChannels_list == null) {
                this.exemptChannels_list = new ArrayList<Long>();
            }
            return this.exemptChannels_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AutoModRuleModifyRequest", generator="Immutables")
    static final class Json
    implements AutoModRuleModifyRequest {
        String name;
        int eventType;
        boolean eventTypeIsSet;
        Possible<AutoModTriggerMetaData> triggerMetadata = Possible.absent();
        List<AutoModActionData> actions = Collections.emptyList();
        boolean enabled;
        boolean enabledIsSet;
        List<Id> exemptRoles;
        List<Id> exemptChannels;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="event_type")
        public void setEventType(int eventType) {
            this.eventType = eventType;
            this.eventTypeIsSet = true;
        }

        @JsonProperty(value="trigger_metadata")
        public void setTriggerMetadata(Possible<AutoModTriggerMetaData> triggerMetadata) {
            this.triggerMetadata = triggerMetadata;
        }

        @JsonProperty(value="actions")
        public void setActions(List<AutoModActionData> actions) {
            this.actions = actions;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @JsonProperty(value="exempt_roles")
        public void setExemptRoles(List<Id> exemptRoles) {
            this.exemptRoles = exemptRoles;
        }

        @JsonProperty(value="exempt_channels")
        public void setExemptChannels(List<Id> exemptChannels) {
            this.exemptChannels = exemptChannels;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int eventType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<AutoModTriggerMetaData> triggerMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AutoModActionData> actions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> exemptRoles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> exemptChannels() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AutoModRuleModifyRequest", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build AutoModRuleModifyRequest, attribute initializers form cycle " + attributes;
        }
    }
}

