/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="GuildEmojisUpdate", generator="Immutables")
public final class ImmutableGuildEmojisUpdate
implements GuildEmojisUpdate {
    private final String guildId;
    private final List<EmojiData> emojis;

    private ImmutableGuildEmojisUpdate(String guildId, Iterable<? extends EmojiData> emojis) {
        this.guildId = Objects.requireNonNull(guildId, "guildId");
        this.emojis = ImmutableGuildEmojisUpdate.createUnmodifiableList(false, ImmutableGuildEmojisUpdate.createSafeList(emojis, true, false));
    }

    private ImmutableGuildEmojisUpdate(ImmutableGuildEmojisUpdate original, String guildId, List<EmojiData> emojis) {
        this.guildId = guildId;
        this.emojis = emojis;
    }

    @Override
    @JsonProperty(value="guild_id")
    public String guildId() {
        return this.guildId;
    }

    @Override
    @JsonProperty(value="emojis")
    public List<EmojiData> emojis() {
        return this.emojis;
    }

    public final ImmutableGuildEmojisUpdate withGuildId(String value) {
        String newValue = Objects.requireNonNull(value, "guildId");
        if (this.guildId.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildEmojisUpdate(this, newValue, this.emojis);
    }

    public final ImmutableGuildEmojisUpdate withEmojis(EmojiData ... elements) {
        List<EmojiData> newValue = ImmutableGuildEmojisUpdate.createUnmodifiableList(false, ImmutableGuildEmojisUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildEmojisUpdate(this, this.guildId, newValue);
    }

    public final ImmutableGuildEmojisUpdate withEmojis(Iterable<? extends EmojiData> elements) {
        if (this.emojis == elements) {
            return this;
        }
        List<EmojiData> newValue = ImmutableGuildEmojisUpdate.createUnmodifiableList(false, ImmutableGuildEmojisUpdate.createSafeList(elements, true, false));
        return new ImmutableGuildEmojisUpdate(this, this.guildId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildEmojisUpdate && this.equalTo((ImmutableGuildEmojisUpdate)another);
    }

    private boolean equalTo(ImmutableGuildEmojisUpdate another) {
        return this.guildId.equals(another.guildId) && this.emojis.equals(another.emojis);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.guildId.hashCode();
        h += (h << 5) + this.emojis.hashCode();
        return h;
    }

    public String toString() {
        return "GuildEmojisUpdate{guildId=" + this.guildId + ", emojis=" + this.emojis + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildEmojisUpdate fromJson(Json json) {
        Builder builder = ImmutableGuildEmojisUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.emojis != null) {
            builder.addAllEmojis(json.emojis);
        }
        return builder.build();
    }

    public static ImmutableGuildEmojisUpdate of(String guildId, List<EmojiData> emojis) {
        return ImmutableGuildEmojisUpdate.of(guildId, emojis);
    }

    public static ImmutableGuildEmojisUpdate of(String guildId, Iterable<? extends EmojiData> emojis) {
        return new ImmutableGuildEmojisUpdate(guildId, emojis);
    }

    public static ImmutableGuildEmojisUpdate copyOf(GuildEmojisUpdate instance) {
        if (instance instanceof ImmutableGuildEmojisUpdate) {
            return (ImmutableGuildEmojisUpdate)instance;
        }
        return ImmutableGuildEmojisUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildEmojisUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_GUILD_ID = 1L;
        private long initBits = 1L;
        private String guildId;
        private List<EmojiData> emojis = new ArrayList<EmojiData>();

        private Builder() {
        }

        public final Builder from(GuildEmojisUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.addAllEmojis(instance.emojis());
            return this;
        }

        @JsonProperty(value="guild_id")
        public final Builder guildId(String guildId) {
            this.guildId = Objects.requireNonNull(guildId, "guildId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEmoji(EmojiData element) {
            this.emojis.add(Objects.requireNonNull(element, "emojis element"));
            return this;
        }

        public final Builder addEmojis(EmojiData ... elements) {
            for (EmojiData element : elements) {
                this.emojis.add(Objects.requireNonNull(element, "emojis element"));
            }
            return this;
        }

        @JsonProperty(value="emojis")
        public final Builder emojis(Iterable<? extends EmojiData> elements) {
            this.emojis.clear();
            return this.addAllEmojis(elements);
        }

        public final Builder addAllEmojis(Iterable<? extends EmojiData> elements) {
            for (EmojiData emojiData : elements) {
                this.emojis.add(Objects.requireNonNull(emojiData, "emojis element"));
            }
            return this;
        }

        public ImmutableGuildEmojisUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildEmojisUpdate(null, this.guildId, ImmutableGuildEmojisUpdate.createUnmodifiableList(true, this.emojis));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("guildId");
            }
            return "Cannot build GuildEmojisUpdate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GuildEmojisUpdate", generator="Immutables")
    static final class Json
    implements GuildEmojisUpdate {
        String guildId;
        List<EmojiData> emojis = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(String guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="emojis")
        public void setEmojis(List<EmojiData> emojis) {
            this.emojis = emojis;
        }

        @Override
        public String guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<EmojiData> emojis() {
            throw new UnsupportedOperationException();
        }
    }
}

