/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="StickerData", generator="Immutables")
public final class ImmutableStickerData
implements StickerData {
    private final String id;
    private final String packId;
    private final String name;
    private final String description;
    private final String tags_value;
    private final boolean tags_absent;
    private final String asset;
    private final String previewAsset;
    private final int formatType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStickerData(String id, String packId, String name, String description, Possible<String> tags, String asset, Optional<String> previewAsset, int formatType) {
        this.id = Objects.requireNonNull(id, "id");
        this.packId = Objects.requireNonNull(packId, "packId");
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        Possible<String> tags$impl = tags;
        this.asset = Objects.requireNonNull(asset, "asset");
        this.previewAsset = previewAsset.orElse(null);
        this.formatType = formatType;
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableStickerData(ImmutableStickerData original, String id, String packId, String name, String description, Possible<String> tags, String asset, String previewAsset, int formatType) {
        this.id = id;
        this.packId = packId;
        this.name = name;
        this.description = description;
        Possible<String> tags$impl = tags;
        this.asset = asset;
        this.previewAsset = previewAsset;
        this.formatType = formatType;
        this.tags_value = tags$impl.toOptional().orElse(null);
        this.tags_absent = tags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="pack_id")
    public String packId() {
        return this.packId;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="tags")
    public Possible<String> tags() {
        return this.tags_absent ? Possible.absent() : Possible.of((Object)this.tags_value);
    }

    @Override
    @JsonProperty(value="asset")
    public String asset() {
        return this.asset;
    }

    @Override
    @JsonProperty(value="preview_asset")
    public Optional<String> previewAsset() {
        return Optional.ofNullable(this.previewAsset);
    }

    @Override
    @JsonProperty(value="format_type")
    public int formatType() {
        return this.formatType;
    }

    public final ImmutableStickerData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, newValue, this.packId, this.name, this.description, this.tags(), this.asset, this.previewAsset, this.formatType);
    }

    public final ImmutableStickerData withPackId(String value) {
        String newValue = Objects.requireNonNull(value, "packId");
        if (this.packId.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id, newValue, this.name, this.description, this.tags(), this.asset, this.previewAsset, this.formatType);
    }

    public final ImmutableStickerData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id, this.packId, newValue, this.description, this.tags(), this.asset, this.previewAsset, this.formatType);
    }

    public final ImmutableStickerData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id, this.packId, this.name, newValue, this.tags(), this.asset, this.previewAsset, this.formatType);
    }

    public ImmutableStickerData withTags(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerData(this, this.id, this.packId, this.name, this.description, newValue, this.asset, this.previewAsset, this.formatType);
    }

    public ImmutableStickerData withTags(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableStickerData(this, this.id, this.packId, this.name, this.description, (Possible<String>)newValue, this.asset, this.previewAsset, this.formatType);
    }

    public final ImmutableStickerData withAsset(String value) {
        String newValue = Objects.requireNonNull(value, "asset");
        if (this.asset.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id, this.packId, this.name, this.description, this.tags(), newValue, this.previewAsset, this.formatType);
    }

    public final ImmutableStickerData withPreviewAsset(String value) {
        String newValue = Objects.requireNonNull(value, "previewAsset");
        if (Objects.equals(this.previewAsset, newValue)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id, this.packId, this.name, this.description, this.tags(), this.asset, newValue, this.formatType);
    }

    public final ImmutableStickerData withPreviewAsset(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.previewAsset, value)) {
            return this;
        }
        return new ImmutableStickerData(this, this.id, this.packId, this.name, this.description, this.tags(), this.asset, value, this.formatType);
    }

    public final ImmutableStickerData withFormatType(int value) {
        if (this.formatType == value) {
            return this;
        }
        return new ImmutableStickerData(this, this.id, this.packId, this.name, this.description, this.tags(), this.asset, this.previewAsset, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerData && this.equalTo((ImmutableStickerData)another);
    }

    private boolean equalTo(ImmutableStickerData another) {
        return this.id.equals(another.id) && this.packId.equals(another.packId) && this.name.equals(another.name) && this.description.equals(another.description) && this.tags().equals(another.tags()) && this.asset.equals(another.asset) && Objects.equals(this.previewAsset, another.previewAsset) && this.formatType == another.formatType;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.packId.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.tags().hashCode();
        h += (h << 5) + this.asset.hashCode();
        h += (h << 5) + Objects.hashCode(this.previewAsset);
        h += (h << 5) + this.formatType;
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StickerData{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("packId=").append(this.packId);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("tags=").append(this.tags().toString());
        builder.append(", ");
        builder.append("asset=").append(this.asset);
        if (this.previewAsset != null) {
            builder.append(", ");
            builder.append("previewAsset=").append(this.previewAsset);
        }
        builder.append(", ");
        builder.append("formatType=").append(this.formatType);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStickerData fromJson(Json json) {
        Builder builder = ImmutableStickerData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.packId != null) {
            builder.packId(json.packId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.tags != null) {
            builder.tags(json.tags);
        }
        if (json.asset != null) {
            builder.asset(json.asset);
        }
        if (json.previewAsset != null) {
            builder.previewAsset(json.previewAsset);
        }
        if (json.formatTypeIsSet) {
            builder.formatType(json.formatType);
        }
        return builder.build();
    }

    public static ImmutableStickerData of(String id, String packId, String name, String description, Possible<String> tags, String asset, Optional<String> previewAsset, int formatType) {
        return new ImmutableStickerData(id, packId, name, description, tags, asset, previewAsset, formatType);
    }

    public static ImmutableStickerData copyOf(StickerData instance) {
        if (instance instanceof ImmutableStickerData) {
            return (ImmutableStickerData)instance;
        }
        return ImmutableStickerData.builder().from(instance).build();
    }

    public boolean isTagsPresent() {
        return !this.tags_absent;
    }

    public String tagsOrElse(String defaultValue) {
        return !this.tags_absent ? this.tags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StickerData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_PACK_ID = 2L;
        private static final long INIT_BIT_NAME = 4L;
        private static final long INIT_BIT_DESCRIPTION = 8L;
        private static final long INIT_BIT_ASSET = 16L;
        private static final long INIT_BIT_FORMAT_TYPE = 32L;
        private long initBits = 63L;
        private Possible<String> tags_possible = Possible.absent();
        private String id;
        private String packId;
        private String name;
        private String description;
        private String asset;
        private String previewAsset;
        private int formatType;

        private Builder() {
        }

        public final Builder from(StickerData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.packId(instance.packId());
            this.name(instance.name());
            this.description(instance.description());
            this.tags(instance.tags());
            this.asset(instance.asset());
            Optional<String> previewAssetOptional = instance.previewAsset();
            if (previewAssetOptional.isPresent()) {
                this.previewAsset(previewAssetOptional);
            }
            this.formatType(instance.formatType());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="pack_id")
        public final Builder packId(String packId) {
            this.packId = Objects.requireNonNull(packId, "packId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="tags")
        public Builder tags(Possible<String> value) {
            this.tags_possible = value;
            return this;
        }

        public Builder tags(String value) {
            this.tags_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="asset")
        public final Builder asset(String asset) {
            this.asset = Objects.requireNonNull(asset, "asset");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder previewAsset(String previewAsset) {
            this.previewAsset = Objects.requireNonNull(previewAsset, "previewAsset");
            return this;
        }

        @JsonProperty(value="preview_asset")
        public final Builder previewAsset(Optional<String> previewAsset) {
            this.previewAsset = previewAsset.orElse(null);
            return this;
        }

        @JsonProperty(value="format_type")
        public final Builder formatType(int formatType) {
            this.formatType = formatType;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableStickerData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerData(null, this.id, this.packId, this.name, this.description, this.tags_build(), this.asset, this.previewAsset, this.formatType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("packId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("asset");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("formatType");
            }
            return "Cannot build StickerData, some of required attributes are not set " + attributes;
        }

        private Possible<String> tags_build() {
            return this.tags_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StickerData", generator="Immutables")
    static final class Json
    implements StickerData {
        String id;
        String packId;
        String name;
        String description;
        Possible<String> tags;
        String asset;
        Optional<String> previewAsset = Optional.empty();
        int formatType;
        boolean formatTypeIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="pack_id")
        public void setPackId(String packId) {
            this.packId = packId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="tags")
        public void setTags(Possible<String> tags) {
            this.tags = tags;
        }

        @JsonProperty(value="asset")
        public void setAsset(String asset) {
            this.asset = asset;
        }

        @JsonProperty(value="preview_asset")
        public void setPreviewAsset(Optional<String> previewAsset) {
            this.previewAsset = previewAsset;
        }

        @JsonProperty(value="format_type")
        public void setFormatType(int formatType) {
            this.formatType = formatType;
            this.formatTypeIsSet = true;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String packId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String asset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> previewAsset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int formatType() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="StickerData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StickerData, attribute initializers form cycle " + attributes;
        }
    }
}

