/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="MemberData", generator="Immutables")
public final class ImmutableMemberData
implements MemberData {
    private final UserData user;
    private final String nick_value;
    private final boolean nick_absent;
    private final List<String> roles;
    private final String joinedAt;
    private final String premiumSince_value;
    private final boolean premiumSince_absent;
    private final String hoistedRole;
    private final boolean deaf;
    private final boolean mute;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMemberData(UserData user, Possible<Optional<String>> nick, Iterable<String> roles, String joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute) {
        this.user = Objects.requireNonNull(user, "user");
        Possible<Optional<String>> nick$impl = nick;
        this.roles = ImmutableMemberData.createUnmodifiableList(false, ImmutableMemberData.createSafeList(roles, true, false));
        this.joinedAt = Objects.requireNonNull(joinedAt, "joinedAt");
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole.orElse(null);
        this.deaf = deaf;
        this.mute = mute;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMemberData(ImmutableMemberData original, UserData user, Possible<Optional<String>> nick, List<String> roles, String joinedAt, Possible<Optional<String>> premiumSince, String hoistedRole, boolean deaf, boolean mute) {
        this.user = user;
        Possible<Optional<String>> nick$impl = nick;
        this.roles = roles;
        this.joinedAt = joinedAt;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole;
        this.deaf = deaf;
        this.mute = mute;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="nick")
    public Possible<Optional<String>> nick() {
        return this.nick_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nick_value));
    }

    @Override
    @JsonProperty(value="roles")
    public List<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="joined_at")
    public String joinedAt() {
        return this.joinedAt;
    }

    @Override
    @JsonProperty(value="premium_since")
    public Possible<Optional<String>> premiumSince() {
        return this.premiumSince_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.premiumSince_value));
    }

    @Override
    @JsonProperty(value="hoisted_role")
    public Optional<String> hoistedRole() {
        return Optional.ofNullable(this.hoistedRole);
    }

    @Override
    @JsonProperty(value="deaf")
    public boolean deaf() {
        return this.deaf;
    }

    @Override
    @JsonProperty(value="mute")
    public boolean mute() {
        return this.mute;
    }

    public final ImmutableMemberData withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableMemberData(this, newValue, this.nick(), this.roles, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutableMemberData withNick(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableMemberData(this, this.user, newValue, this.roles, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutableMemberData withNick(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableMemberData(this, this.user, (Possible<Optional<String>>)newValue, this.roles, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public final ImmutableMemberData withRoles(String ... elements) {
        List<String> newValue = ImmutableMemberData.createUnmodifiableList(false, ImmutableMemberData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMemberData(this, this.user, this.nick(), newValue, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public final ImmutableMemberData withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<String> newValue = ImmutableMemberData.createUnmodifiableList(false, ImmutableMemberData.createSafeList(elements, true, false));
        return new ImmutableMemberData(this, this.user, this.nick(), newValue, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public final ImmutableMemberData withJoinedAt(String value) {
        String newValue = Objects.requireNonNull(value, "joinedAt");
        if (this.joinedAt.equals(newValue)) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles, newValue, this.premiumSince(), this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutableMemberData withPremiumSince(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles, this.joinedAt, newValue, this.hoistedRole, this.deaf, this.mute);
    }

    public ImmutableMemberData withPremiumSince(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles, this.joinedAt, (Possible<Optional<String>>)newValue, this.hoistedRole, this.deaf, this.mute);
    }

    public final ImmutableMemberData withHoistedRole(String value) {
        String newValue = Objects.requireNonNull(value, "hoistedRole");
        if (Objects.equals(this.hoistedRole, newValue)) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles, this.joinedAt, this.premiumSince(), newValue, this.deaf, this.mute);
    }

    public final ImmutableMemberData withHoistedRole(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hoistedRole, value)) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles, this.joinedAt, this.premiumSince(), value, this.deaf, this.mute);
    }

    public final ImmutableMemberData withDeaf(boolean value) {
        if (this.deaf == value) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles, this.joinedAt, this.premiumSince(), this.hoistedRole, value, this.mute);
    }

    public final ImmutableMemberData withMute(boolean value) {
        if (this.mute == value) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMemberData && this.equalTo((ImmutableMemberData)another);
    }

    private boolean equalTo(ImmutableMemberData another) {
        return this.user.equals(another.user) && this.nick().equals(another.nick()) && this.roles.equals(another.roles) && this.joinedAt.equals(another.joinedAt) && this.premiumSince().equals(another.premiumSince()) && Objects.equals(this.hoistedRole, another.hoistedRole) && this.deaf == another.deaf && this.mute == another.mute;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.nick().hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.joinedAt.hashCode();
        h += (h << 5) + this.premiumSince().hashCode();
        h += (h << 5) + Objects.hashCode(this.hoistedRole);
        h += (h << 5) + Boolean.hashCode(this.deaf);
        h += (h << 5) + Boolean.hashCode(this.mute);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MemberData{");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("nick=").append(this.nick().toString());
        builder.append(", ");
        builder.append("roles=").append(this.roles);
        builder.append(", ");
        builder.append("joinedAt=").append(this.joinedAt);
        builder.append(", ");
        builder.append("premiumSince=").append(this.premiumSince().toString());
        if (this.hoistedRole != null) {
            builder.append(", ");
            builder.append("hoistedRole=").append(this.hoistedRole);
        }
        builder.append(", ");
        builder.append("deaf=").append(this.deaf);
        builder.append(", ");
        builder.append("mute=").append(this.mute);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMemberData fromJson(Json json) {
        Builder builder = ImmutableMemberData.builder();
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.joinedAt != null) {
            builder.joinedAt(json.joinedAt);
        }
        if (json.premiumSince != null) {
            builder.premiumSince(json.premiumSince);
        }
        if (json.hoistedRole != null) {
            builder.hoistedRole(json.hoistedRole);
        }
        if (json.deafIsSet) {
            builder.deaf(json.deaf);
        }
        if (json.muteIsSet) {
            builder.mute(json.mute);
        }
        return builder.build();
    }

    public static ImmutableMemberData of(UserData user, Possible<Optional<String>> nick, List<String> roles, String joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute) {
        return ImmutableMemberData.of(user, nick, roles, joinedAt, premiumSince, hoistedRole, deaf, mute);
    }

    public static ImmutableMemberData of(UserData user, Possible<Optional<String>> nick, Iterable<String> roles, String joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute) {
        return new ImmutableMemberData(user, nick, roles, joinedAt, premiumSince, hoistedRole, deaf, mute);
    }

    public static ImmutableMemberData copyOf(MemberData instance) {
        if (instance instanceof ImmutableMemberData) {
            return (ImmutableMemberData)instance;
        }
        return ImmutableMemberData.builder().from(instance).build();
    }

    public boolean isNickPresent() {
        return !this.nick_absent;
    }

    public String nickOrElse(String defaultValue) {
        return !this.nick_absent ? this.nick_value : defaultValue;
    }

    public boolean isPremiumSincePresent() {
        return !this.premiumSince_absent;
    }

    public String premiumSinceOrElse(String defaultValue) {
        return !this.premiumSince_absent ? this.premiumSince_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MemberData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_JOINED_AT = 2L;
        private static final long INIT_BIT_DEAF = 4L;
        private static final long INIT_BIT_MUTE = 8L;
        private long initBits = 15L;
        private Possible<Optional<String>> nick_possible = Possible.absent();
        private Possible<Optional<String>> premiumSince_possible = Possible.absent();
        private UserData user;
        private List<String> roles = new ArrayList<String>();
        private String joinedAt;
        private String hoistedRole;
        private boolean deaf;
        private boolean mute;

        private Builder() {
        }

        public final Builder from(MemberData instance) {
            Objects.requireNonNull(instance, "instance");
            this.user(instance.user());
            this.nick(instance.nick());
            this.addAllRoles(instance.roles());
            this.joinedAt(instance.joinedAt());
            this.premiumSince(instance.premiumSince());
            Optional<String> hoistedRoleOptional = instance.hoistedRole();
            if (hoistedRoleOptional.isPresent()) {
                this.hoistedRole(hoistedRoleOptional);
            }
            this.deaf(instance.deaf());
            this.mute(instance.mute());
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="nick")
        public Builder nick(Possible<Optional<String>> value) {
            this.nick_possible = value;
            return this;
        }

        public Builder nick(String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder addRole(String element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(String ... elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="roles")
        public final Builder roles(Iterable<String> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<String> elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="joined_at")
        public final Builder joinedAt(String joinedAt) {
            this.joinedAt = Objects.requireNonNull(joinedAt, "joinedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="premium_since")
        public Builder premiumSince(Possible<Optional<String>> value) {
            this.premiumSince_possible = value;
            return this;
        }

        public Builder premiumSince(String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder hoistedRole(String hoistedRole) {
            this.hoistedRole = Objects.requireNonNull(hoistedRole, "hoistedRole");
            return this;
        }

        @JsonProperty(value="hoisted_role")
        public final Builder hoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole.orElse(null);
            return this;
        }

        @JsonProperty(value="deaf")
        public final Builder deaf(boolean deaf) {
            this.deaf = deaf;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="mute")
        public final Builder mute(boolean mute) {
            this.mute = mute;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableMemberData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMemberData(null, this.user, this.nick_build(), ImmutableMemberData.createUnmodifiableList(true, this.roles), this.joinedAt, this.premiumSince_build(), this.hoistedRole, this.deaf, this.mute);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("joinedAt");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("deaf");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("mute");
            }
            return "Cannot build MemberData, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> nick_build() {
            return this.nick_possible;
        }

        private Possible<Optional<String>> premiumSince_build() {
            return this.premiumSince_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MemberData", generator="Immutables")
    static final class Json
    implements MemberData {
        UserData user;
        Possible<Optional<String>> nick;
        List<String> roles = Collections.emptyList();
        String joinedAt;
        Possible<Optional<String>> premiumSince;
        Optional<String> hoistedRole = Optional.empty();
        boolean deaf;
        boolean deafIsSet;
        boolean mute;
        boolean muteIsSet;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="nick")
        public void setNick(Possible<Optional<String>> nick) {
            this.nick = nick;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="joined_at")
        public void setJoinedAt(String joinedAt) {
            this.joinedAt = joinedAt;
        }

        @JsonProperty(value="premium_since")
        public void setPremiumSince(Possible<Optional<String>> premiumSince) {
            this.premiumSince = premiumSince;
        }

        @JsonProperty(value="hoisted_role")
        public void setHoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole;
        }

        @JsonProperty(value="deaf")
        public void setDeaf(boolean deaf) {
            this.deaf = deaf;
            this.deafIsSet = true;
        }

        @JsonProperty(value="mute")
        public void setMute(boolean mute) {
            this.mute = mute;
            this.muteIsSet = true;
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> nick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String joinedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> premiumSince() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> hoistedRole() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deaf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mute() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MemberData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MemberData, attribute initializers form cycle " + attributes;
        }
    }
}

