/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationTeamData;
import discord4j.discordjson.json.ApplicationTeamMemberData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="ApplicationTeamData", generator="Immutables")
public final class ImmutableApplicationTeamData
implements ApplicationTeamData {
    private final String icon;
    private final String id;
    private final List<ApplicationTeamMemberData> members;
    private final String ownerUserId;

    private ImmutableApplicationTeamData(Optional<String> icon, String id, Iterable<? extends ApplicationTeamMemberData> members, String ownerUserId) {
        this.icon = icon.orElse(null);
        this.id = Objects.requireNonNull(id, "id");
        this.members = ImmutableApplicationTeamData.createUnmodifiableList(false, ImmutableApplicationTeamData.createSafeList(members, true, false));
        this.ownerUserId = Objects.requireNonNull(ownerUserId, "ownerUserId");
    }

    private ImmutableApplicationTeamData(ImmutableApplicationTeamData original, String icon, String id, List<ApplicationTeamMemberData> members, String ownerUserId) {
        this.icon = icon;
        this.id = id;
        this.members = members;
        this.ownerUserId = ownerUserId;
    }

    @Override
    @JsonProperty(value="icon")
    public Optional<String> icon() {
        return Optional.ofNullable(this.icon);
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="members")
    public List<ApplicationTeamMemberData> members() {
        return this.members;
    }

    @Override
    @JsonProperty(value="owner_user_id")
    public String ownerUserId() {
        return this.ownerUserId;
    }

    public final ImmutableApplicationTeamData withIcon(String value) {
        String newValue = Objects.requireNonNull(value, "icon");
        if (Objects.equals(this.icon, newValue)) {
            return this;
        }
        return new ImmutableApplicationTeamData(this, newValue, this.id, this.members, this.ownerUserId);
    }

    public final ImmutableApplicationTeamData withIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableApplicationTeamData(this, value, this.id, this.members, this.ownerUserId);
    }

    public final ImmutableApplicationTeamData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationTeamData(this, this.icon, newValue, this.members, this.ownerUserId);
    }

    public final ImmutableApplicationTeamData withMembers(ApplicationTeamMemberData ... elements) {
        List<ApplicationTeamMemberData> newValue = ImmutableApplicationTeamData.createUnmodifiableList(false, ImmutableApplicationTeamData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableApplicationTeamData(this, this.icon, this.id, newValue, this.ownerUserId);
    }

    public final ImmutableApplicationTeamData withMembers(Iterable<? extends ApplicationTeamMemberData> elements) {
        if (this.members == elements) {
            return this;
        }
        List<ApplicationTeamMemberData> newValue = ImmutableApplicationTeamData.createUnmodifiableList(false, ImmutableApplicationTeamData.createSafeList(elements, true, false));
        return new ImmutableApplicationTeamData(this, this.icon, this.id, newValue, this.ownerUserId);
    }

    public final ImmutableApplicationTeamData withOwnerUserId(String value) {
        String newValue = Objects.requireNonNull(value, "ownerUserId");
        if (this.ownerUserId.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationTeamData(this, this.icon, this.id, this.members, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationTeamData && this.equalTo((ImmutableApplicationTeamData)another);
    }

    private boolean equalTo(ImmutableApplicationTeamData another) {
        return Objects.equals(this.icon, another.icon) && this.id.equals(another.id) && this.members.equals(another.members) && this.ownerUserId.equals(another.ownerUserId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.members.hashCode();
        h += (h << 5) + this.ownerUserId.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ApplicationTeamData{");
        if (this.icon != null) {
            builder.append("icon=").append(this.icon);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("members=").append(this.members);
        builder.append(", ");
        builder.append("ownerUserId=").append(this.ownerUserId);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationTeamData fromJson(Json json) {
        Builder builder = ImmutableApplicationTeamData.builder();
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.ownerUserId != null) {
            builder.ownerUserId(json.ownerUserId);
        }
        return builder.build();
    }

    public static ImmutableApplicationTeamData of(Optional<String> icon, String id, List<ApplicationTeamMemberData> members, String ownerUserId) {
        return ImmutableApplicationTeamData.of(icon, id, members, ownerUserId);
    }

    public static ImmutableApplicationTeamData of(Optional<String> icon, String id, Iterable<? extends ApplicationTeamMemberData> members, String ownerUserId) {
        return new ImmutableApplicationTeamData(icon, id, members, ownerUserId);
    }

    public static ImmutableApplicationTeamData copyOf(ApplicationTeamData instance) {
        if (instance instanceof ImmutableApplicationTeamData) {
            return (ImmutableApplicationTeamData)instance;
        }
        return ImmutableApplicationTeamData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ApplicationTeamData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_OWNER_USER_ID = 2L;
        private long initBits = 3L;
        private String icon;
        private String id;
        private List<ApplicationTeamMemberData> members = new ArrayList<ApplicationTeamMemberData>();
        private String ownerUserId;

        private Builder() {
        }

        public final Builder from(ApplicationTeamData instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> iconOptional = instance.icon();
            if (iconOptional.isPresent()) {
                this.icon(iconOptional);
            }
            this.id(instance.id());
            this.addAllMembers(instance.members());
            this.ownerUserId(instance.ownerUserId());
            return this;
        }

        public final Builder icon(String icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(Optional<String> icon) {
            this.icon = icon.orElse(null);
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addMember(ApplicationTeamMemberData element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(ApplicationTeamMemberData ... elements) {
            for (ApplicationTeamMemberData element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends ApplicationTeamMemberData> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends ApplicationTeamMemberData> elements) {
            for (ApplicationTeamMemberData applicationTeamMemberData : elements) {
                this.members.add(Objects.requireNonNull(applicationTeamMemberData, "members element"));
            }
            return this;
        }

        @JsonProperty(value="owner_user_id")
        public final Builder ownerUserId(String ownerUserId) {
            this.ownerUserId = Objects.requireNonNull(ownerUserId, "ownerUserId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableApplicationTeamData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationTeamData(null, this.icon, this.id, ImmutableApplicationTeamData.createUnmodifiableList(true, this.members), this.ownerUserId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ownerUserId");
            }
            return "Cannot build ApplicationTeamData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ApplicationTeamData", generator="Immutables")
    static final class Json
    implements ApplicationTeamData {
        Optional<String> icon = Optional.empty();
        String id;
        List<ApplicationTeamMemberData> members = Collections.emptyList();
        String ownerUserId;

        Json() {
        }

        @JsonProperty(value="icon")
        public void setIcon(Optional<String> icon) {
            this.icon = icon;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="members")
        public void setMembers(List<ApplicationTeamMemberData> members) {
            this.members = members;
        }

        @JsonProperty(value="owner_user_id")
        public void setOwnerUserId(String ownerUserId) {
            this.ownerUserId = ownerUserId;
        }

        @Override
        public Optional<String> icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ApplicationTeamMemberData> members() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String ownerUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

