/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationInfoData;
import discord4j.discordjson.json.ApplicationTeamData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="ApplicationInfoData", generator="Immutables")
public final class ImmutableApplicationInfoData
implements ApplicationInfoData {
    private final String id;
    private final String name;
    private final String icon;
    private final String description;
    private final List<String> rpcOrigins_value;
    private final boolean rpcOrigins_absent;
    private final boolean botPublic;
    private final boolean botRequireCodeGrant;
    private final UserData owner;
    private final String summary;
    private final String verifyKey;
    private final ApplicationTeamData team;
    private final String guildId_value;
    private final boolean guildId_absent;
    private final String primarySkuId_value;
    private final boolean primarySkuId_absent;
    private final String slug_value;
    private final boolean slug_absent;
    private final String coverImage_value;
    private final boolean coverImage_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableApplicationInfoData(String id, String name, Optional<String> icon, String description, Possible<List<String>> rpcOrigins, boolean botPublic, boolean botRequireCodeGrant, UserData owner, String summary, String verifyKey, Optional<? extends ApplicationTeamData> team, Possible<String> guildId, Possible<String> primarySkuId, Possible<String> slug, Possible<String> coverImage) {
        this.id = Objects.requireNonNull(id, "id");
        this.name = Objects.requireNonNull(name, "name");
        this.icon = icon.orElse(null);
        this.description = Objects.requireNonNull(description, "description");
        Possible<List<String>> rpcOrigins$impl = rpcOrigins;
        this.botPublic = botPublic;
        this.botRequireCodeGrant = botRequireCodeGrant;
        this.owner = Objects.requireNonNull(owner, "owner");
        this.summary = Objects.requireNonNull(summary, "summary");
        this.verifyKey = Objects.requireNonNull(verifyKey, "verifyKey");
        this.team = team.orElse(null);
        Possible<String> guildId$impl = guildId;
        Possible<String> primarySkuId$impl = primarySkuId;
        Possible<String> slug$impl = slug;
        Possible<String> coverImage$impl = coverImage;
        this.rpcOrigins_value = rpcOrigins$impl.toOptional().orElse(null);
        this.rpcOrigins_absent = rpcOrigins$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.primarySkuId_value = primarySkuId$impl.toOptional().orElse(null);
        this.primarySkuId_absent = primarySkuId$impl.isAbsent();
        this.slug_value = slug$impl.toOptional().orElse(null);
        this.slug_absent = slug$impl.isAbsent();
        this.coverImage_value = coverImage$impl.toOptional().orElse(null);
        this.coverImage_absent = coverImage$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableApplicationInfoData(ImmutableApplicationInfoData original, String id, String name, String icon, String description, Possible<List<String>> rpcOrigins, boolean botPublic, boolean botRequireCodeGrant, UserData owner, String summary, String verifyKey, ApplicationTeamData team, Possible<String> guildId, Possible<String> primarySkuId, Possible<String> slug, Possible<String> coverImage) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.description = description;
        Possible<List<String>> rpcOrigins$impl = rpcOrigins;
        this.botPublic = botPublic;
        this.botRequireCodeGrant = botRequireCodeGrant;
        this.owner = owner;
        this.summary = summary;
        this.verifyKey = verifyKey;
        this.team = team;
        Possible<String> guildId$impl = guildId;
        Possible<String> primarySkuId$impl = primarySkuId;
        Possible<String> slug$impl = slug;
        Possible<String> coverImage$impl = coverImage;
        this.rpcOrigins_value = rpcOrigins$impl.toOptional().orElse(null);
        this.rpcOrigins_absent = rpcOrigins$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.primarySkuId_value = primarySkuId$impl.toOptional().orElse(null);
        this.primarySkuId_absent = primarySkuId$impl.isAbsent();
        this.slug_value = slug$impl.toOptional().orElse(null);
        this.slug_absent = slug$impl.isAbsent();
        this.coverImage_value = coverImage$impl.toOptional().orElse(null);
        this.coverImage_absent = coverImage$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="icon")
    public Optional<String> icon() {
        return Optional.ofNullable(this.icon);
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="rpc_origins")
    public Possible<List<String>> rpcOrigins() {
        return this.rpcOrigins_absent ? Possible.absent() : Possible.of(this.rpcOrigins_value);
    }

    @Override
    @JsonProperty(value="bot_public")
    public boolean botPublic() {
        return this.botPublic;
    }

    @Override
    @JsonProperty(value="bot_require_code_grant")
    public boolean botRequireCodeGrant() {
        return this.botRequireCodeGrant;
    }

    @Override
    @JsonProperty(value="owner")
    public UserData owner() {
        return this.owner;
    }

    @Override
    @JsonProperty(value="summary")
    public String summary() {
        return this.summary;
    }

    @Override
    @JsonProperty(value="verify_key")
    public String verifyKey() {
        return this.verifyKey;
    }

    @Override
    @JsonProperty(value="team")
    public Optional<ApplicationTeamData> team() {
        return Optional.ofNullable(this.team);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<String> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)this.guildId_value);
    }

    @Override
    @JsonProperty(value="primary_sku_id")
    public Possible<String> primarySkuId() {
        return this.primarySkuId_absent ? Possible.absent() : Possible.of((Object)this.primarySkuId_value);
    }

    @Override
    @JsonProperty(value="slug")
    public Possible<String> slug() {
        return this.slug_absent ? Possible.absent() : Possible.of((Object)this.slug_value);
    }

    @Override
    @JsonProperty(value="cover_image")
    public Possible<String> coverImage() {
        return this.coverImage_absent ? Possible.absent() : Possible.of((Object)this.coverImage_value);
    }

    public final ImmutableApplicationInfoData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, newValue, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, newValue, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withIcon(String value) {
        String newValue = Objects.requireNonNull(value, "icon");
        if (Objects.equals(this.icon, newValue)) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, newValue, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, value, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, newValue, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public ImmutableApplicationInfoData withRpcOrigins(Possible<List<String>> value) {
        Possible<List<String>> newValue = value;
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, newValue, this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withBotPublic(boolean value) {
        if (this.botPublic == value) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), value, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withBotRequireCodeGrant(boolean value) {
        if (this.botRequireCodeGrant == value) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, value, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withOwner(UserData value) {
        if (this.owner == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "owner");
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, newValue, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withSummary(String value) {
        String newValue = Objects.requireNonNull(value, "summary");
        if (this.summary.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, newValue, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withVerifyKey(String value) {
        String newValue = Objects.requireNonNull(value, "verifyKey");
        if (this.verifyKey.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, newValue, this.team, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withTeam(ApplicationTeamData value) {
        ApplicationTeamData newValue = Objects.requireNonNull(value, "team");
        if (this.team == newValue) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, newValue, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public final ImmutableApplicationInfoData withTeam(Optional<? extends ApplicationTeamData> optional) {
        ApplicationTeamData value = optional.orElse(null);
        if (this.team == value) {
            return this;
        }
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, value, this.guildId(), this.primarySkuId(), this.slug(), this.coverImage());
    }

    public ImmutableApplicationInfoData withGuildId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, newValue, this.primarySkuId(), this.slug(), this.coverImage());
    }

    public ImmutableApplicationInfoData withGuildId(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, (Possible<String>)newValue, this.primarySkuId(), this.slug(), this.coverImage());
    }

    public ImmutableApplicationInfoData withPrimarySkuId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), newValue, this.slug(), this.coverImage());
    }

    public ImmutableApplicationInfoData withPrimarySkuId(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), (Possible<String>)newValue, this.slug(), this.coverImage());
    }

    public ImmutableApplicationInfoData withSlug(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), newValue, this.coverImage());
    }

    public ImmutableApplicationInfoData withSlug(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), (Possible<String>)newValue, this.coverImage());
    }

    public ImmutableApplicationInfoData withCoverImage(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), newValue);
    }

    public ImmutableApplicationInfoData withCoverImage(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableApplicationInfoData(this, this.id, this.name, this.icon, this.description, this.rpcOrigins(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId(), this.primarySkuId(), this.slug(), (Possible<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationInfoData && this.equalTo((ImmutableApplicationInfoData)another);
    }

    private boolean equalTo(ImmutableApplicationInfoData another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.icon, another.icon) && this.description.equals(another.description) && Objects.equals(this.rpcOrigins_value, another.rpcOrigins_value) && this.botPublic == another.botPublic && this.botRequireCodeGrant == another.botRequireCodeGrant && this.owner.equals(another.owner) && this.summary.equals(another.summary) && this.verifyKey.equals(another.verifyKey) && Objects.equals(this.team, another.team) && this.guildId().equals(another.guildId()) && this.primarySkuId().equals(another.primarySkuId()) && this.slug().equals(another.slug()) && this.coverImage().equals(another.coverImage());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Objects.hashCode(this.rpcOrigins_value);
        h += (h << 5) + Boolean.hashCode(this.botPublic);
        h += (h << 5) + Boolean.hashCode(this.botRequireCodeGrant);
        h += (h << 5) + this.owner.hashCode();
        h += (h << 5) + this.summary.hashCode();
        h += (h << 5) + this.verifyKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.team);
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.primarySkuId().hashCode();
        h += (h << 5) + this.slug().hashCode();
        h += (h << 5) + this.coverImage().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ApplicationInfoData{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.icon != null) {
            builder.append(", ");
            builder.append("icon=").append(this.icon);
        }
        builder.append(", ");
        builder.append("description=").append(this.description);
        builder.append(", ");
        builder.append("rpcOrigins=").append(Objects.toString(this.rpcOrigins_value));
        builder.append(", ");
        builder.append("botPublic=").append(this.botPublic);
        builder.append(", ");
        builder.append("botRequireCodeGrant=").append(this.botRequireCodeGrant);
        builder.append(", ");
        builder.append("owner=").append(this.owner);
        builder.append(", ");
        builder.append("summary=").append(this.summary);
        builder.append(", ");
        builder.append("verifyKey=").append(this.verifyKey);
        if (this.team != null) {
            builder.append(", ");
            builder.append("team=").append(this.team);
        }
        builder.append(", ");
        builder.append("guildId=").append(this.guildId().toString());
        builder.append(", ");
        builder.append("primarySkuId=").append(this.primarySkuId().toString());
        builder.append(", ");
        builder.append("slug=").append(this.slug().toString());
        builder.append(", ");
        builder.append("coverImage=").append(this.coverImage().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationInfoData fromJson(Json json) {
        Builder builder = ImmutableApplicationInfoData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.rpcOrigins != null) {
            builder.rpcOrigins(json.rpcOrigins);
        }
        if (json.botPublicIsSet) {
            builder.botPublic(json.botPublic);
        }
        if (json.botRequireCodeGrantIsSet) {
            builder.botRequireCodeGrant(json.botRequireCodeGrant);
        }
        if (json.owner != null) {
            builder.owner(json.owner);
        }
        if (json.summary != null) {
            builder.summary(json.summary);
        }
        if (json.verifyKey != null) {
            builder.verifyKey(json.verifyKey);
        }
        if (json.team != null) {
            builder.team(json.team);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.primarySkuId != null) {
            builder.primarySkuId(json.primarySkuId);
        }
        if (json.slug != null) {
            builder.slug(json.slug);
        }
        if (json.coverImage != null) {
            builder.coverImage(json.coverImage);
        }
        return builder.build();
    }

    public static ImmutableApplicationInfoData of(String id, String name, Optional<String> icon, String description, Possible<List<String>> rpcOrigins, boolean botPublic, boolean botRequireCodeGrant, UserData owner, String summary, String verifyKey, Optional<? extends ApplicationTeamData> team, Possible<String> guildId, Possible<String> primarySkuId, Possible<String> slug, Possible<String> coverImage) {
        return new ImmutableApplicationInfoData(id, name, icon, description, rpcOrigins, botPublic, botRequireCodeGrant, owner, summary, verifyKey, team, guildId, primarySkuId, slug, coverImage);
    }

    public static ImmutableApplicationInfoData copyOf(ApplicationInfoData instance) {
        if (instance instanceof ImmutableApplicationInfoData) {
            return (ImmutableApplicationInfoData)instance;
        }
        return ImmutableApplicationInfoData.builder().from(instance).build();
    }

    public boolean isRpcOriginsPresent() {
        return !this.rpcOrigins_absent;
    }

    public List<String> rpcOriginsOrElse(List<String> defaultValue) {
        return !this.rpcOrigins_absent ? this.rpcOrigins_value : defaultValue;
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public String guildIdOrElse(String defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isPrimarySkuIdPresent() {
        return !this.primarySkuId_absent;
    }

    public String primarySkuIdOrElse(String defaultValue) {
        return !this.primarySkuId_absent ? this.primarySkuId_value : defaultValue;
    }

    public boolean isSlugPresent() {
        return !this.slug_absent;
    }

    public String slugOrElse(String defaultValue) {
        return !this.slug_absent ? this.slug_value : defaultValue;
    }

    public boolean isCoverImagePresent() {
        return !this.coverImage_absent;
    }

    public String coverImageOrElse(String defaultValue) {
        return !this.coverImage_absent ? this.coverImage_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ApplicationInfoData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_BOT_PUBLIC = 8L;
        private static final long INIT_BIT_BOT_REQUIRE_CODE_GRANT = 16L;
        private static final long INIT_BIT_OWNER = 32L;
        private static final long INIT_BIT_SUMMARY = 64L;
        private static final long INIT_BIT_VERIFY_KEY = 128L;
        private long initBits = 255L;
        private List<String> rpcOrigins_list = null;
        private Possible<String> guildId_possible = Possible.absent();
        private Possible<String> primarySkuId_possible = Possible.absent();
        private Possible<String> slug_possible = Possible.absent();
        private Possible<String> coverImage_possible = Possible.absent();
        private String id;
        private String name;
        private String icon;
        private String description;
        private boolean botPublic;
        private boolean botRequireCodeGrant;
        private UserData owner;
        private String summary;
        private String verifyKey;
        private ApplicationTeamData team;

        private Builder() {
        }

        public final Builder from(ApplicationInfoData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            Optional<String> iconOptional = instance.icon();
            if (iconOptional.isPresent()) {
                this.icon(iconOptional);
            }
            this.description(instance.description());
            this.rpcOrigins(instance.rpcOrigins());
            this.botPublic(instance.botPublic());
            this.botRequireCodeGrant(instance.botRequireCodeGrant());
            this.owner(instance.owner());
            this.summary(instance.summary());
            this.verifyKey(instance.verifyKey());
            Optional<ApplicationTeamData> teamOptional = instance.team();
            if (teamOptional.isPresent()) {
                this.team(teamOptional);
            }
            this.guildId(instance.guildId());
            this.primarySkuId(instance.primarySkuId());
            this.slug(instance.slug());
            this.coverImage(instance.coverImage());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder icon(String icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(Optional<String> icon) {
            this.icon = icon.orElse(null);
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder addRpcOrigin(String element) {
            this.rpcOrigins_getOrCreate().add(element);
            return this;
        }

        public Builder addAllRpcOrigins(List<String> elements) {
            this.rpcOrigins_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="rpc_origins")
        public Builder rpcOrigins(Possible<List<String>> elements) {
            this.rpcOrigins_list = null;
            elements.toOptional().ifPresent(e -> this.rpcOrigins_getOrCreate().addAll((Collection<String>)e));
            return this;
        }

        public Builder rpcOrigins(List<String> elements) {
            this.rpcOrigins_list = new ArrayList<String>(elements);
            return this;
        }

        @JsonProperty(value="bot_public")
        public final Builder botPublic(boolean botPublic) {
            this.botPublic = botPublic;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="bot_require_code_grant")
        public final Builder botRequireCodeGrant(boolean botRequireCodeGrant) {
            this.botRequireCodeGrant = botRequireCodeGrant;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="owner")
        public final Builder owner(UserData owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="summary")
        public final Builder summary(String summary) {
            this.summary = Objects.requireNonNull(summary, "summary");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="verify_key")
        public final Builder verifyKey(String verifyKey) {
            this.verifyKey = Objects.requireNonNull(verifyKey, "verifyKey");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder team(ApplicationTeamData team) {
            this.team = Objects.requireNonNull(team, "team");
            return this;
        }

        @JsonProperty(value="team")
        public final Builder team(Optional<? extends ApplicationTeamData> team) {
            this.team = team.orElse(null);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<String> value) {
            this.guildId_possible = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="primary_sku_id")
        public Builder primarySkuId(Possible<String> value) {
            this.primarySkuId_possible = value;
            return this;
        }

        public Builder primarySkuId(String value) {
            this.primarySkuId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="slug")
        public Builder slug(Possible<String> value) {
            this.slug_possible = value;
            return this;
        }

        public Builder slug(String value) {
            this.slug_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="cover_image")
        public Builder coverImage(Possible<String> value) {
            this.coverImage_possible = value;
            return this;
        }

        public Builder coverImage(String value) {
            this.coverImage_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableApplicationInfoData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationInfoData(null, this.id, this.name, this.icon, this.description, this.rpcOrigins_build(), this.botPublic, this.botRequireCodeGrant, this.owner, this.summary, this.verifyKey, this.team, this.guildId_build(), this.primarySkuId_build(), this.slug_build(), this.coverImage_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("botPublic");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("botRequireCodeGrant");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("owner");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("summary");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("verifyKey");
            }
            return "Cannot build ApplicationInfoData, some of required attributes are not set " + attributes;
        }

        private Possible<List<String>> rpcOrigins_build() {
            return this.rpcOrigins_list == null ? Possible.absent() : Possible.of(this.rpcOrigins_list);
        }

        private List<String> rpcOrigins_getOrCreate() {
            if (this.rpcOrigins_list == null) {
                this.rpcOrigins_list = new ArrayList<String>();
            }
            return this.rpcOrigins_list;
        }

        private Possible<String> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<String> primarySkuId_build() {
            return this.primarySkuId_possible;
        }

        private Possible<String> slug_build() {
            return this.slug_possible;
        }

        private Possible<String> coverImage_build() {
            return this.coverImage_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ApplicationInfoData", generator="Immutables")
    static final class Json
    implements ApplicationInfoData {
        String id;
        String name;
        Optional<String> icon = Optional.empty();
        String description;
        Possible<List<String>> rpcOrigins;
        boolean botPublic;
        boolean botPublicIsSet;
        boolean botRequireCodeGrant;
        boolean botRequireCodeGrantIsSet;
        UserData owner;
        String summary;
        String verifyKey;
        Optional<ApplicationTeamData> team = Optional.empty();
        Possible<String> guildId;
        Possible<String> primarySkuId;
        Possible<String> slug;
        Possible<String> coverImage;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="icon")
        public void setIcon(Optional<String> icon) {
            this.icon = icon;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="rpc_origins")
        public void setRpcOrigins(Possible<List<String>> rpcOrigins) {
            this.rpcOrigins = rpcOrigins;
        }

        @JsonProperty(value="bot_public")
        public void setBotPublic(boolean botPublic) {
            this.botPublic = botPublic;
            this.botPublicIsSet = true;
        }

        @JsonProperty(value="bot_require_code_grant")
        public void setBotRequireCodeGrant(boolean botRequireCodeGrant) {
            this.botRequireCodeGrant = botRequireCodeGrant;
            this.botRequireCodeGrantIsSet = true;
        }

        @JsonProperty(value="owner")
        public void setOwner(UserData owner) {
            this.owner = owner;
        }

        @JsonProperty(value="summary")
        public void setSummary(String summary) {
            this.summary = summary;
        }

        @JsonProperty(value="verify_key")
        public void setVerifyKey(String verifyKey) {
            this.verifyKey = verifyKey;
        }

        @JsonProperty(value="team")
        public void setTeam(Optional<ApplicationTeamData> team) {
            this.team = team;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<String> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="primary_sku_id")
        public void setPrimarySkuId(Possible<String> primarySkuId) {
            this.primarySkuId = primarySkuId;
        }

        @JsonProperty(value="slug")
        public void setSlug(Possible<String> slug) {
            this.slug = slug;
        }

        @JsonProperty(value="cover_image")
        public void setCoverImage(Possible<String> coverImage) {
            this.coverImage = coverImage;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<String>> rpcOrigins() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean botPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean botRequireCodeGrant() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData owner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String summary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String verifyKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ApplicationTeamData> team() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> primarySkuId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> slug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> coverImage() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ApplicationInfoData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ApplicationInfoData, attribute initializers form cycle " + attributes;
        }
    }
}

