/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="GuildMemberUpdate", generator="Immutables")
public final class ImmutableGuildMemberUpdate
implements GuildMemberUpdate {
    private final String guildId;
    private final List<String> roles;
    private final UserData user;
    private final String nick_value;
    private final boolean nick_absent;
    private final String premiumSince_value;
    private final boolean premiumSince_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildMemberUpdate(String guildId, Iterable<String> roles, UserData user, Possible<Optional<String>> nick, Possible<Optional<String>> premiumSince) {
        this.guildId = Objects.requireNonNull(guildId, "guildId");
        this.roles = ImmutableGuildMemberUpdate.createUnmodifiableList(false, ImmutableGuildMemberUpdate.createSafeList(roles, true, false));
        this.user = Objects.requireNonNull(user, "user");
        Possible<Optional<String>> nick$impl = nick;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableGuildMemberUpdate(ImmutableGuildMemberUpdate original, String guildId, List<String> roles, UserData user, Possible<Optional<String>> nick, Possible<Optional<String>> premiumSince) {
        this.guildId = guildId;
        this.roles = roles;
        this.user = user;
        Possible<Optional<String>> nick$impl = nick;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public String guildId() {
        return this.guildId;
    }

    @Override
    @JsonProperty(value="roles")
    public List<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="nick")
    public Possible<Optional<String>> nick() {
        return this.nick_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nick_value));
    }

    @Override
    @JsonProperty(value="premium_since")
    public Possible<Optional<String>> premiumSince() {
        return this.premiumSince_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.premiumSince_value));
    }

    public final ImmutableGuildMemberUpdate withGuildId(String value) {
        String newValue = Objects.requireNonNull(value, "guildId");
        if (this.guildId.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildMemberUpdate(this, newValue, this.roles, this.user, this.nick(), this.premiumSince());
    }

    public final ImmutableGuildMemberUpdate withRoles(String ... elements) {
        List<String> newValue = ImmutableGuildMemberUpdate.createUnmodifiableList(false, ImmutableGuildMemberUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildMemberUpdate(this, this.guildId, newValue, this.user, this.nick(), this.premiumSince());
    }

    public final ImmutableGuildMemberUpdate withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<String> newValue = ImmutableGuildMemberUpdate.createUnmodifiableList(false, ImmutableGuildMemberUpdate.createSafeList(elements, true, false));
        return new ImmutableGuildMemberUpdate(this, this.guildId, newValue, this.user, this.nick(), this.premiumSince());
    }

    public final ImmutableGuildMemberUpdate withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableGuildMemberUpdate(this, this.guildId, this.roles, newValue, this.nick(), this.premiumSince());
    }

    public ImmutableGuildMemberUpdate withNick(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMemberUpdate(this, this.guildId, this.roles, this.user, newValue, this.premiumSince());
    }

    public ImmutableGuildMemberUpdate withNick(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId, this.roles, this.user, (Possible<Optional<String>>)newValue, this.premiumSince());
    }

    public ImmutableGuildMemberUpdate withPremiumSince(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMemberUpdate(this, this.guildId, this.roles, this.user, this.nick(), newValue);
    }

    public ImmutableGuildMemberUpdate withPremiumSince(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableGuildMemberUpdate(this, this.guildId, this.roles, this.user, this.nick(), (Possible<Optional<String>>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildMemberUpdate && this.equalTo((ImmutableGuildMemberUpdate)another);
    }

    private boolean equalTo(ImmutableGuildMemberUpdate another) {
        return this.guildId.equals(another.guildId) && this.roles.equals(another.roles) && this.user.equals(another.user) && this.nick().equals(another.nick()) && this.premiumSince().equals(another.premiumSince());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.guildId.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.nick().hashCode();
        h += (h << 5) + this.premiumSince().hashCode();
        return h;
    }

    public String toString() {
        return "GuildMemberUpdate{guildId=" + this.guildId + ", roles=" + this.roles + ", user=" + this.user + ", nick=" + this.nick().toString() + ", premiumSince=" + this.premiumSince().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildMemberUpdate fromJson(Json json) {
        Builder builder = ImmutableGuildMemberUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        if (json.premiumSince != null) {
            builder.premiumSince(json.premiumSince);
        }
        return builder.build();
    }

    public static ImmutableGuildMemberUpdate of(String guildId, List<String> roles, UserData user, Possible<Optional<String>> nick, Possible<Optional<String>> premiumSince) {
        return ImmutableGuildMemberUpdate.of(guildId, roles, user, nick, premiumSince);
    }

    public static ImmutableGuildMemberUpdate of(String guildId, Iterable<String> roles, UserData user, Possible<Optional<String>> nick, Possible<Optional<String>> premiumSince) {
        return new ImmutableGuildMemberUpdate(guildId, roles, user, nick, premiumSince);
    }

    public static ImmutableGuildMemberUpdate copyOf(GuildMemberUpdate instance) {
        if (instance instanceof ImmutableGuildMemberUpdate) {
            return (ImmutableGuildMemberUpdate)instance;
        }
        return ImmutableGuildMemberUpdate.builder().from(instance).build();
    }

    public boolean isNickPresent() {
        return !this.nick_absent;
    }

    public String nickOrElse(String defaultValue) {
        return !this.nick_absent ? this.nick_value : defaultValue;
    }

    public boolean isPremiumSincePresent() {
        return !this.premiumSince_absent;
    }

    public String premiumSinceOrElse(String defaultValue) {
        return !this.premiumSince_absent ? this.premiumSince_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildMemberUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_GUILD_ID = 1L;
        private static final long INIT_BIT_USER = 2L;
        private long initBits = 3L;
        private Possible<Optional<String>> nick_possible = Possible.absent();
        private Possible<Optional<String>> premiumSince_possible = Possible.absent();
        private String guildId;
        private List<String> roles = new ArrayList<String>();
        private UserData user;

        private Builder() {
        }

        public final Builder from(GuildMemberUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.addAllRoles(instance.roles());
            this.user(instance.user());
            this.nick(instance.nick());
            this.premiumSince(instance.premiumSince());
            return this;
        }

        @JsonProperty(value="guild_id")
        public final Builder guildId(String guildId) {
            this.guildId = Objects.requireNonNull(guildId, "guildId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addRole(String element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(String ... elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="roles")
        public final Builder roles(Iterable<String> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<String> elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="nick")
        public Builder nick(Possible<Optional<String>> value) {
            this.nick_possible = value;
            return this;
        }

        public Builder nick(String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="premium_since")
        public Builder premiumSince(Possible<Optional<String>> value) {
            this.premiumSince_possible = value;
            return this;
        }

        public Builder premiumSince(String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutableGuildMemberUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildMemberUpdate(null, this.guildId, ImmutableGuildMemberUpdate.createUnmodifiableList(true, this.roles), this.user, this.nick_build(), this.premiumSince_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("guildId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build GuildMemberUpdate, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> nick_build() {
            return this.nick_possible;
        }

        private Possible<Optional<String>> premiumSince_build() {
            return this.premiumSince_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GuildMemberUpdate", generator="Immutables")
    static final class Json
    implements GuildMemberUpdate {
        String guildId;
        List<String> roles = Collections.emptyList();
        UserData user;
        Possible<Optional<String>> nick;
        Possible<Optional<String>> premiumSince;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(String guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="nick")
        public void setNick(Possible<Optional<String>> nick) {
            this.nick = nick;
        }

        @JsonProperty(value="premium_since")
        public void setPremiumSince(Possible<Optional<String>> premiumSince) {
            this.premiumSince = premiumSince;
        }

        @Override
        public String guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> nick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> premiumSince() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="GuildMemberUpdate", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildMemberUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

