/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.WebhookCreateRequest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="WebhookCreateRequest", generator="Immutables")
public final class ImmutableWebhookCreateRequest
implements WebhookCreateRequest {
    private final String name;
    private final String avatar;

    private ImmutableWebhookCreateRequest(String name, Optional<String> avatar) {
        this.name = Objects.requireNonNull(name, "name");
        this.avatar = avatar.orElse(null);
    }

    private ImmutableWebhookCreateRequest(ImmutableWebhookCreateRequest original, String name, String avatar) {
        this.name = name;
        this.avatar = avatar;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="avatar")
    public Optional<String> avatar() {
        return Optional.ofNullable(this.avatar);
    }

    public final ImmutableWebhookCreateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableWebhookCreateRequest(this, newValue, this.avatar);
    }

    public final ImmutableWebhookCreateRequest withAvatar(String value) {
        String newValue = Objects.requireNonNull(value, "avatar");
        if (Objects.equals(this.avatar, newValue)) {
            return this;
        }
        return new ImmutableWebhookCreateRequest(this, this.name, newValue);
    }

    public final ImmutableWebhookCreateRequest withAvatar(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.avatar, value)) {
            return this;
        }
        return new ImmutableWebhookCreateRequest(this, this.name, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookCreateRequest && this.equalTo((ImmutableWebhookCreateRequest)another);
    }

    private boolean equalTo(ImmutableWebhookCreateRequest another) {
        return this.name.equals(another.name) && Objects.equals(this.avatar, another.avatar);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.avatar);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WebhookCreateRequest{");
        builder.append("name=").append(this.name);
        if (this.avatar != null) {
            builder.append(", ");
            builder.append("avatar=").append(this.avatar);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookCreateRequest fromJson(Json json) {
        Builder builder = ImmutableWebhookCreateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.avatar != null) {
            builder.avatar(json.avatar);
        }
        return builder.build();
    }

    public static ImmutableWebhookCreateRequest of(String name, Optional<String> avatar) {
        return new ImmutableWebhookCreateRequest(name, avatar);
    }

    public static ImmutableWebhookCreateRequest copyOf(WebhookCreateRequest instance) {
        if (instance instanceof ImmutableWebhookCreateRequest) {
            return (ImmutableWebhookCreateRequest)instance;
        }
        return ImmutableWebhookCreateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookCreateRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String name;
        private String avatar;

        private Builder() {
        }

        public final Builder from(WebhookCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            Optional<String> avatarOptional = instance.avatar();
            if (avatarOptional.isPresent()) {
                this.avatar(avatarOptional);
            }
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder avatar(String avatar) {
            this.avatar = Objects.requireNonNull(avatar, "avatar");
            return this;
        }

        @JsonProperty(value="avatar")
        public final Builder avatar(Optional<String> avatar) {
            this.avatar = avatar.orElse(null);
            return this;
        }

        public ImmutableWebhookCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookCreateRequest(null, this.name, this.avatar);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build WebhookCreateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WebhookCreateRequest", generator="Immutables")
    static final class Json
    implements WebhookCreateRequest {
        String name;
        Optional<String> avatar = Optional.empty();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="avatar")
        public void setAvatar(Optional<String> avatar) {
            this.avatar = avatar;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> avatar() {
            throw new UnsupportedOperationException();
        }
    }
}

