/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.GuildCreateRequest;
import discord4j.discordjson.json.PartialChannelCreateRequest;
import discord4j.discordjson.json.RoleCreateRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildCreateRequest", generator="Immutables")
public final class ImmutableGuildCreateRequest
implements GuildCreateRequest {
    private final String name;
    private final String region;
    @Nullable
    private final String icon;
    private final int verificationLevel;
    private final int defaultMessageNotifications;
    private final int explicitContentFilter;
    private final List<RoleCreateRequest> roles;
    private final List<PartialChannelCreateRequest> channels;

    private ImmutableGuildCreateRequest(String name, String region, @Nullable String icon, int verificationLevel, int defaultMessageNotifications, int explicitContentFilter, Iterable<? extends RoleCreateRequest> roles, Iterable<? extends PartialChannelCreateRequest> channels) {
        this.name = Objects.requireNonNull(name, "name");
        this.region = Objects.requireNonNull(region, "region");
        this.icon = icon;
        this.verificationLevel = verificationLevel;
        this.defaultMessageNotifications = defaultMessageNotifications;
        this.explicitContentFilter = explicitContentFilter;
        this.roles = ImmutableGuildCreateRequest.createUnmodifiableList(false, ImmutableGuildCreateRequest.createSafeList(roles, true, false));
        this.channels = ImmutableGuildCreateRequest.createUnmodifiableList(false, ImmutableGuildCreateRequest.createSafeList(channels, true, false));
    }

    private ImmutableGuildCreateRequest(ImmutableGuildCreateRequest original, String name, String region, @Nullable String icon, int verificationLevel, int defaultMessageNotifications, int explicitContentFilter, List<RoleCreateRequest> roles, List<PartialChannelCreateRequest> channels) {
        this.name = name;
        this.region = region;
        this.icon = icon;
        this.verificationLevel = verificationLevel;
        this.defaultMessageNotifications = defaultMessageNotifications;
        this.explicitContentFilter = explicitContentFilter;
        this.roles = roles;
        this.channels = channels;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="region")
    public String region() {
        return this.region;
    }

    @Override
    @JsonProperty(value="icon")
    @Nullable
    public String icon() {
        return this.icon;
    }

    @Override
    @JsonProperty(value="verification_level")
    public int verificationLevel() {
        return this.verificationLevel;
    }

    @Override
    @JsonProperty(value="default_message_notifications")
    public int defaultMessageNotifications() {
        return this.defaultMessageNotifications;
    }

    @Override
    @JsonProperty(value="explicit_content_filter")
    public int explicitContentFilter() {
        return this.explicitContentFilter;
    }

    @Override
    @JsonProperty(value="roles")
    public List<RoleCreateRequest> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="channels")
    public List<PartialChannelCreateRequest> channels() {
        return this.channels;
    }

    public final ImmutableGuildCreateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildCreateRequest(this, newValue, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, this.roles, this.channels);
    }

    public final ImmutableGuildCreateRequest withRegion(String value) {
        String newValue = Objects.requireNonNull(value, "region");
        if (this.region.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildCreateRequest(this, this.name, newValue, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, this.roles, this.channels);
    }

    public final ImmutableGuildCreateRequest withIcon(@Nullable String value) {
        if (Objects.equals(this.icon, value)) {
            return this;
        }
        return new ImmutableGuildCreateRequest(this, this.name, this.region, value, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, this.roles, this.channels);
    }

    public final ImmutableGuildCreateRequest withVerificationLevel(int value) {
        if (this.verificationLevel == value) {
            return this;
        }
        return new ImmutableGuildCreateRequest(this, this.name, this.region, this.icon, value, this.defaultMessageNotifications, this.explicitContentFilter, this.roles, this.channels);
    }

    public final ImmutableGuildCreateRequest withDefaultMessageNotifications(int value) {
        if (this.defaultMessageNotifications == value) {
            return this;
        }
        return new ImmutableGuildCreateRequest(this, this.name, this.region, this.icon, this.verificationLevel, value, this.explicitContentFilter, this.roles, this.channels);
    }

    public final ImmutableGuildCreateRequest withExplicitContentFilter(int value) {
        if (this.explicitContentFilter == value) {
            return this;
        }
        return new ImmutableGuildCreateRequest(this, this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, value, this.roles, this.channels);
    }

    public final ImmutableGuildCreateRequest withRoles(RoleCreateRequest ... elements) {
        List<RoleCreateRequest> newValue = ImmutableGuildCreateRequest.createUnmodifiableList(false, ImmutableGuildCreateRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildCreateRequest(this, this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, newValue, this.channels);
    }

    public final ImmutableGuildCreateRequest withRoles(Iterable<? extends RoleCreateRequest> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<RoleCreateRequest> newValue = ImmutableGuildCreateRequest.createUnmodifiableList(false, ImmutableGuildCreateRequest.createSafeList(elements, true, false));
        return new ImmutableGuildCreateRequest(this, this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, newValue, this.channels);
    }

    public final ImmutableGuildCreateRequest withChannels(PartialChannelCreateRequest ... elements) {
        List<PartialChannelCreateRequest> newValue = ImmutableGuildCreateRequest.createUnmodifiableList(false, ImmutableGuildCreateRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildCreateRequest(this, this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, this.roles, newValue);
    }

    public final ImmutableGuildCreateRequest withChannels(Iterable<? extends PartialChannelCreateRequest> elements) {
        if (this.channels == elements) {
            return this;
        }
        List<PartialChannelCreateRequest> newValue = ImmutableGuildCreateRequest.createUnmodifiableList(false, ImmutableGuildCreateRequest.createSafeList(elements, true, false));
        return new ImmutableGuildCreateRequest(this, this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, this.roles, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildCreateRequest && this.equalTo((ImmutableGuildCreateRequest)another);
    }

    private boolean equalTo(ImmutableGuildCreateRequest another) {
        return this.name.equals(another.name) && this.region.equals(another.region) && Objects.equals(this.icon, another.icon) && this.verificationLevel == another.verificationLevel && this.defaultMessageNotifications == another.defaultMessageNotifications && this.explicitContentFilter == another.explicitContentFilter && this.roles.equals(another.roles) && this.channels.equals(another.channels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.region.hashCode();
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + this.verificationLevel;
        h += (h << 5) + this.defaultMessageNotifications;
        h += (h << 5) + this.explicitContentFilter;
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.channels.hashCode();
        return h;
    }

    public String toString() {
        return "GuildCreateRequest{name=" + this.name + ", region=" + this.region + ", icon=" + this.icon + ", verificationLevel=" + this.verificationLevel + ", defaultMessageNotifications=" + this.defaultMessageNotifications + ", explicitContentFilter=" + this.explicitContentFilter + ", roles=" + this.roles + ", channels=" + this.channels + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildCreateRequest fromJson(Json json) {
        Builder builder = ImmutableGuildCreateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.region != null) {
            builder.region(json.region);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.verificationLevelIsSet) {
            builder.verificationLevel(json.verificationLevel);
        }
        if (json.defaultMessageNotificationsIsSet) {
            builder.defaultMessageNotifications(json.defaultMessageNotifications);
        }
        if (json.explicitContentFilterIsSet) {
            builder.explicitContentFilter(json.explicitContentFilter);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.channels != null) {
            builder.addAllChannels(json.channels);
        }
        return builder.build();
    }

    public static ImmutableGuildCreateRequest of(String name, String region, @Nullable String icon, int verificationLevel, int defaultMessageNotifications, int explicitContentFilter, List<RoleCreateRequest> roles, List<PartialChannelCreateRequest> channels) {
        return ImmutableGuildCreateRequest.of(name, region, icon, verificationLevel, defaultMessageNotifications, explicitContentFilter, roles, channels);
    }

    public static ImmutableGuildCreateRequest of(String name, String region, @Nullable String icon, int verificationLevel, int defaultMessageNotifications, int explicitContentFilter, Iterable<? extends RoleCreateRequest> roles, Iterable<? extends PartialChannelCreateRequest> channels) {
        return new ImmutableGuildCreateRequest(name, region, icon, verificationLevel, defaultMessageNotifications, explicitContentFilter, roles, channels);
    }

    public static ImmutableGuildCreateRequest copyOf(GuildCreateRequest instance) {
        if (instance instanceof ImmutableGuildCreateRequest) {
            return (ImmutableGuildCreateRequest)instance;
        }
        return ImmutableGuildCreateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildCreateRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_REGION = 2L;
        private static final long INIT_BIT_VERIFICATION_LEVEL = 4L;
        private static final long INIT_BIT_DEFAULT_MESSAGE_NOTIFICATIONS = 8L;
        private static final long INIT_BIT_EXPLICIT_CONTENT_FILTER = 16L;
        private long initBits = 31L;
        private String name;
        private String region;
        private String icon;
        private int verificationLevel;
        private int defaultMessageNotifications;
        private int explicitContentFilter;
        private List<RoleCreateRequest> roles = new ArrayList<RoleCreateRequest>();
        private List<PartialChannelCreateRequest> channels = new ArrayList<PartialChannelCreateRequest>();

        private Builder() {
        }

        public final Builder from(GuildCreateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.region(instance.region());
            String iconValue = instance.icon();
            if (iconValue != null) {
                this.icon(iconValue);
            }
            this.verificationLevel(instance.verificationLevel());
            this.defaultMessageNotifications(instance.defaultMessageNotifications());
            this.explicitContentFilter(instance.explicitContentFilter());
            this.addAllRoles(instance.roles());
            this.addAllChannels(instance.channels());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="region")
        public final Builder region(String region) {
            this.region = Objects.requireNonNull(region, "region");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="icon")
        public final Builder icon(@Nullable String icon) {
            this.icon = icon;
            return this;
        }

        @JsonProperty(value="verification_level")
        public final Builder verificationLevel(int verificationLevel) {
            this.verificationLevel = verificationLevel;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="default_message_notifications")
        public final Builder defaultMessageNotifications(int defaultMessageNotifications) {
            this.defaultMessageNotifications = defaultMessageNotifications;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="explicit_content_filter")
        public final Builder explicitContentFilter(int explicitContentFilter) {
            this.explicitContentFilter = explicitContentFilter;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addRole(RoleCreateRequest element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(RoleCreateRequest ... elements) {
            for (RoleCreateRequest element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="roles")
        public final Builder roles(Iterable<? extends RoleCreateRequest> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<? extends RoleCreateRequest> elements) {
            for (RoleCreateRequest roleCreateRequest : elements) {
                this.roles.add(Objects.requireNonNull(roleCreateRequest, "roles element"));
            }
            return this;
        }

        public final Builder addChannel(PartialChannelCreateRequest element) {
            this.channels.add(Objects.requireNonNull(element, "channels element"));
            return this;
        }

        public final Builder addChannels(PartialChannelCreateRequest ... elements) {
            for (PartialChannelCreateRequest element : elements) {
                this.channels.add(Objects.requireNonNull(element, "channels element"));
            }
            return this;
        }

        @JsonProperty(value="channels")
        public final Builder channels(Iterable<? extends PartialChannelCreateRequest> elements) {
            this.channels.clear();
            return this.addAllChannels(elements);
        }

        public final Builder addAllChannels(Iterable<? extends PartialChannelCreateRequest> elements) {
            for (PartialChannelCreateRequest partialChannelCreateRequest : elements) {
                this.channels.add(Objects.requireNonNull(partialChannelCreateRequest, "channels element"));
            }
            return this;
        }

        public ImmutableGuildCreateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildCreateRequest(null, this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotifications, this.explicitContentFilter, ImmutableGuildCreateRequest.createUnmodifiableList(true, this.roles), ImmutableGuildCreateRequest.createUnmodifiableList(true, this.channels));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("region");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("verificationLevel");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("defaultMessageNotifications");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("explicitContentFilter");
            }
            return "Cannot build GuildCreateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GuildCreateRequest", generator="Immutables")
    static final class Json
    implements GuildCreateRequest {
        String name;
        String region;
        String icon;
        int verificationLevel;
        boolean verificationLevelIsSet;
        int defaultMessageNotifications;
        boolean defaultMessageNotificationsIsSet;
        int explicitContentFilter;
        boolean explicitContentFilterIsSet;
        List<RoleCreateRequest> roles = Collections.emptyList();
        List<PartialChannelCreateRequest> channels = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="region")
        public void setRegion(String region) {
            this.region = region;
        }

        @JsonProperty(value="icon")
        public void setIcon(@Nullable String icon) {
            this.icon = icon;
        }

        @JsonProperty(value="verification_level")
        public void setVerificationLevel(int verificationLevel) {
            this.verificationLevel = verificationLevel;
            this.verificationLevelIsSet = true;
        }

        @JsonProperty(value="default_message_notifications")
        public void setDefaultMessageNotifications(int defaultMessageNotifications) {
            this.defaultMessageNotifications = defaultMessageNotifications;
            this.defaultMessageNotificationsIsSet = true;
        }

        @JsonProperty(value="explicit_content_filter")
        public void setExplicitContentFilter(int explicitContentFilter) {
            this.explicitContentFilter = explicitContentFilter;
            this.explicitContentFilterIsSet = true;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<RoleCreateRequest> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="channels")
        public void setChannels(List<PartialChannelCreateRequest> channels) {
            this.channels = channels;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String region() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int verificationLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int defaultMessageNotifications() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int explicitContentFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<RoleCreateRequest> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PartialChannelCreateRequest> channels() {
            throw new UnsupportedOperationException();
        }
    }
}

