/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ActivityData;
import discord4j.discordjson.json.ClientStatusData;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="PresenceUpdate", generator="Immutables")
public final class ImmutablePresenceUpdate
implements PresenceUpdate {
    private final PartialUserData user;
    private final List<String> roles;
    private final ActivityData game;
    private final long guildId_value;
    private final String status;
    private final List<ActivityData> activities;
    private final ClientStatusData clientStatus;
    private final String premiumSince_value;
    private final boolean premiumSince_absent;
    private final String nick_value;
    private final boolean nick_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePresenceUpdate(PartialUserData user, Iterable<String> roles, Optional<? extends ActivityData> game, Id guildId, String status, Iterable<? extends ActivityData> activities, ClientStatusData clientStatus, Possible<Optional<String>> premiumSince, Possible<Optional<String>> nick) {
        this.user = Objects.requireNonNull(user, "user");
        this.roles = ImmutablePresenceUpdate.createUnmodifiableList(false, ImmutablePresenceUpdate.createSafeList(roles, true, false));
        this.game = game.orElse(null);
        Id guildId$impl = guildId;
        this.status = Objects.requireNonNull(status, "status");
        this.activities = ImmutablePresenceUpdate.createUnmodifiableList(false, ImmutablePresenceUpdate.createSafeList(activities, true, false));
        this.clientStatus = Objects.requireNonNull(clientStatus, "clientStatus");
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        Possible<Optional<String>> nick$impl = nick;
        this.guildId_value = guildId$impl.asLong();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutablePresenceUpdate(ImmutablePresenceUpdate original, PartialUserData user, List<String> roles, ActivityData game, Id guildId, String status, List<ActivityData> activities, ClientStatusData clientStatus, Possible<Optional<String>> premiumSince, Possible<Optional<String>> nick) {
        this.user = user;
        this.roles = roles;
        this.game = game;
        Id guildId$impl = guildId;
        this.status = status;
        this.activities = activities;
        this.clientStatus = clientStatus;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        Possible<Optional<String>> nick$impl = nick;
        this.guildId_value = guildId$impl.asLong();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user")
    public PartialUserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="roles")
    public List<String> roles() {
        return this.roles;
    }

    @Override
    @JsonProperty(value="game")
    public Optional<ActivityData> game() {
        return Optional.ofNullable(this.game);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="status")
    public String status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="activities")
    public List<ActivityData> activities() {
        return this.activities;
    }

    @Override
    @JsonProperty(value="client_status")
    public ClientStatusData clientStatus() {
        return this.clientStatus;
    }

    @Override
    @JsonProperty(value="premium_since")
    public Possible<Optional<String>> premiumSince() {
        return this.premiumSince_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.premiumSince_value));
    }

    @Override
    @JsonProperty(value="nick")
    public Possible<Optional<String>> nick() {
        return this.nick_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nick_value));
    }

    public final ImmutablePresenceUpdate withUser(PartialUserData value) {
        if (this.user == value) {
            return this;
        }
        PartialUserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutablePresenceUpdate(this, newValue, this.roles, this.game, this.guildId(), this.status, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withRoles(String ... elements) {
        List<String> newValue = ImmutablePresenceUpdate.createUnmodifiableList(false, ImmutablePresenceUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePresenceUpdate(this, this.user, newValue, this.game, this.guildId(), this.status, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<String> newValue = ImmutablePresenceUpdate.createUnmodifiableList(false, ImmutablePresenceUpdate.createSafeList(elements, true, false));
        return new ImmutablePresenceUpdate(this, this.user, newValue, this.game, this.guildId(), this.status, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withGame(ActivityData value) {
        ActivityData newValue = Objects.requireNonNull(value, "game");
        if (this.game == newValue) {
            return this;
        }
        return new ImmutablePresenceUpdate(this, this.user, this.roles, newValue, this.guildId(), this.status, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withGame(Optional<? extends ActivityData> optional) {
        ActivityData value = optional.orElse(null);
        if (this.game == value) {
            return this;
        }
        return new ImmutablePresenceUpdate(this, this.user, this.roles, value, this.guildId(), this.status, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public ImmutablePresenceUpdate withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, newValue, this.status, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public ImmutablePresenceUpdate withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, newValue, this.status, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (this.status.equals(newValue)) {
            return this;
        }
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), newValue, this.activities, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withActivities(ActivityData ... elements) {
        List<ActivityData> newValue = ImmutablePresenceUpdate.createUnmodifiableList(false, ImmutablePresenceUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), this.status, newValue, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withActivities(Iterable<? extends ActivityData> elements) {
        if (this.activities == elements) {
            return this;
        }
        List<ActivityData> newValue = ImmutablePresenceUpdate.createUnmodifiableList(false, ImmutablePresenceUpdate.createSafeList(elements, true, false));
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), this.status, newValue, this.clientStatus, this.premiumSince(), this.nick());
    }

    public final ImmutablePresenceUpdate withClientStatus(ClientStatusData value) {
        if (this.clientStatus == value) {
            return this;
        }
        ClientStatusData newValue = Objects.requireNonNull(value, "clientStatus");
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), this.status, this.activities, newValue, this.premiumSince(), this.nick());
    }

    public ImmutablePresenceUpdate withPremiumSince(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), this.status, this.activities, this.clientStatus, newValue, this.nick());
    }

    public ImmutablePresenceUpdate withPremiumSince(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), this.status, this.activities, this.clientStatus, (Possible<Optional<String>>)newValue, this.nick());
    }

    public ImmutablePresenceUpdate withNick(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), this.status, this.activities, this.clientStatus, this.premiumSince(), newValue);
    }

    public ImmutablePresenceUpdate withNick(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutablePresenceUpdate(this, this.user, this.roles, this.game, this.guildId(), this.status, this.activities, this.clientStatus, this.premiumSince(), (Possible<Optional<String>>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePresenceUpdate && this.equalTo((ImmutablePresenceUpdate)another);
    }

    private boolean equalTo(ImmutablePresenceUpdate another) {
        return this.user.equals(another.user) && this.roles.equals(another.roles) && Objects.equals(this.game, another.game) && Objects.equals(this.guildId_value, another.guildId_value) && this.status.equals(another.status) && this.activities.equals(another.activities) && this.clientStatus.equals(another.clientStatus) && this.premiumSince().equals(another.premiumSince()) && this.nick().equals(another.nick());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + Objects.hashCode(this.game);
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + this.activities.hashCode();
        h += (h << 5) + this.clientStatus.hashCode();
        h += (h << 5) + this.premiumSince().hashCode();
        h += (h << 5) + this.nick().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PresenceUpdate{");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("roles=").append(this.roles);
        if (this.game != null) {
            builder.append(", ");
            builder.append("game=").append(this.game);
        }
        builder.append(", ");
        builder.append("guildId=").append(Objects.toString(this.guildId_value));
        builder.append(", ");
        builder.append("status=").append(this.status);
        builder.append(", ");
        builder.append("activities=").append(this.activities);
        builder.append(", ");
        builder.append("clientStatus=").append(this.clientStatus);
        builder.append(", ");
        builder.append("premiumSince=").append(this.premiumSince().toString());
        builder.append(", ");
        builder.append("nick=").append(this.nick().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePresenceUpdate fromJson(Json json) {
        Builder builder = ImmutablePresenceUpdate.builder();
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.roles != null) {
            builder.addAllRoles(json.roles);
        }
        if (json.game != null) {
            builder.game(json.game);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.activities != null) {
            builder.addAllActivities(json.activities);
        }
        if (json.clientStatus != null) {
            builder.clientStatus(json.clientStatus);
        }
        if (json.premiumSince != null) {
            builder.premiumSince(json.premiumSince);
        }
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        return builder.build();
    }

    public static ImmutablePresenceUpdate of(PartialUserData user, List<String> roles, Optional<ActivityData> game, Id guildId, String status, List<ActivityData> activities, ClientStatusData clientStatus, Possible<Optional<String>> premiumSince, Possible<Optional<String>> nick) {
        return ImmutablePresenceUpdate.of(user, roles, game, guildId, status, activities, clientStatus, premiumSince, nick);
    }

    public static ImmutablePresenceUpdate of(PartialUserData user, Iterable<String> roles, Optional<? extends ActivityData> game, Id guildId, String status, Iterable<? extends ActivityData> activities, ClientStatusData clientStatus, Possible<Optional<String>> premiumSince, Possible<Optional<String>> nick) {
        return new ImmutablePresenceUpdate(user, roles, game, guildId, status, activities, clientStatus, premiumSince, nick);
    }

    public static ImmutablePresenceUpdate copyOf(PresenceUpdate instance) {
        if (instance instanceof ImmutablePresenceUpdate) {
            return (ImmutablePresenceUpdate)instance;
        }
        return ImmutablePresenceUpdate.builder().from(instance).build();
    }

    public boolean isPremiumSincePresent() {
        return !this.premiumSince_absent;
    }

    public String premiumSinceOrElse(String defaultValue) {
        return !this.premiumSince_absent ? this.premiumSince_value : defaultValue;
    }

    public boolean isNickPresent() {
        return !this.nick_absent;
    }

    public String nickOrElse(String defaultValue) {
        return !this.nick_absent ? this.nick_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PresenceUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_STATUS = 2L;
        private static final long INIT_BIT_CLIENT_STATUS = 4L;
        private long initBits = 7L;
        private Id guildId_id = null;
        private Possible<Optional<String>> premiumSince_possible = Possible.absent();
        private Possible<Optional<String>> nick_possible = Possible.absent();
        private PartialUserData user;
        private List<String> roles = new ArrayList<String>();
        private ActivityData game;
        private String status;
        private List<ActivityData> activities = new ArrayList<ActivityData>();
        private ClientStatusData clientStatus;

        private Builder() {
        }

        public final Builder from(PresenceUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.user(instance.user());
            this.addAllRoles(instance.roles());
            Optional<ActivityData> gameOptional = instance.game();
            if (gameOptional.isPresent()) {
                this.game(gameOptional);
            }
            this.guildId(instance.guildId());
            this.status(instance.status());
            this.addAllActivities(instance.activities());
            this.clientStatus(instance.clientStatus());
            this.premiumSince(instance.premiumSince());
            this.nick(instance.nick());
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(PartialUserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addRole(String element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            return this;
        }

        public final Builder addRoles(String ... elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        @JsonProperty(value="roles")
        public final Builder roles(Iterable<String> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<String> elements) {
            for (String element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            return this;
        }

        public final Builder game(ActivityData game) {
            this.game = Objects.requireNonNull(game, "game");
            return this;
        }

        @JsonProperty(value="game")
        public final Builder game(Optional<? extends ActivityData> game) {
            this.game = game.orElse(null);
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addActivity(ActivityData element) {
            this.activities.add(Objects.requireNonNull(element, "activities element"));
            return this;
        }

        public final Builder addActivities(ActivityData ... elements) {
            for (ActivityData element : elements) {
                this.activities.add(Objects.requireNonNull(element, "activities element"));
            }
            return this;
        }

        @JsonProperty(value="activities")
        public final Builder activities(Iterable<? extends ActivityData> elements) {
            this.activities.clear();
            return this.addAllActivities(elements);
        }

        public final Builder addAllActivities(Iterable<? extends ActivityData> elements) {
            for (ActivityData activityData : elements) {
                this.activities.add(Objects.requireNonNull(activityData, "activities element"));
            }
            return this;
        }

        @JsonProperty(value="client_status")
        public final Builder clientStatus(ClientStatusData clientStatus) {
            this.clientStatus = Objects.requireNonNull(clientStatus, "clientStatus");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="premium_since")
        public Builder premiumSince(Possible<Optional<String>> value) {
            this.premiumSince_possible = value;
            return this;
        }

        public Builder premiumSince(String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @JsonProperty(value="nick")
        public Builder nick(Possible<Optional<String>> value) {
            this.nick_possible = value;
            return this;
        }

        public Builder nick(String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public ImmutablePresenceUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePresenceUpdate(null, this.user, ImmutablePresenceUpdate.createUnmodifiableList(true, this.roles), this.game, this.guildId_build(), this.status, ImmutablePresenceUpdate.createUnmodifiableList(true, this.activities), this.clientStatus, this.premiumSince_build(), this.nick_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("status");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("clientStatus");
            }
            return "Cannot build PresenceUpdate, some of required attributes are not set " + attributes;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private Possible<Optional<String>> premiumSince_build() {
            return this.premiumSince_possible;
        }

        private Possible<Optional<String>> nick_build() {
            return this.nick_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PresenceUpdate", generator="Immutables")
    static final class Json
    implements PresenceUpdate {
        PartialUserData user;
        List<String> roles = Collections.emptyList();
        Optional<ActivityData> game = Optional.empty();
        Id guildId;
        String status;
        List<ActivityData> activities = Collections.emptyList();
        ClientStatusData clientStatus;
        Possible<Optional<String>> premiumSince;
        Possible<Optional<String>> nick;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUser(PartialUserData user) {
            this.user = user;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="game")
        public void setGame(Optional<ActivityData> game) {
            this.game = game;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="status")
        public void setStatus(String status) {
            this.status = status;
        }

        @JsonProperty(value="activities")
        public void setActivities(List<ActivityData> activities) {
            this.activities = activities;
        }

        @JsonProperty(value="client_status")
        public void setClientStatus(ClientStatusData clientStatus) {
            this.clientStatus = clientStatus;
        }

        @JsonProperty(value="premium_since")
        public void setPremiumSince(Possible<Optional<String>> premiumSince) {
            this.premiumSince = premiumSince;
        }

        @JsonProperty(value="nick")
        public void setNick(Possible<Optional<String>> nick) {
            this.nick = nick;
        }

        @Override
        public PartialUserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ActivityData> game() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ActivityData> activities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ClientStatusData clientStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> premiumSince() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> nick() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="PresenceUpdate", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build PresenceUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

