/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MessageReactionAdd", generator="Immutables")
public final class ImmutableMessageReactionAdd
implements MessageReactionAdd {
    private final long userId_value;
    private final long channelId_value;
    private final long messageId_value;
    private final long guildId_value;
    private final boolean guildId_absent;
    private final MemberData member_value;
    private final boolean member_absent;
    private final EmojiData emoji;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReactionAdd(Id userId, Id channelId, Id messageId, Possible<Id> guildId, Possible<MemberData> member, EmojiData emoji) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        Possible<MemberData> member$impl = member;
        this.emoji = Objects.requireNonNull(emoji, "emoji");
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageReactionAdd(ImmutableMessageReactionAdd original, Id userId, Id channelId, Id messageId, Possible<Id> guildId, Possible<MemberData> member, EmojiData emoji) {
        Id userId$impl = userId;
        Id channelId$impl = channelId;
        Id messageId$impl = messageId;
        Possible<Id> guildId$impl = guildId;
        Possible<MemberData> member$impl = member;
        this.emoji = emoji;
        this.userId_value = userId$impl.asLong();
        this.channelId_value = channelId$impl.asLong();
        this.messageId_value = messageId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user_id")
    public Id userId() {
        return Id.of((long)this.userId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    @Override
    @JsonProperty(value="message_id")
    public Id messageId() {
        return Id.of((long)this.messageId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    @Override
    @JsonProperty(value="member")
    public Possible<MemberData> member() {
        return this.member_absent ? Possible.absent() : Possible.of((Object)this.member_value);
    }

    @Override
    @JsonProperty(value="emoji")
    public EmojiData emoji() {
        return this.emoji;
    }

    public ImmutableMessageReactionAdd withUserId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionAdd(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withUserId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionAdd(this, newValue, this.channelId(), this.messageId(), this.guildId(), this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionAdd(this, this.userId(), newValue, this.messageId(), this.guildId(), this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionAdd(this, this.userId(), newValue, this.messageId(), this.guildId(), this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withMessageId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageReactionAdd(this, this.userId(), this.channelId(), newValue, this.guildId(), this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withMessageId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageReactionAdd(this, this.userId(), this.channelId(), newValue, this.guildId(), this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReactionAdd(this, this.userId(), this.channelId(), this.messageId(), newValue, this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessageReactionAdd(this, this.userId(), this.channelId(), this.messageId(), (Possible<Id>)newValue, this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withMember(Possible<MemberData> value) {
        Possible<MemberData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReactionAdd(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), newValue, this.emoji);
    }

    public ImmutableMessageReactionAdd withMember(MemberData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageReactionAdd(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), (Possible<MemberData>)newValue, this.emoji);
    }

    public final ImmutableMessageReactionAdd withEmoji(EmojiData value) {
        if (this.emoji == value) {
            return this;
        }
        EmojiData newValue = Objects.requireNonNull(value, "emoji");
        return new ImmutableMessageReactionAdd(this, this.userId(), this.channelId(), this.messageId(), this.guildId(), this.member(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReactionAdd && this.equalTo((ImmutableMessageReactionAdd)another);
    }

    private boolean equalTo(ImmutableMessageReactionAdd another) {
        return Objects.equals(this.userId_value, another.userId_value) && Objects.equals(this.channelId_value, another.channelId_value) && Objects.equals(this.messageId_value, another.messageId_value) && this.guildId().equals(another.guildId()) && this.member().equals(another.member()) && this.emoji.equals(another.emoji);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userId_value);
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        h += (h << 5) + Objects.hashCode(this.messageId_value);
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.member().hashCode();
        h += (h << 5) + this.emoji.hashCode();
        return h;
    }

    public String toString() {
        return "MessageReactionAdd{userId=" + Objects.toString(this.userId_value) + ", channelId=" + Objects.toString(this.channelId_value) + ", messageId=" + Objects.toString(this.messageId_value) + ", guildId=" + this.guildId().toString() + ", member=" + this.member().toString() + ", emoji=" + this.emoji + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageReactionAdd fromJson(Json json) {
        Builder builder = ImmutableMessageReactionAdd.builder();
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.messageId != null) {
            builder.messageId(json.messageId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.member != null) {
            builder.member(json.member);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        return builder.build();
    }

    public static ImmutableMessageReactionAdd of(Id userId, Id channelId, Id messageId, Possible<Id> guildId, Possible<MemberData> member, EmojiData emoji) {
        return new ImmutableMessageReactionAdd(userId, channelId, messageId, guildId, member, emoji);
    }

    public static ImmutableMessageReactionAdd copyOf(MessageReactionAdd instance) {
        if (instance instanceof ImmutableMessageReactionAdd) {
            return (ImmutableMessageReactionAdd)instance;
        }
        return ImmutableMessageReactionAdd.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isMemberPresent() {
        return !this.member_absent;
    }

    public MemberData memberOrElse(MemberData defaultValue) {
        return !this.member_absent ? this.member_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MessageReactionAdd", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EMOJI = 1L;
        private long initBits = 1L;
        private Id userId_id = null;
        private Id channelId_id = null;
        private Id messageId_id = null;
        private Possible<Id> guildId_possible = Possible.absent();
        private Possible<MemberData> member_possible = Possible.absent();
        private EmojiData emoji;

        private Builder() {
        }

        public final Builder from(MessageReactionAdd instance) {
            Objects.requireNonNull(instance, "instance");
            this.userId(instance.userId());
            this.channelId(instance.channelId());
            this.messageId(instance.messageId());
            this.guildId(instance.guildId());
            this.member(instance.member());
            this.emoji(instance.emoji());
            return this;
        }

        public Builder userId(String value) {
            this.userId_id = Id.of((String)value);
            return this;
        }

        public Builder userId(long value) {
            this.userId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder userId(Id value) {
            this.userId_id = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of((String)value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        public Builder messageId(String value) {
            this.messageId_id = Id.of((String)value);
            return this;
        }

        public Builder messageId(long value) {
            this.messageId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="message_id")
        public Builder messageId(Id value) {
            this.messageId_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        @JsonProperty(value="member")
        public Builder member(Possible<MemberData> value) {
            this.member_possible = value;
            return this;
        }

        public Builder member(MemberData value) {
            this.member_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="emoji")
        public final Builder emoji(EmojiData emoji) {
            this.emoji = Objects.requireNonNull(emoji, "emoji");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageReactionAdd build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageReactionAdd(null, this.userId_build(), this.channelId_build(), this.messageId_build(), this.guildId_build(), this.member_build(), this.emoji);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("emoji");
            }
            return "Cannot build MessageReactionAdd, some of required attributes are not set " + attributes;
        }

        private Id userId_build() {
            return this.userId_id;
        }

        private Id channelId_build() {
            return this.channelId_id;
        }

        private Id messageId_build() {
            return this.messageId_id;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<MemberData> member_build() {
            return this.member_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessageReactionAdd", generator="Immutables")
    static final class Json
    implements MessageReactionAdd {
        Id userId;
        Id channelId;
        Id messageId;
        Possible<Id> guildId;
        Possible<MemberData> member;
        EmojiData emoji;

        Json() {
        }

        @JsonProperty(value="user_id")
        public void setUserId(Id userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(Id messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="member")
        public void setMember(Possible<MemberData> member) {
            this.member = member;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(EmojiData emoji) {
            this.emoji = emoji;
        }

        @Override
        public Id userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id messageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<MemberData> member() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmojiData emoji() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MessageReactionAdd", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageReactionAdd, attribute initializers form cycle " + attributes;
        }
    }
}

