/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="MessageDeleteBulk", generator="Immutables")
public final class ImmutableMessageDeleteBulk
implements MessageDeleteBulk {
    private final long[] ids_value;
    private final long channelId_value;
    private final long guildId_value;
    private final boolean guildId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageDeleteBulk(List<Id> ids, Id channelId, Possible<Id> guildId) {
        List<Id> ids$impl = ids;
        Id channelId$impl = channelId;
        Possible<Id> guildId$impl = guildId;
        this.ids_value = ids$impl.stream().mapToLong(Id::asLong).toArray();
        this.channelId_value = channelId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageDeleteBulk(ImmutableMessageDeleteBulk original, List<Id> ids, Id channelId, Possible<Id> guildId) {
        List<Id> ids$impl = ids;
        Id channelId$impl = channelId;
        Possible<Id> guildId$impl = guildId;
        this.ids_value = ids$impl.stream().mapToLong(Id::asLong).toArray();
        this.channelId_value = channelId$impl.asLong();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="ids")
    public List<Id> ids() {
        return LongStream.of(this.ids_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="channel_id")
    public Id channelId() {
        return Id.of((long)this.channelId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    public ImmutableMessageDeleteBulk withIds(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableMessageDeleteBulk(this, newValue, this.channelId(), this.guildId());
    }

    public ImmutableMessageDeleteBulk withChannelId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableMessageDeleteBulk(this, this.ids(), newValue, this.guildId());
    }

    public ImmutableMessageDeleteBulk withChannelId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableMessageDeleteBulk(this, this.ids(), newValue, this.guildId());
    }

    public ImmutableMessageDeleteBulk withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageDeleteBulk(this, this.ids(), this.channelId(), newValue);
    }

    public ImmutableMessageDeleteBulk withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessageDeleteBulk(this, this.ids(), this.channelId(), (Possible<Id>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageDeleteBulk && this.equalTo((ImmutableMessageDeleteBulk)another);
    }

    private boolean equalTo(ImmutableMessageDeleteBulk another) {
        return Objects.equals(this.ids_value, another.ids_value) && Objects.equals(this.channelId_value, another.channelId_value) && this.guildId().equals(another.guildId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ids_value);
        h += (h << 5) + Objects.hashCode(this.channelId_value);
        h += (h << 5) + this.guildId().hashCode();
        return h;
    }

    public String toString() {
        return "MessageDeleteBulk{ids=" + Objects.toString(this.ids_value) + ", channelId=" + Objects.toString(this.channelId_value) + ", guildId=" + this.guildId().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageDeleteBulk fromJson(Json json) {
        Builder builder = ImmutableMessageDeleteBulk.builder();
        if (json.ids != null) {
            builder.ids(json.ids);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        return builder.build();
    }

    public static ImmutableMessageDeleteBulk of(List<Id> ids, Id channelId, Possible<Id> guildId) {
        return new ImmutableMessageDeleteBulk(ids, channelId, guildId);
    }

    public static ImmutableMessageDeleteBulk copyOf(MessageDeleteBulk instance) {
        if (instance instanceof ImmutableMessageDeleteBulk) {
            return (ImmutableMessageDeleteBulk)instance;
        }
        return ImmutableMessageDeleteBulk.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MessageDeleteBulk", generator="Immutables")
    public static final class Builder {
        private List<Long> ids_list = null;
        private Id channelId_id = null;
        private Possible<Id> guildId_possible = Possible.absent();

        private Builder() {
        }

        public final Builder from(MessageDeleteBulk instance) {
            Objects.requireNonNull(instance, "instance");
            this.ids(instance.ids());
            this.channelId(instance.channelId());
            this.guildId(instance.guildId());
            return this;
        }

        public Builder addId(long element) {
            this.ids_getOrCreate().add(element);
            return this;
        }

        public Builder addId(String element) {
            this.ids_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addId(Id element) {
            this.ids_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllIds(List<Long> elements) {
            this.ids_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="ids")
        public Builder ids(List<Id> elements) {
            this.ids_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder ids(Iterable<Id> elements) {
            this.ids_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_id = Id.of((String)value);
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Id value) {
            this.channelId_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        public ImmutableMessageDeleteBulk build() {
            return new ImmutableMessageDeleteBulk(null, this.ids_build(), this.channelId_build(), this.guildId_build());
        }

        private List<Id> ids_build() {
            return this.ids_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> ids_getOrCreate() {
            if (this.ids_list == null) {
                this.ids_list = new ArrayList<Long>();
            }
            return this.ids_list;
        }

        private Id channelId_build() {
            return this.channelId_id;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessageDeleteBulk", generator="Immutables")
    static final class Json
    implements MessageDeleteBulk {
        List<Id> ids;
        Id channelId;
        Possible<Id> guildId;

        Json() {
        }

        @JsonProperty(value="ids")
        public void setIds(List<Id> ids) {
            this.ids = ids;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Id channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @Override
        public List<Id> ids() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MessageDeleteBulk", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageDeleteBulk, attribute initializers form cycle " + attributes;
        }
    }
}

