/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="MemberData", generator="Immutables")
public final class ImmutableMemberData
implements MemberData {
    private final UserData user;
    private final String nick_value;
    private final boolean nick_absent;
    private final long[] roles_value;
    private final String joinedAt;
    private final String premiumSince_value;
    private final boolean premiumSince_absent;
    private final String hoistedRole;
    private final boolean deaf;
    private final boolean mute;
    private final Boolean pending_value;
    private final boolean pending_absent;
    private final String permissions_value;
    private final boolean permissions_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMemberData(UserData user, Possible<Optional<String>> nick, List<Id> roles, Optional<String> joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute, Possible<Boolean> pending, Possible<String> permissions) {
        this.user = Objects.requireNonNull(user, "user");
        Possible<Optional<String>> nick$impl = nick;
        List<Id> roles$impl = roles;
        this.joinedAt = joinedAt.orElse(null);
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole.orElse(null);
        this.deaf = deaf;
        this.mute = mute;
        Possible<Boolean> pending$impl = pending;
        Possible<String> permissions$impl = permissions;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.roles_value = roles$impl.stream().mapToLong(Id::asLong).toArray();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.pending_value = pending$impl.toOptional().orElse(null);
        this.pending_absent = pending$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMemberData(ImmutableMemberData original, UserData user, Possible<Optional<String>> nick, List<Id> roles, String joinedAt, Possible<Optional<String>> premiumSince, String hoistedRole, boolean deaf, boolean mute, Possible<Boolean> pending, Possible<String> permissions) {
        this.user = user;
        Possible<Optional<String>> nick$impl = nick;
        List<Id> roles$impl = roles;
        this.joinedAt = joinedAt;
        Possible<Optional<String>> premiumSince$impl = premiumSince;
        this.hoistedRole = hoistedRole;
        this.deaf = deaf;
        this.mute = mute;
        Possible<Boolean> pending$impl = pending;
        Possible<String> permissions$impl = permissions;
        this.nick_value = Possible.flatOpt(nick$impl).orElse(null);
        this.nick_absent = nick$impl.isAbsent();
        this.roles_value = roles$impl.stream().mapToLong(Id::asLong).toArray();
        this.premiumSince_value = Possible.flatOpt(premiumSince$impl).orElse(null);
        this.premiumSince_absent = premiumSince$impl.isAbsent();
        this.pending_value = pending$impl.toOptional().orElse(null);
        this.pending_absent = pending$impl.isAbsent();
        this.permissions_value = permissions$impl.toOptional().orElse(null);
        this.permissions_absent = permissions$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="nick")
    public Possible<Optional<String>> nick() {
        return this.nick_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.nick_value));
    }

    @Override
    @JsonProperty(value="roles")
    public List<Id> roles() {
        return LongStream.of(this.roles_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="joined_at")
    public Optional<String> joinedAt() {
        return Optional.ofNullable(this.joinedAt);
    }

    @Override
    @JsonProperty(value="premium_since")
    public Possible<Optional<String>> premiumSince() {
        return this.premiumSince_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.premiumSince_value));
    }

    @Override
    @JsonProperty(value="hoisted_role")
    public Optional<String> hoistedRole() {
        return Optional.ofNullable(this.hoistedRole);
    }

    @Override
    @JsonProperty(value="deaf")
    public boolean deaf() {
        return this.deaf;
    }

    @Override
    @JsonProperty(value="mute")
    public boolean mute() {
        return this.mute;
    }

    @Override
    @JsonProperty(value="pending")
    public Possible<Boolean> pending() {
        return this.pending_absent ? Possible.absent() : Possible.of((Object)this.pending_value);
    }

    @Override
    @JsonProperty(value="permissions")
    public Possible<String> permissions() {
        return this.permissions_absent ? Possible.absent() : Possible.of((Object)this.permissions_value);
    }

    public final ImmutableMemberData withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableMemberData(this, newValue, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public ImmutableMemberData withNick(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableMemberData(this, this.user, newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public ImmutableMemberData withNick(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableMemberData(this, this.user, (Possible<Optional<String>>)newValue, this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public ImmutableMemberData withRoles(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableMemberData(this, this.user, this.nick(), newValue, this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public final ImmutableMemberData withJoinedAt(String value) {
        String newValue = Objects.requireNonNull(value, "joinedAt");
        if (Objects.equals(this.joinedAt, newValue)) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), newValue, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public final ImmutableMemberData withJoinedAt(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.joinedAt, value)) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), value, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public ImmutableMemberData withPremiumSince(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, newValue, this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public ImmutableMemberData withPremiumSince(String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, (Possible<Optional<String>>)newValue, this.hoistedRole, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public final ImmutableMemberData withHoistedRole(String value) {
        String newValue = Objects.requireNonNull(value, "hoistedRole");
        if (Objects.equals(this.hoistedRole, newValue)) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), newValue, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public final ImmutableMemberData withHoistedRole(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hoistedRole, value)) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), value, this.deaf, this.mute, this.pending(), this.permissions());
    }

    public final ImmutableMemberData withDeaf(boolean value) {
        if (this.deaf == value) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, value, this.mute, this.pending(), this.permissions());
    }

    public final ImmutableMemberData withMute(boolean value) {
        if (this.mute == value) {
            return this;
        }
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, value, this.pending(), this.permissions());
    }

    public ImmutableMemberData withPending(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, newValue, this.permissions());
    }

    public ImmutableMemberData withPending(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, (Possible<Boolean>)newValue, this.permissions());
    }

    public ImmutableMemberData withPermissions(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), newValue);
    }

    public ImmutableMemberData withPermissions(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMemberData(this, this.user, this.nick(), this.roles(), this.joinedAt, this.premiumSince(), this.hoistedRole, this.deaf, this.mute, this.pending(), (Possible<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMemberData && this.equalTo((ImmutableMemberData)another);
    }

    private boolean equalTo(ImmutableMemberData another) {
        return this.user.equals(another.user) && this.nick().equals(another.nick()) && Objects.equals(this.roles_value, another.roles_value) && Objects.equals(this.joinedAt, another.joinedAt) && this.premiumSince().equals(another.premiumSince()) && Objects.equals(this.hoistedRole, another.hoistedRole) && this.deaf == another.deaf && this.mute == another.mute && this.pending().equals(another.pending()) && this.permissions().equals(another.permissions());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.nick().hashCode();
        h += (h << 5) + Objects.hashCode(this.roles_value);
        h += (h << 5) + Objects.hashCode(this.joinedAt);
        h += (h << 5) + this.premiumSince().hashCode();
        h += (h << 5) + Objects.hashCode(this.hoistedRole);
        h += (h << 5) + Boolean.hashCode(this.deaf);
        h += (h << 5) + Boolean.hashCode(this.mute);
        h += (h << 5) + this.pending().hashCode();
        h += (h << 5) + this.permissions().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MemberData{");
        builder.append("user=").append(this.user);
        builder.append(", ");
        builder.append("nick=").append(this.nick().toString());
        builder.append(", ");
        builder.append("roles=").append(Objects.toString(this.roles_value));
        if (this.joinedAt != null) {
            builder.append(", ");
            builder.append("joinedAt=").append(this.joinedAt);
        }
        builder.append(", ");
        builder.append("premiumSince=").append(this.premiumSince().toString());
        if (this.hoistedRole != null) {
            builder.append(", ");
            builder.append("hoistedRole=").append(this.hoistedRole);
        }
        builder.append(", ");
        builder.append("deaf=").append(this.deaf);
        builder.append(", ");
        builder.append("mute=").append(this.mute);
        builder.append(", ");
        builder.append("pending=").append(this.pending().toString());
        builder.append(", ");
        builder.append("permissions=").append(this.permissions().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMemberData fromJson(Json json) {
        Builder builder = ImmutableMemberData.builder();
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.nick != null) {
            builder.nick(json.nick);
        }
        if (json.roles != null) {
            builder.roles(json.roles);
        }
        if (json.joinedAt != null) {
            builder.joinedAt(json.joinedAt);
        }
        if (json.premiumSince != null) {
            builder.premiumSince(json.premiumSince);
        }
        if (json.hoistedRole != null) {
            builder.hoistedRole(json.hoistedRole);
        }
        if (json.deafIsSet) {
            builder.deaf(json.deaf);
        }
        if (json.muteIsSet) {
            builder.mute(json.mute);
        }
        if (json.pending != null) {
            builder.pending(json.pending);
        }
        if (json.permissions != null) {
            builder.permissions(json.permissions);
        }
        return builder.build();
    }

    public static ImmutableMemberData of(UserData user, Possible<Optional<String>> nick, List<Id> roles, Optional<String> joinedAt, Possible<Optional<String>> premiumSince, Optional<String> hoistedRole, boolean deaf, boolean mute, Possible<Boolean> pending, Possible<String> permissions) {
        return new ImmutableMemberData(user, nick, roles, joinedAt, premiumSince, hoistedRole, deaf, mute, pending, permissions);
    }

    public static ImmutableMemberData copyOf(MemberData instance) {
        if (instance instanceof ImmutableMemberData) {
            return (ImmutableMemberData)instance;
        }
        return ImmutableMemberData.builder().from(instance).build();
    }

    public boolean isNickPresent() {
        return !this.nick_absent;
    }

    public String nickOrElse(String defaultValue) {
        return !this.nick_absent ? this.nick_value : defaultValue;
    }

    public boolean isPremiumSincePresent() {
        return !this.premiumSince_absent;
    }

    public String premiumSinceOrElse(String defaultValue) {
        return !this.premiumSince_absent ? this.premiumSince_value : defaultValue;
    }

    public boolean isPendingPresent() {
        return !this.pending_absent;
    }

    public Boolean pendingOrElse(Boolean defaultValue) {
        return !this.pending_absent ? this.pending_value : defaultValue;
    }

    public boolean isPermissionsPresent() {
        return !this.permissions_absent;
    }

    public String permissionsOrElse(String defaultValue) {
        return !this.permissions_absent ? this.permissions_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MemberData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_USER = 1L;
        private static final long INIT_BIT_DEAF = 2L;
        private static final long INIT_BIT_MUTE = 4L;
        private long initBits = 7L;
        private Possible<Optional<String>> nick_possible = Possible.absent();
        private List<Long> roles_list = null;
        private Possible<Optional<String>> premiumSince_possible = Possible.absent();
        private Possible<Boolean> pending_possible = Possible.absent();
        private Possible<String> permissions_possible = Possible.absent();
        private UserData user;
        private String joinedAt;
        private String hoistedRole;
        private boolean deaf;
        private boolean mute;

        private Builder() {
        }

        public final Builder from(MemberData instance) {
            Objects.requireNonNull(instance, "instance");
            this.user(instance.user());
            this.nick(instance.nick());
            this.roles(instance.roles());
            Optional<String> joinedAtOptional = instance.joinedAt();
            if (joinedAtOptional.isPresent()) {
                this.joinedAt(joinedAtOptional);
            }
            this.premiumSince(instance.premiumSince());
            Optional<String> hoistedRoleOptional = instance.hoistedRole();
            if (hoistedRoleOptional.isPresent()) {
                this.hoistedRole(hoistedRoleOptional);
            }
            this.deaf(instance.deaf());
            this.mute(instance.mute());
            this.pending(instance.pending());
            this.permissions(instance.permissions());
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="nick")
        public Builder nick(Possible<Optional<String>> value) {
            this.nick_possible = value;
            return this;
        }

        public Builder nick(String value) {
            this.nick_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder addRole(long element) {
            this.roles_getOrCreate().add(element);
            return this;
        }

        public Builder addRole(String element) {
            this.roles_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addRole(Id element) {
            this.roles_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllRoles(List<Long> elements) {
            this.roles_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="roles")
        public Builder roles(List<Id> elements) {
            this.roles_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder roles(Iterable<Id> elements) {
            this.roles_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public final Builder joinedAt(String joinedAt) {
            this.joinedAt = Objects.requireNonNull(joinedAt, "joinedAt");
            return this;
        }

        @JsonProperty(value="joined_at")
        public final Builder joinedAt(Optional<String> joinedAt) {
            this.joinedAt = joinedAt.orElse(null);
            return this;
        }

        @JsonProperty(value="premium_since")
        public Builder premiumSince(Possible<Optional<String>> value) {
            this.premiumSince_possible = value;
            return this;
        }

        public Builder premiumSince(String value) {
            this.premiumSince_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public final Builder hoistedRole(String hoistedRole) {
            this.hoistedRole = Objects.requireNonNull(hoistedRole, "hoistedRole");
            return this;
        }

        @JsonProperty(value="hoisted_role")
        public final Builder hoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole.orElse(null);
            return this;
        }

        @JsonProperty(value="deaf")
        public final Builder deaf(boolean deaf) {
            this.deaf = deaf;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="mute")
        public final Builder mute(boolean mute) {
            this.mute = mute;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="pending")
        public Builder pending(Possible<Boolean> value) {
            this.pending_possible = value;
            return this;
        }

        public Builder pending(Boolean value) {
            this.pending_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="permissions")
        public Builder permissions(Possible<String> value) {
            this.permissions_possible = value;
            return this;
        }

        public Builder permissions(String value) {
            this.permissions_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableMemberData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMemberData(null, this.user, this.nick_build(), this.roles_build(), this.joinedAt, this.premiumSince_build(), this.hoistedRole, this.deaf, this.mute, this.pending_build(), this.permissions_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("user");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("deaf");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mute");
            }
            return "Cannot build MemberData, some of required attributes are not set " + attributes;
        }

        private Possible<Optional<String>> nick_build() {
            return this.nick_possible;
        }

        private List<Id> roles_build() {
            return this.roles_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> roles_getOrCreate() {
            if (this.roles_list == null) {
                this.roles_list = new ArrayList<Long>();
            }
            return this.roles_list;
        }

        private Possible<Optional<String>> premiumSince_build() {
            return this.premiumSince_possible;
        }

        private Possible<Boolean> pending_build() {
            return this.pending_possible;
        }

        private Possible<String> permissions_build() {
            return this.permissions_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MemberData", generator="Immutables")
    static final class Json
    implements MemberData {
        UserData user;
        Possible<Optional<String>> nick;
        List<Id> roles;
        Optional<String> joinedAt = Optional.empty();
        Possible<Optional<String>> premiumSince;
        Optional<String> hoistedRole = Optional.empty();
        boolean deaf;
        boolean deafIsSet;
        boolean mute;
        boolean muteIsSet;
        Possible<Boolean> pending;
        Possible<String> permissions;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @JsonProperty(value="nick")
        public void setNick(Possible<Optional<String>> nick) {
            this.nick = nick;
        }

        @JsonProperty(value="roles")
        public void setRoles(List<Id> roles) {
            this.roles = roles;
        }

        @JsonProperty(value="joined_at")
        public void setJoinedAt(Optional<String> joinedAt) {
            this.joinedAt = joinedAt;
        }

        @JsonProperty(value="premium_since")
        public void setPremiumSince(Possible<Optional<String>> premiumSince) {
            this.premiumSince = premiumSince;
        }

        @JsonProperty(value="hoisted_role")
        public void setHoistedRole(Optional<String> hoistedRole) {
            this.hoistedRole = hoistedRole;
        }

        @JsonProperty(value="deaf")
        public void setDeaf(boolean deaf) {
            this.deaf = deaf;
            this.deafIsSet = true;
        }

        @JsonProperty(value="mute")
        public void setMute(boolean mute) {
            this.mute = mute;
            this.muteIsSet = true;
        }

        @JsonProperty(value="pending")
        public void setPending(Possible<Boolean> pending) {
            this.pending = pending;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(Possible<String> permissions) {
            this.permissions = permissions;
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> nick() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> roles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> joinedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> premiumSince() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> hoistedRole() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deaf() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> pending() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> permissions() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MemberData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MemberData, attribute initializers form cycle " + attributes;
        }
    }
}

