/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="VoiceStateUpdate", generator="Immutables")
public final class ImmutableVoiceStateUpdate
implements VoiceStateUpdate {
    private final String guildId;
    private final String channelId;
    private final boolean selfMute;
    private final boolean selfDeaf;

    private ImmutableVoiceStateUpdate(String guildId, Optional<String> channelId, boolean selfMute, boolean selfDeaf) {
        this.guildId = Objects.requireNonNull(guildId, "guildId");
        this.channelId = channelId.orElse(null);
        this.selfMute = selfMute;
        this.selfDeaf = selfDeaf;
    }

    private ImmutableVoiceStateUpdate(ImmutableVoiceStateUpdate original, String guildId, String channelId, boolean selfMute, boolean selfDeaf) {
        this.guildId = guildId;
        this.channelId = channelId;
        this.selfMute = selfMute;
        this.selfDeaf = selfDeaf;
    }

    @Override
    @JsonProperty(value="guild_id")
    public String guildId() {
        return this.guildId;
    }

    @Override
    @JsonProperty(value="channel_id")
    public Optional<String> channelId() {
        return Optional.ofNullable(this.channelId);
    }

    @Override
    @JsonProperty(value="self_mute")
    public boolean selfMute() {
        return this.selfMute;
    }

    @Override
    @JsonProperty(value="self_deaf")
    public boolean selfDeaf() {
        return this.selfDeaf;
    }

    public final ImmutableVoiceStateUpdate withGuildId(String value) {
        String newValue = Objects.requireNonNull(value, "guildId");
        if (this.guildId.equals(newValue)) {
            return this;
        }
        return new ImmutableVoiceStateUpdate(this, newValue, this.channelId, this.selfMute, this.selfDeaf);
    }

    public final ImmutableVoiceStateUpdate withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (Objects.equals(this.channelId, newValue)) {
            return this;
        }
        return new ImmutableVoiceStateUpdate(this, this.guildId, newValue, this.selfMute, this.selfDeaf);
    }

    public final ImmutableVoiceStateUpdate withChannelId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channelId, value)) {
            return this;
        }
        return new ImmutableVoiceStateUpdate(this, this.guildId, value, this.selfMute, this.selfDeaf);
    }

    public final ImmutableVoiceStateUpdate withSelfMute(boolean value) {
        if (this.selfMute == value) {
            return this;
        }
        return new ImmutableVoiceStateUpdate(this, this.guildId, this.channelId, value, this.selfDeaf);
    }

    public final ImmutableVoiceStateUpdate withSelfDeaf(boolean value) {
        if (this.selfDeaf == value) {
            return this;
        }
        return new ImmutableVoiceStateUpdate(this, this.guildId, this.channelId, this.selfMute, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVoiceStateUpdate && this.equalTo((ImmutableVoiceStateUpdate)another);
    }

    private boolean equalTo(ImmutableVoiceStateUpdate another) {
        return this.guildId.equals(another.guildId) && Objects.equals(this.channelId, another.channelId) && this.selfMute == another.selfMute && this.selfDeaf == another.selfDeaf;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.guildId.hashCode();
        h += (h << 5) + Objects.hashCode(this.channelId);
        h += (h << 5) + Boolean.hashCode(this.selfMute);
        h += (h << 5) + Boolean.hashCode(this.selfDeaf);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("VoiceStateUpdate{");
        builder.append("guildId=").append(this.guildId);
        if (this.channelId != null) {
            builder.append(", ");
            builder.append("channelId=").append(this.channelId);
        }
        builder.append(", ");
        builder.append("selfMute=").append(this.selfMute);
        builder.append(", ");
        builder.append("selfDeaf=").append(this.selfDeaf);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableVoiceStateUpdate fromJson(Json json) {
        Builder builder = ImmutableVoiceStateUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.selfMuteIsSet) {
            builder.selfMute(json.selfMute);
        }
        if (json.selfDeafIsSet) {
            builder.selfDeaf(json.selfDeaf);
        }
        return builder.build();
    }

    public static ImmutableVoiceStateUpdate of(String guildId, Optional<String> channelId, boolean selfMute, boolean selfDeaf) {
        return new ImmutableVoiceStateUpdate(guildId, channelId, selfMute, selfDeaf);
    }

    public static ImmutableVoiceStateUpdate copyOf(VoiceStateUpdate instance) {
        if (instance instanceof ImmutableVoiceStateUpdate) {
            return (ImmutableVoiceStateUpdate)instance;
        }
        return ImmutableVoiceStateUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VoiceStateUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_GUILD_ID = 1L;
        private static final long INIT_BIT_SELF_MUTE = 2L;
        private static final long INIT_BIT_SELF_DEAF = 4L;
        private long initBits = 7L;
        private String guildId;
        private String channelId;
        private boolean selfMute;
        private boolean selfDeaf;

        private Builder() {
        }

        public final Builder from(VoiceStateUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            Optional<String> channelIdOptional = instance.channelId();
            if (channelIdOptional.isPresent()) {
                this.channelId(channelIdOptional);
            }
            this.selfMute(instance.selfMute());
            this.selfDeaf(instance.selfDeaf());
            return this;
        }

        @JsonProperty(value="guild_id")
        public final Builder guildId(String guildId) {
            this.guildId = Objects.requireNonNull(guildId, "guildId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder channelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            return this;
        }

        @JsonProperty(value="channel_id")
        public final Builder channelId(Optional<String> channelId) {
            this.channelId = channelId.orElse(null);
            return this;
        }

        @JsonProperty(value="self_mute")
        public final Builder selfMute(boolean selfMute) {
            this.selfMute = selfMute;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="self_deaf")
        public final Builder selfDeaf(boolean selfDeaf) {
            this.selfDeaf = selfDeaf;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableVoiceStateUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableVoiceStateUpdate(null, this.guildId, this.channelId, this.selfMute, this.selfDeaf);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("guildId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("selfMute");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("selfDeaf");
            }
            return "Cannot build VoiceStateUpdate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="VoiceStateUpdate", generator="Immutables")
    static final class Json
    implements VoiceStateUpdate {
        String guildId;
        Optional<String> channelId = Optional.empty();
        boolean selfMute;
        boolean selfMuteIsSet;
        boolean selfDeaf;
        boolean selfDeafIsSet;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(String guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Optional<String> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="self_mute")
        public void setSelfMute(boolean selfMute) {
            this.selfMute = selfMute;
            this.selfMuteIsSet = true;
        }

        @JsonProperty(value="self_deaf")
        public void setSelfDeaf(boolean selfDeaf) {
            this.selfDeaf = selfDeaf;
            this.selfDeafIsSet = true;
        }

        @Override
        public String guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean selfMute() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean selfDeaf() {
            throw new UnsupportedOperationException();
        }
    }
}

