/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MessageReactionAdd", generator="Immutables")
public final class ImmutableMessageReactionAdd
implements MessageReactionAdd {
    private final String userId;
    private final String channelId;
    private final String messageId;
    private final String guildId_value;
    private final boolean guildId_absent;
    private final MemberData member_value;
    private final boolean member_absent;
    private final EmojiData emoji;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReactionAdd(String userId, String channelId, String messageId, Possible<String> guildId, Possible<MemberData> member, EmojiData emoji) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.channelId = Objects.requireNonNull(channelId, "channelId");
        this.messageId = Objects.requireNonNull(messageId, "messageId");
        Possible<String> guildId$impl = guildId;
        Possible<MemberData> member$impl = member;
        this.emoji = Objects.requireNonNull(emoji, "emoji");
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageReactionAdd(ImmutableMessageReactionAdd original, String userId, String channelId, String messageId, Possible<String> guildId, Possible<MemberData> member, EmojiData emoji) {
        this.userId = userId;
        this.channelId = channelId;
        this.messageId = messageId;
        Possible<String> guildId$impl = guildId;
        Possible<MemberData> member$impl = member;
        this.emoji = emoji;
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="user_id")
    public String userId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel_id")
    public String channelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="message_id")
    public String messageId() {
        return this.messageId;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<String> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)this.guildId_value);
    }

    @Override
    @JsonProperty(value="member")
    public Possible<MemberData> member() {
        return this.member_absent ? Possible.absent() : Possible.of((Object)this.member_value);
    }

    @Override
    @JsonProperty(value="emoji")
    public EmojiData emoji() {
        return this.emoji;
    }

    public final ImmutableMessageReactionAdd withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageReactionAdd(this, newValue, this.channelId, this.messageId, this.guildId(), this.member(), this.emoji);
    }

    public final ImmutableMessageReactionAdd withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageReactionAdd(this, this.userId, newValue, this.messageId, this.guildId(), this.member(), this.emoji);
    }

    public final ImmutableMessageReactionAdd withMessageId(String value) {
        String newValue = Objects.requireNonNull(value, "messageId");
        if (this.messageId.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageReactionAdd(this, this.userId, this.channelId, newValue, this.guildId(), this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withGuildId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReactionAdd(this, this.userId, this.channelId, this.messageId, newValue, this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withGuildId(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageReactionAdd(this, this.userId, this.channelId, this.messageId, (Possible<String>)newValue, this.member(), this.emoji);
    }

    public ImmutableMessageReactionAdd withMember(Possible<MemberData> value) {
        Possible<MemberData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReactionAdd(this, this.userId, this.channelId, this.messageId, this.guildId(), newValue, this.emoji);
    }

    public ImmutableMessageReactionAdd withMember(MemberData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageReactionAdd(this, this.userId, this.channelId, this.messageId, this.guildId(), (Possible<MemberData>)newValue, this.emoji);
    }

    public final ImmutableMessageReactionAdd withEmoji(EmojiData value) {
        if (this.emoji == value) {
            return this;
        }
        EmojiData newValue = Objects.requireNonNull(value, "emoji");
        return new ImmutableMessageReactionAdd(this, this.userId, this.channelId, this.messageId, this.guildId(), this.member(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReactionAdd && this.equalTo((ImmutableMessageReactionAdd)another);
    }

    private boolean equalTo(ImmutableMessageReactionAdd another) {
        return this.userId.equals(another.userId) && this.channelId.equals(another.channelId) && this.messageId.equals(another.messageId) && this.guildId().equals(another.guildId()) && this.member().equals(another.member()) && this.emoji.equals(another.emoji);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.messageId.hashCode();
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.member().hashCode();
        h += (h << 5) + this.emoji.hashCode();
        return h;
    }

    public String toString() {
        return "MessageReactionAdd{userId=" + this.userId + ", channelId=" + this.channelId + ", messageId=" + this.messageId + ", guildId=" + this.guildId().toString() + ", member=" + this.member().toString() + ", emoji=" + this.emoji + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageReactionAdd fromJson(Json json) {
        Builder builder = ImmutableMessageReactionAdd.builder();
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.messageId != null) {
            builder.messageId(json.messageId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.member != null) {
            builder.member(json.member);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        return builder.build();
    }

    public static ImmutableMessageReactionAdd of(String userId, String channelId, String messageId, Possible<String> guildId, Possible<MemberData> member, EmojiData emoji) {
        return new ImmutableMessageReactionAdd(userId, channelId, messageId, guildId, member, emoji);
    }

    public static ImmutableMessageReactionAdd copyOf(MessageReactionAdd instance) {
        if (instance instanceof ImmutableMessageReactionAdd) {
            return (ImmutableMessageReactionAdd)instance;
        }
        return ImmutableMessageReactionAdd.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public String guildIdOrElse(String defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isMemberPresent() {
        return !this.member_absent;
    }

    public MemberData memberOrElse(MemberData defaultValue) {
        return !this.member_absent ? this.member_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MessageReactionAdd", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_MESSAGE_ID = 4L;
        private static final long INIT_BIT_EMOJI = 8L;
        private long initBits = 15L;
        private Possible<String> guildId_possible = Possible.absent();
        private Possible<MemberData> member_possible = Possible.absent();
        private String userId;
        private String channelId;
        private String messageId;
        private EmojiData emoji;

        private Builder() {
        }

        public final Builder from(MessageReactionAdd instance) {
            Objects.requireNonNull(instance, "instance");
            this.userId(instance.userId());
            this.channelId(instance.channelId());
            this.messageId(instance.messageId());
            this.guildId(instance.guildId());
            this.member(instance.member());
            this.emoji(instance.emoji());
            return this;
        }

        @JsonProperty(value="user_id")
        public final Builder userId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel_id")
        public final Builder channelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="message_id")
        public final Builder messageId(String messageId) {
            this.messageId = Objects.requireNonNull(messageId, "messageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<String> value) {
            this.guildId_possible = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="member")
        public Builder member(Possible<MemberData> value) {
            this.member_possible = value;
            return this;
        }

        public Builder member(MemberData value) {
            this.member_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="emoji")
        public final Builder emoji(EmojiData emoji) {
            this.emoji = Objects.requireNonNull(emoji, "emoji");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableMessageReactionAdd build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageReactionAdd(null, this.userId, this.channelId, this.messageId, this.guildId_build(), this.member_build(), this.emoji);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("messageId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("emoji");
            }
            return "Cannot build MessageReactionAdd, some of required attributes are not set " + attributes;
        }

        private Possible<String> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<MemberData> member_build() {
            return this.member_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessageReactionAdd", generator="Immutables")
    static final class Json
    implements MessageReactionAdd {
        String userId;
        String channelId;
        String messageId;
        Possible<String> guildId;
        Possible<MemberData> member;
        EmojiData emoji;

        Json() {
        }

        @JsonProperty(value="user_id")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<String> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="member")
        public void setMember(Possible<MemberData> member) {
            this.member = member;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(EmojiData emoji) {
            this.emoji = emoji;
        }

        @Override
        public String userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String messageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<MemberData> member() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmojiData emoji() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MessageReactionAdd", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageReactionAdd, attribute initializers form cycle " + attributes;
        }
    }
}

