/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="GuildMembersChunk", generator="Immutables")
public final class ImmutableGuildMembersChunk
implements GuildMembersChunk {
    private final String guildId;
    private final List<MemberData> members;
    private final int chunkIndex;
    private final int chunkCount;
    private final List<String> notFound_value;
    private final boolean notFound_absent;
    private final PresenceUpdate presences_value;
    private final boolean presences_absent;
    private final String nonce_value;
    private final boolean nonce_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildMembersChunk(String guildId, Iterable<? extends MemberData> members, int chunkIndex, int chunkCount, Possible<List<String>> notFound, Possible<PresenceUpdate> presences, Possible<String> nonce) {
        this.guildId = Objects.requireNonNull(guildId, "guildId");
        this.members = ImmutableGuildMembersChunk.createUnmodifiableList(false, ImmutableGuildMembersChunk.createSafeList(members, true, false));
        this.chunkIndex = chunkIndex;
        this.chunkCount = chunkCount;
        Possible<List<String>> notFound$impl = notFound;
        Possible<PresenceUpdate> presences$impl = presences;
        Possible<String> nonce$impl = nonce;
        this.notFound_value = notFound$impl.toOptional().orElse(null);
        this.notFound_absent = notFound$impl.isAbsent();
        this.presences_value = presences$impl.toOptional().orElse(null);
        this.presences_absent = presences$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableGuildMembersChunk(ImmutableGuildMembersChunk original, String guildId, List<MemberData> members, int chunkIndex, int chunkCount, Possible<List<String>> notFound, Possible<PresenceUpdate> presences, Possible<String> nonce) {
        this.guildId = guildId;
        this.members = members;
        this.chunkIndex = chunkIndex;
        this.chunkCount = chunkCount;
        Possible<List<String>> notFound$impl = notFound;
        Possible<PresenceUpdate> presences$impl = presences;
        Possible<String> nonce$impl = nonce;
        this.notFound_value = notFound$impl.toOptional().orElse(null);
        this.notFound_absent = notFound$impl.isAbsent();
        this.presences_value = presences$impl.toOptional().orElse(null);
        this.presences_absent = presences$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public String guildId() {
        return this.guildId;
    }

    @Override
    @JsonProperty(value="members")
    public List<MemberData> members() {
        return this.members;
    }

    @Override
    @JsonProperty(value="chunk_index")
    public int chunkIndex() {
        return this.chunkIndex;
    }

    @Override
    @JsonProperty(value="chunk_count")
    public int chunkCount() {
        return this.chunkCount;
    }

    @Override
    @JsonProperty(value="not_found")
    public Possible<List<String>> notFound() {
        return this.notFound_absent ? Possible.absent() : Possible.of(this.notFound_value);
    }

    @Override
    @JsonProperty(value="presences")
    public Possible<PresenceUpdate> presences() {
        return this.presences_absent ? Possible.absent() : Possible.of((Object)this.presences_value);
    }

    @Override
    @JsonProperty(value="nonce")
    public Possible<String> nonce() {
        return this.nonce_absent ? Possible.absent() : Possible.of((Object)this.nonce_value);
    }

    public final ImmutableGuildMembersChunk withGuildId(String value) {
        String newValue = Objects.requireNonNull(value, "guildId");
        if (this.guildId.equals(newValue)) {
            return this;
        }
        return new ImmutableGuildMembersChunk(this, newValue, this.members, this.chunkIndex, this.chunkCount, this.notFound(), this.presences(), this.nonce());
    }

    public final ImmutableGuildMembersChunk withMembers(MemberData ... elements) {
        List<MemberData> newValue = ImmutableGuildMembersChunk.createUnmodifiableList(false, ImmutableGuildMembersChunk.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGuildMembersChunk(this, this.guildId, newValue, this.chunkIndex, this.chunkCount, this.notFound(), this.presences(), this.nonce());
    }

    public final ImmutableGuildMembersChunk withMembers(Iterable<? extends MemberData> elements) {
        if (this.members == elements) {
            return this;
        }
        List<MemberData> newValue = ImmutableGuildMembersChunk.createUnmodifiableList(false, ImmutableGuildMembersChunk.createSafeList(elements, true, false));
        return new ImmutableGuildMembersChunk(this, this.guildId, newValue, this.chunkIndex, this.chunkCount, this.notFound(), this.presences(), this.nonce());
    }

    public final ImmutableGuildMembersChunk withChunkIndex(int value) {
        if (this.chunkIndex == value) {
            return this;
        }
        return new ImmutableGuildMembersChunk(this, this.guildId, this.members, value, this.chunkCount, this.notFound(), this.presences(), this.nonce());
    }

    public final ImmutableGuildMembersChunk withChunkCount(int value) {
        if (this.chunkCount == value) {
            return this;
        }
        return new ImmutableGuildMembersChunk(this, this.guildId, this.members, this.chunkIndex, value, this.notFound(), this.presences(), this.nonce());
    }

    public ImmutableGuildMembersChunk withNotFound(Possible<List<String>> value) {
        Possible<List<String>> newValue = value;
        return new ImmutableGuildMembersChunk(this, this.guildId, this.members, this.chunkIndex, this.chunkCount, newValue, this.presences(), this.nonce());
    }

    public ImmutableGuildMembersChunk withPresences(Possible<PresenceUpdate> value) {
        Possible<PresenceUpdate> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMembersChunk(this, this.guildId, this.members, this.chunkIndex, this.chunkCount, this.notFound(), newValue, this.nonce());
    }

    public ImmutableGuildMembersChunk withPresences(PresenceUpdate value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableGuildMembersChunk(this, this.guildId, this.members, this.chunkIndex, this.chunkCount, this.notFound(), (Possible<PresenceUpdate>)newValue, this.nonce());
    }

    public ImmutableGuildMembersChunk withNonce(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableGuildMembersChunk(this, this.guildId, this.members, this.chunkIndex, this.chunkCount, this.notFound(), this.presences(), newValue);
    }

    public ImmutableGuildMembersChunk withNonce(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableGuildMembersChunk(this, this.guildId, this.members, this.chunkIndex, this.chunkCount, this.notFound(), this.presences(), (Possible<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildMembersChunk && this.equalTo((ImmutableGuildMembersChunk)another);
    }

    private boolean equalTo(ImmutableGuildMembersChunk another) {
        return this.guildId.equals(another.guildId) && this.members.equals(another.members) && this.chunkIndex == another.chunkIndex && this.chunkCount == another.chunkCount && Objects.equals(this.notFound_value, another.notFound_value) && this.presences().equals(another.presences()) && this.nonce().equals(another.nonce());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.guildId.hashCode();
        h += (h << 5) + this.members.hashCode();
        h += (h << 5) + this.chunkIndex;
        h += (h << 5) + this.chunkCount;
        h += (h << 5) + Objects.hashCode(this.notFound_value);
        h += (h << 5) + this.presences().hashCode();
        h += (h << 5) + this.nonce().hashCode();
        return h;
    }

    public String toString() {
        return "GuildMembersChunk{guildId=" + this.guildId + ", members=" + this.members + ", chunkIndex=" + this.chunkIndex + ", chunkCount=" + this.chunkCount + ", notFound=" + Objects.toString(this.notFound_value) + ", presences=" + this.presences().toString() + ", nonce=" + this.nonce().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildMembersChunk fromJson(Json json) {
        Builder builder = ImmutableGuildMembersChunk.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.chunkIndexIsSet) {
            builder.chunkIndex(json.chunkIndex);
        }
        if (json.chunkCountIsSet) {
            builder.chunkCount(json.chunkCount);
        }
        if (json.notFound != null) {
            builder.notFound(json.notFound);
        }
        if (json.presences != null) {
            builder.presences(json.presences);
        }
        if (json.nonce != null) {
            builder.nonce(json.nonce);
        }
        return builder.build();
    }

    public static ImmutableGuildMembersChunk of(String guildId, List<MemberData> members, int chunkIndex, int chunkCount, Possible<List<String>> notFound, Possible<PresenceUpdate> presences, Possible<String> nonce) {
        return ImmutableGuildMembersChunk.of(guildId, members, chunkIndex, chunkCount, notFound, presences, nonce);
    }

    public static ImmutableGuildMembersChunk of(String guildId, Iterable<? extends MemberData> members, int chunkIndex, int chunkCount, Possible<List<String>> notFound, Possible<PresenceUpdate> presences, Possible<String> nonce) {
        return new ImmutableGuildMembersChunk(guildId, members, chunkIndex, chunkCount, notFound, presences, nonce);
    }

    public static ImmutableGuildMembersChunk copyOf(GuildMembersChunk instance) {
        if (instance instanceof ImmutableGuildMembersChunk) {
            return (ImmutableGuildMembersChunk)instance;
        }
        return ImmutableGuildMembersChunk.builder().from(instance).build();
    }

    public boolean isNotFoundPresent() {
        return !this.notFound_absent;
    }

    public List<String> notFoundOrElse(List<String> defaultValue) {
        return !this.notFound_absent ? this.notFound_value : defaultValue;
    }

    public boolean isPresencesPresent() {
        return !this.presences_absent;
    }

    public PresenceUpdate presencesOrElse(PresenceUpdate defaultValue) {
        return !this.presences_absent ? this.presences_value : defaultValue;
    }

    public boolean isNoncePresent() {
        return !this.nonce_absent;
    }

    public String nonceOrElse(String defaultValue) {
        return !this.nonce_absent ? this.nonce_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildMembersChunk", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_GUILD_ID = 1L;
        private static final long INIT_BIT_CHUNK_INDEX = 2L;
        private static final long INIT_BIT_CHUNK_COUNT = 4L;
        private long initBits = 7L;
        private List<String> notFound_list = null;
        private Possible<PresenceUpdate> presences_possible = Possible.absent();
        private Possible<String> nonce_possible = Possible.absent();
        private String guildId;
        private List<MemberData> members = new ArrayList<MemberData>();
        private int chunkIndex;
        private int chunkCount;

        private Builder() {
        }

        public final Builder from(GuildMembersChunk instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.addAllMembers(instance.members());
            this.chunkIndex(instance.chunkIndex());
            this.chunkCount(instance.chunkCount());
            this.notFound(instance.notFound());
            this.presences(instance.presences());
            this.nonce(instance.nonce());
            return this;
        }

        @JsonProperty(value="guild_id")
        public final Builder guildId(String guildId) {
            this.guildId = Objects.requireNonNull(guildId, "guildId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addMember(MemberData element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(MemberData ... elements) {
            for (MemberData element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends MemberData> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends MemberData> elements) {
            for (MemberData memberData : elements) {
                this.members.add(Objects.requireNonNull(memberData, "members element"));
            }
            return this;
        }

        @JsonProperty(value="chunk_index")
        public final Builder chunkIndex(int chunkIndex) {
            this.chunkIndex = chunkIndex;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="chunk_count")
        public final Builder chunkCount(int chunkCount) {
            this.chunkCount = chunkCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder addNotFound(String element) {
            this.notFound_getOrCreate().add(element);
            return this;
        }

        public Builder addAllNotFound(List<String> elements) {
            this.notFound_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="not_found")
        public Builder notFound(Possible<List<String>> elements) {
            this.notFound_list = null;
            elements.toOptional().ifPresent(e -> this.notFound_getOrCreate().addAll((Collection<String>)e));
            return this;
        }

        public Builder notFound(List<String> elements) {
            this.notFound_list = new ArrayList<String>(elements);
            return this;
        }

        @JsonProperty(value="presences")
        public Builder presences(Possible<PresenceUpdate> value) {
            this.presences_possible = value;
            return this;
        }

        public Builder presences(PresenceUpdate value) {
            this.presences_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="nonce")
        public Builder nonce(Possible<String> value) {
            this.nonce_possible = value;
            return this;
        }

        public Builder nonce(String value) {
            this.nonce_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableGuildMembersChunk build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildMembersChunk(null, this.guildId, ImmutableGuildMembersChunk.createUnmodifiableList(true, this.members), this.chunkIndex, this.chunkCount, this.notFound_build(), this.presences_build(), this.nonce_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("guildId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("chunkIndex");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("chunkCount");
            }
            return "Cannot build GuildMembersChunk, some of required attributes are not set " + attributes;
        }

        private Possible<List<String>> notFound_build() {
            return this.notFound_list == null ? Possible.absent() : Possible.of(this.notFound_list);
        }

        private List<String> notFound_getOrCreate() {
            if (this.notFound_list == null) {
                this.notFound_list = new ArrayList<String>();
            }
            return this.notFound_list;
        }

        private Possible<PresenceUpdate> presences_build() {
            return this.presences_possible;
        }

        private Possible<String> nonce_build() {
            return this.nonce_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GuildMembersChunk", generator="Immutables")
    static final class Json
    implements GuildMembersChunk {
        String guildId;
        List<MemberData> members = Collections.emptyList();
        int chunkIndex;
        boolean chunkIndexIsSet;
        int chunkCount;
        boolean chunkCountIsSet;
        Possible<List<String>> notFound;
        Possible<PresenceUpdate> presences;
        Possible<String> nonce;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(String guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="members")
        public void setMembers(List<MemberData> members) {
            this.members = members;
        }

        @JsonProperty(value="chunk_index")
        public void setChunkIndex(int chunkIndex) {
            this.chunkIndex = chunkIndex;
            this.chunkIndexIsSet = true;
        }

        @JsonProperty(value="chunk_count")
        public void setChunkCount(int chunkCount) {
            this.chunkCount = chunkCount;
            this.chunkCountIsSet = true;
        }

        @JsonProperty(value="not_found")
        public void setNotFound(Possible<List<String>> notFound) {
            this.notFound = notFound;
        }

        @JsonProperty(value="presences")
        public void setPresences(Possible<PresenceUpdate> presences) {
            this.presences = presences;
        }

        @JsonProperty(value="nonce")
        public void setNonce(Possible<String> nonce) {
            this.nonce = nonce;
        }

        @Override
        public String guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MemberData> members() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int chunkIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int chunkCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<String>> notFound() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<PresenceUpdate> presences() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> nonce() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="GuildMembersChunk", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildMembersChunk, attribute initializers form cycle " + attributes;
        }
    }
}

