/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="WebhookData", generator="Immutables")
public final class ImmutableWebhookData
implements WebhookData {
    private final String id;
    private final int type;
    private final String guildId_value;
    private final boolean guildId_absent;
    private final String channelId;
    private final UserData user_value;
    private final boolean user_absent;
    private final String name;
    private final String avatar;
    private final String token_value;
    private final boolean token_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWebhookData(String id, int type, Possible<String> guildId, String channelId, Possible<UserData> user, Optional<String> name, Optional<String> avatar, Possible<String> token) {
        this.id = Objects.requireNonNull(id, "id");
        this.type = type;
        Possible<String> guildId$impl = guildId;
        this.channelId = Objects.requireNonNull(channelId, "channelId");
        Possible<UserData> user$impl = user;
        this.name = name.orElse(null);
        this.avatar = avatar.orElse(null);
        Possible<String> token$impl = token;
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.user_value = user$impl.toOptional().orElse(null);
        this.user_absent = user$impl.isAbsent();
        this.token_value = token$impl.toOptional().orElse(null);
        this.token_absent = token$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableWebhookData(ImmutableWebhookData original, String id, int type, Possible<String> guildId, String channelId, Possible<UserData> user, String name, String avatar, Possible<String> token) {
        this.id = id;
        this.type = type;
        Possible<String> guildId$impl = guildId;
        this.channelId = channelId;
        Possible<UserData> user$impl = user;
        this.name = name;
        this.avatar = avatar;
        Possible<String> token$impl = token;
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.user_value = user$impl.toOptional().orElse(null);
        this.user_absent = user$impl.isAbsent();
        this.token_value = token$impl.toOptional().orElse(null);
        this.token_absent = token$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<String> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)this.guildId_value);
    }

    @Override
    @JsonProperty(value="channel_id")
    public String channelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="user")
    public Possible<UserData> user() {
        return this.user_absent ? Possible.absent() : Possible.of((Object)this.user_value);
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> name() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty(value="avatar")
    public Optional<String> avatar() {
        return Optional.ofNullable(this.avatar);
    }

    @Override
    @JsonProperty(value="token")
    public Possible<String> token() {
        return this.token_absent ? Possible.absent() : Possible.of((Object)this.token_value);
    }

    public final ImmutableWebhookData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableWebhookData(this, newValue, this.type, this.guildId(), this.channelId, this.user(), this.name, this.avatar, this.token());
    }

    public final ImmutableWebhookData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableWebhookData(this, this.id, value, this.guildId(), this.channelId, this.user(), this.name, this.avatar, this.token());
    }

    public ImmutableWebhookData withGuildId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookData(this, this.id, this.type, newValue, this.channelId, this.user(), this.name, this.avatar, this.token());
    }

    public ImmutableWebhookData withGuildId(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableWebhookData(this, this.id, this.type, (Possible<String>)newValue, this.channelId, this.user(), this.name, this.avatar, this.token());
    }

    public final ImmutableWebhookData withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), newValue, this.user(), this.name, this.avatar, this.token());
    }

    public ImmutableWebhookData withUser(Possible<UserData> value) {
        Possible<UserData> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, newValue, this.name, this.avatar, this.token());
    }

    public ImmutableWebhookData withUser(UserData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, (Possible<UserData>)newValue, this.name, this.avatar, this.token());
    }

    public final ImmutableWebhookData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, this.user(), newValue, this.avatar, this.token());
    }

    public final ImmutableWebhookData withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, this.user(), value, this.avatar, this.token());
    }

    public final ImmutableWebhookData withAvatar(String value) {
        String newValue = Objects.requireNonNull(value, "avatar");
        if (Objects.equals(this.avatar, newValue)) {
            return this;
        }
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, this.user(), this.name, newValue, this.token());
    }

    public final ImmutableWebhookData withAvatar(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.avatar, value)) {
            return this;
        }
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, this.user(), this.name, value, this.token());
    }

    public ImmutableWebhookData withToken(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, this.user(), this.name, this.avatar, newValue);
    }

    public ImmutableWebhookData withToken(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableWebhookData(this, this.id, this.type, this.guildId(), this.channelId, this.user(), this.name, this.avatar, (Possible<String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWebhookData && this.equalTo((ImmutableWebhookData)another);
    }

    private boolean equalTo(ImmutableWebhookData another) {
        return this.id.equals(another.id) && this.type == another.type && this.guildId().equals(another.guildId()) && this.channelId.equals(another.channelId) && this.user().equals(another.user()) && Objects.equals(this.name, another.name) && Objects.equals(this.avatar, another.avatar) && this.token().equals(another.token());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.type;
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.user().hashCode();
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.avatar);
        h += (h << 5) + this.token().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("WebhookData{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("guildId=").append(this.guildId().toString());
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("user=").append(this.user().toString());
        if (this.name != null) {
            builder.append(", ");
            builder.append("name=").append(this.name);
        }
        if (this.avatar != null) {
            builder.append(", ");
            builder.append("avatar=").append(this.avatar);
        }
        builder.append(", ");
        builder.append("token=").append(this.token().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWebhookData fromJson(Json json) {
        Builder builder = ImmutableWebhookData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.avatar != null) {
            builder.avatar(json.avatar);
        }
        if (json.token != null) {
            builder.token(json.token);
        }
        return builder.build();
    }

    public static ImmutableWebhookData of(String id, int type, Possible<String> guildId, String channelId, Possible<UserData> user, Optional<String> name, Optional<String> avatar, Possible<String> token) {
        return new ImmutableWebhookData(id, type, guildId, channelId, user, name, avatar, token);
    }

    public static ImmutableWebhookData copyOf(WebhookData instance) {
        if (instance instanceof ImmutableWebhookData) {
            return (ImmutableWebhookData)instance;
        }
        return ImmutableWebhookData.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public String guildIdOrElse(String defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isUserPresent() {
        return !this.user_absent;
    }

    public UserData userOrElse(UserData defaultValue) {
        return !this.user_absent ? this.user_value : defaultValue;
    }

    public boolean isTokenPresent() {
        return !this.token_absent;
    }

    public String tokenOrElse(String defaultValue) {
        return !this.token_absent ? this.token_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private long initBits = 7L;
        private Possible<String> guildId_possible = Possible.absent();
        private Possible<UserData> user_possible = Possible.absent();
        private Possible<String> token_possible = Possible.absent();
        private String id;
        private int type;
        private String channelId;
        private String name;
        private String avatar;

        private Builder() {
        }

        public final Builder from(WebhookData instance) {
            Optional<String> avatarOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.type(instance.type());
            this.guildId(instance.guildId());
            this.channelId(instance.channelId());
            this.user(instance.user());
            Optional<String> nameOptional = instance.name();
            if (nameOptional.isPresent()) {
                this.name(nameOptional);
            }
            if ((avatarOptional = instance.avatar()).isPresent()) {
                this.avatar(avatarOptional);
            }
            this.token(instance.token());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<String> value) {
            this.guildId_possible = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public final Builder channelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="user")
        public Builder user(Possible<UserData> value) {
            this.user_possible = value;
            return this;
        }

        public Builder user(UserData value) {
            this.user_possible = Possible.of((Object)value);
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder avatar(String avatar) {
            this.avatar = Objects.requireNonNull(avatar, "avatar");
            return this;
        }

        @JsonProperty(value="avatar")
        public final Builder avatar(Optional<String> avatar) {
            this.avatar = avatar.orElse(null);
            return this;
        }

        @JsonProperty(value="token")
        public Builder token(Possible<String> value) {
            this.token_possible = value;
            return this;
        }

        public Builder token(String value) {
            this.token_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableWebhookData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWebhookData(null, this.id, this.type, this.guildId_build(), this.channelId, this.user_build(), this.name, this.avatar, this.token_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("channelId");
            }
            return "Cannot build WebhookData, some of required attributes are not set " + attributes;
        }

        private Possible<String> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<UserData> user_build() {
            return this.user_possible;
        }

        private Possible<String> token_build() {
            return this.token_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WebhookData", generator="Immutables")
    static final class Json
    implements WebhookData {
        String id;
        int type;
        boolean typeIsSet;
        Possible<String> guildId;
        String channelId;
        Possible<UserData> user;
        Optional<String> name = Optional.empty();
        Optional<String> avatar = Optional.empty();
        Possible<String> token;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<String> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="user")
        public void setUser(Possible<UserData> user) {
            this.user = user;
        }

        @JsonProperty(value="name")
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty(value="avatar")
        public void setAvatar(Optional<String> avatar) {
            this.avatar = avatar;
        }

        @JsonProperty(value="token")
        public void setToken(Possible<String> token) {
            this.token = token;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<UserData> user() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> avatar() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> token() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="WebhookData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookData, attribute initializers form cycle " + attributes;
        }
    }
}

