/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.AttachmentData;
import discord4j.discordjson.json.ChannelMentionData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.MessageActivityData;
import discord4j.discordjson.json.MessageApplicationData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.json.ReactionData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.UserWithMemberData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="MessageData", generator="Immutables")
public final class ImmutableMessageData
implements MessageData {
    private final String id;
    private final String channelId;
    private final String guildId_value;
    private final boolean guildId_absent;
    private final UserData author;
    private final PartialMemberData member_value;
    private final boolean member_absent;
    private final String content;
    private final String timestamp;
    private final String editedTimestamp;
    private final boolean tts;
    private final boolean mentionEveryone;
    private final List<UserWithMemberData> mentions;
    private final List<String> mentionRoles;
    private final List<ChannelMentionData> mentionChannels_value;
    private final boolean mentionChannels_absent;
    private final List<AttachmentData> attachments;
    private final List<EmbedData> embeds;
    private final List<ReactionData> reactions_value;
    private final boolean reactions_absent;
    private final Object nonce_value;
    private final boolean nonce_absent;
    private final boolean pinned;
    private final String webhookId_value;
    private final boolean webhookId_absent;
    private final int type;
    private final MessageActivityData activity_value;
    private final boolean activity_absent;
    private final MessageApplicationData application_value;
    private final boolean application_absent;
    private final MessageReferenceData messageReference_value;
    private final boolean messageReference_absent;
    private final Integer flags_value;
    private final boolean flags_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageData(String id, String channelId, Possible<String> guildId, UserData author, Possible<PartialMemberData> member, String content, String timestamp, Optional<String> editedTimestamp, boolean tts, boolean mentionEveryone, Iterable<? extends UserWithMemberData> mentions, Iterable<String> mentionRoles, Possible<List<ChannelMentionData>> mentionChannels, Iterable<? extends AttachmentData> attachments, Iterable<? extends EmbedData> embeds, Possible<List<ReactionData>> reactions, Possible<Object> nonce, boolean pinned, Possible<String> webhookId, int type, Possible<MessageActivityData> activity, Possible<MessageApplicationData> application, Possible<MessageReferenceData> messageReference, Possible<Integer> flags) {
        this.id = Objects.requireNonNull(id, "id");
        this.channelId = Objects.requireNonNull(channelId, "channelId");
        Possible<String> guildId$impl = guildId;
        this.author = Objects.requireNonNull(author, "author");
        Possible<PartialMemberData> member$impl = member;
        this.content = Objects.requireNonNull(content, "content");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
        this.editedTimestamp = editedTimestamp.orElse(null);
        this.tts = tts;
        this.mentionEveryone = mentionEveryone;
        this.mentions = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(mentions, true, false));
        this.mentionRoles = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(mentionRoles, true, false));
        Possible<List<ChannelMentionData>> mentionChannels$impl = mentionChannels;
        this.attachments = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(attachments, true, false));
        this.embeds = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(embeds, true, false));
        Possible<List<ReactionData>> reactions$impl = reactions;
        Possible<Object> nonce$impl = nonce;
        this.pinned = pinned;
        Possible<String> webhookId$impl = webhookId;
        this.type = type;
        Possible<MessageActivityData> activity$impl = activity;
        Possible<MessageApplicationData> application$impl = application;
        Possible<MessageReferenceData> messageReference$impl = messageReference;
        Possible<Integer> flags$impl = flags;
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.mentionChannels_value = mentionChannels$impl.toOptional().orElse(null);
        this.mentionChannels_absent = mentionChannels$impl.isAbsent();
        this.reactions_value = reactions$impl.toOptional().orElse(null);
        this.reactions_absent = reactions$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.webhookId_value = webhookId$impl.toOptional().orElse(null);
        this.webhookId_absent = webhookId$impl.isAbsent();
        this.activity_value = activity$impl.toOptional().orElse(null);
        this.activity_absent = activity$impl.isAbsent();
        this.application_value = application$impl.toOptional().orElse(null);
        this.application_absent = application$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableMessageData(ImmutableMessageData original, String id, String channelId, Possible<String> guildId, UserData author, Possible<PartialMemberData> member, String content, String timestamp, String editedTimestamp, boolean tts, boolean mentionEveryone, List<UserWithMemberData> mentions, List<String> mentionRoles, Possible<List<ChannelMentionData>> mentionChannels, List<AttachmentData> attachments, List<EmbedData> embeds, Possible<List<ReactionData>> reactions, Possible<Object> nonce, boolean pinned, Possible<String> webhookId, int type, Possible<MessageActivityData> activity, Possible<MessageApplicationData> application, Possible<MessageReferenceData> messageReference, Possible<Integer> flags) {
        this.id = id;
        this.channelId = channelId;
        Possible<String> guildId$impl = guildId;
        this.author = author;
        Possible<PartialMemberData> member$impl = member;
        this.content = content;
        this.timestamp = timestamp;
        this.editedTimestamp = editedTimestamp;
        this.tts = tts;
        this.mentionEveryone = mentionEveryone;
        this.mentions = mentions;
        this.mentionRoles = mentionRoles;
        Possible<List<ChannelMentionData>> mentionChannels$impl = mentionChannels;
        this.attachments = attachments;
        this.embeds = embeds;
        Possible<List<ReactionData>> reactions$impl = reactions;
        Possible<Object> nonce$impl = nonce;
        this.pinned = pinned;
        Possible<String> webhookId$impl = webhookId;
        this.type = type;
        Possible<MessageActivityData> activity$impl = activity;
        Possible<MessageApplicationData> application$impl = application;
        Possible<MessageReferenceData> messageReference$impl = messageReference;
        Possible<Integer> flags$impl = flags;
        this.guildId_value = guildId$impl.toOptional().orElse(null);
        this.guildId_absent = guildId$impl.isAbsent();
        this.member_value = member$impl.toOptional().orElse(null);
        this.member_absent = member$impl.isAbsent();
        this.mentionChannels_value = mentionChannels$impl.toOptional().orElse(null);
        this.mentionChannels_absent = mentionChannels$impl.isAbsent();
        this.reactions_value = reactions$impl.toOptional().orElse(null);
        this.reactions_absent = reactions$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.webhookId_value = webhookId$impl.toOptional().orElse(null);
        this.webhookId_absent = webhookId$impl.isAbsent();
        this.activity_value = activity$impl.toOptional().orElse(null);
        this.activity_absent = activity$impl.isAbsent();
        this.application_value = application$impl.toOptional().orElse(null);
        this.application_absent = application$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.flags_value = flags$impl.toOptional().orElse(null);
        this.flags_absent = flags$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="channel_id")
    public String channelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<String> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)this.guildId_value);
    }

    @Override
    @JsonProperty(value="author")
    public UserData author() {
        return this.author;
    }

    @Override
    @JsonProperty(value="member")
    public Possible<PartialMemberData> member() {
        return this.member_absent ? Possible.absent() : Possible.of((Object)this.member_value);
    }

    @Override
    @JsonProperty(value="content")
    public String content() {
        return this.content;
    }

    @Override
    @JsonProperty(value="timestamp")
    public String timestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="edited_timestamp")
    public Optional<String> editedTimestamp() {
        return Optional.ofNullable(this.editedTimestamp);
    }

    @Override
    @JsonProperty(value="tts")
    public boolean tts() {
        return this.tts;
    }

    @Override
    @JsonProperty(value="mention_everyone")
    public boolean mentionEveryone() {
        return this.mentionEveryone;
    }

    @Override
    @JsonProperty(value="mentions")
    public List<UserWithMemberData> mentions() {
        return this.mentions;
    }

    @Override
    @JsonProperty(value="mention_roles")
    public List<String> mentionRoles() {
        return this.mentionRoles;
    }

    @Override
    @JsonProperty(value="mention_channels")
    public Possible<List<ChannelMentionData>> mentionChannels() {
        return this.mentionChannels_absent ? Possible.absent() : Possible.of(this.mentionChannels_value);
    }

    @Override
    @JsonProperty(value="attachments")
    public List<AttachmentData> attachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty(value="embeds")
    public List<EmbedData> embeds() {
        return this.embeds;
    }

    @Override
    @JsonProperty(value="reactions")
    public Possible<List<ReactionData>> reactions() {
        return this.reactions_absent ? Possible.absent() : Possible.of(this.reactions_value);
    }

    @Override
    @JsonProperty(value="nonce")
    public Possible<Object> nonce() {
        return this.nonce_absent ? Possible.absent() : Possible.of((Object)this.nonce_value);
    }

    @Override
    @JsonProperty(value="pinned")
    public boolean pinned() {
        return this.pinned;
    }

    @Override
    @JsonProperty(value="webhook_id")
    public Possible<String> webhookId() {
        return this.webhookId_absent ? Possible.absent() : Possible.of((Object)this.webhookId_value);
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="activity")
    public Possible<MessageActivityData> activity() {
        return this.activity_absent ? Possible.absent() : Possible.of((Object)this.activity_value);
    }

    @Override
    @JsonProperty(value="application")
    public Possible<MessageApplicationData> application() {
        return this.application_absent ? Possible.absent() : Possible.of((Object)this.application_value);
    }

    @Override
    @JsonProperty(value="message_reference")
    public Possible<MessageReferenceData> messageReference() {
        return this.messageReference_absent ? Possible.absent() : Possible.of((Object)this.messageReference_value);
    }

    @Override
    @JsonProperty(value="flags")
    public Possible<Integer> flags() {
        return this.flags_absent ? Possible.absent() : Possible.of((Object)this.flags_value);
    }

    public final ImmutableMessageData withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageData(this, newValue, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, newValue, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withGuildId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, newValue, this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withGuildId(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, (Possible<String>)newValue, this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withAuthor(UserData value) {
        if (this.author == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "author");
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), newValue, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withMember(Possible<PartialMemberData> value) {
        Possible<PartialMemberData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, newValue, this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withMember(PartialMemberData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, (Possible<PartialMemberData>)newValue, this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), newValue, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withTimestamp(String value) {
        String newValue = Objects.requireNonNull(value, "timestamp");
        if (this.timestamp.equals(newValue)) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, newValue, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withEditedTimestamp(String value) {
        String newValue = Objects.requireNonNull(value, "editedTimestamp");
        if (Objects.equals(this.editedTimestamp, newValue)) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, newValue, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withEditedTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.editedTimestamp, value)) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, value, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withTts(boolean value) {
        if (this.tts == value) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, value, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withMentionEveryone(boolean value) {
        if (this.mentionEveryone == value) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, value, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withMentions(UserWithMemberData ... elements) {
        List<UserWithMemberData> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, newValue, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withMentions(Iterable<? extends UserWithMemberData> elements) {
        if (this.mentions == elements) {
            return this;
        }
        List<UserWithMemberData> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(elements, true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, newValue, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withMentionRoles(String ... elements) {
        List<String> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, newValue, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withMentionRoles(Iterable<String> elements) {
        if (this.mentionRoles == elements) {
            return this;
        }
        List<String> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(elements, true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, newValue, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withMentionChannels(Possible<List<ChannelMentionData>> value) {
        Possible<List<ChannelMentionData>> newValue = value;
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, newValue, this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withAttachments(AttachmentData ... elements) {
        List<AttachmentData> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), newValue, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withAttachments(Iterable<? extends AttachmentData> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<AttachmentData> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(elements, true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), newValue, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withEmbeds(EmbedData ... elements) {
        List<EmbedData> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, newValue, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withEmbeds(Iterable<? extends EmbedData> elements) {
        if (this.embeds == elements) {
            return this;
        }
        List<EmbedData> newValue = ImmutableMessageData.createUnmodifiableList(false, ImmutableMessageData.createSafeList(elements, true, false));
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, newValue, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withReactions(Possible<List<ReactionData>> value) {
        Possible<List<ReactionData>> newValue = value;
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, newValue, this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withNonce(Possible<Object> value) {
        Possible<Object> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), newValue, this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withNonce(Object value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), (Possible<Object>)newValue, this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withPinned(boolean value) {
        if (this.pinned == value) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), value, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withWebhookId(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, newValue, this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withWebhookId(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, (Possible<String>)newValue, this.type, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public final ImmutableMessageData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), value, this.activity(), this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withActivity(Possible<MessageActivityData> value) {
        Possible<MessageActivityData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, newValue, this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withActivity(MessageActivityData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, (Possible<MessageActivityData>)newValue, this.application(), this.messageReference(), this.flags());
    }

    public ImmutableMessageData withApplication(Possible<MessageApplicationData> value) {
        Possible<MessageApplicationData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), newValue, this.messageReference(), this.flags());
    }

    public ImmutableMessageData withApplication(MessageApplicationData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), (Possible<MessageApplicationData>)newValue, this.messageReference(), this.flags());
    }

    public ImmutableMessageData withMessageReference(Possible<MessageReferenceData> value) {
        Possible<MessageReferenceData> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), newValue, this.flags());
    }

    public ImmutableMessageData withMessageReference(MessageReferenceData value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), (Possible<MessageReferenceData>)newValue, this.flags());
    }

    public ImmutableMessageData withFlags(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), newValue);
    }

    public ImmutableMessageData withFlags(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageData(this, this.id, this.channelId, this.guildId(), this.author, this.member(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, this.mentions, this.mentionRoles, this.mentionChannels(), this.attachments, this.embeds, this.reactions(), this.nonce(), this.pinned, this.webhookId(), this.type, this.activity(), this.application(), this.messageReference(), (Possible<Integer>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageData && this.equalTo((ImmutableMessageData)another);
    }

    private boolean equalTo(ImmutableMessageData another) {
        return this.id.equals(another.id) && this.channelId.equals(another.channelId) && this.guildId().equals(another.guildId()) && this.author.equals(another.author) && this.member().equals(another.member()) && this.content.equals(another.content) && this.timestamp.equals(another.timestamp) && Objects.equals(this.editedTimestamp, another.editedTimestamp) && this.tts == another.tts && this.mentionEveryone == another.mentionEveryone && this.mentions.equals(another.mentions) && this.mentionRoles.equals(another.mentionRoles) && Objects.equals(this.mentionChannels_value, another.mentionChannels_value) && this.attachments.equals(another.attachments) && this.embeds.equals(another.embeds) && Objects.equals(this.reactions_value, another.reactions_value) && this.nonce().equals(another.nonce()) && this.pinned == another.pinned && this.webhookId().equals(another.webhookId()) && this.type == another.type && this.activity().equals(another.activity()) && this.application().equals(another.application()) && this.messageReference().equals(another.messageReference()) && this.flags().equals(another.flags());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.author.hashCode();
        h += (h << 5) + this.member().hashCode();
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.timestamp.hashCode();
        h += (h << 5) + Objects.hashCode(this.editedTimestamp);
        h += (h << 5) + Boolean.hashCode(this.tts);
        h += (h << 5) + Boolean.hashCode(this.mentionEveryone);
        h += (h << 5) + this.mentions.hashCode();
        h += (h << 5) + this.mentionRoles.hashCode();
        h += (h << 5) + Objects.hashCode(this.mentionChannels_value);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.embeds.hashCode();
        h += (h << 5) + Objects.hashCode(this.reactions_value);
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + Boolean.hashCode(this.pinned);
        h += (h << 5) + this.webhookId().hashCode();
        h += (h << 5) + this.type;
        h += (h << 5) + this.activity().hashCode();
        h += (h << 5) + this.application().hashCode();
        h += (h << 5) + this.messageReference().hashCode();
        h += (h << 5) + this.flags().hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MessageData{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("guildId=").append(this.guildId().toString());
        builder.append(", ");
        builder.append("author=").append(this.author);
        builder.append(", ");
        builder.append("member=").append(this.member().toString());
        builder.append(", ");
        builder.append("content=").append(this.content);
        builder.append(", ");
        builder.append("timestamp=").append(this.timestamp);
        if (this.editedTimestamp != null) {
            builder.append(", ");
            builder.append("editedTimestamp=").append(this.editedTimestamp);
        }
        builder.append(", ");
        builder.append("tts=").append(this.tts);
        builder.append(", ");
        builder.append("mentionEveryone=").append(this.mentionEveryone);
        builder.append(", ");
        builder.append("mentions=").append(this.mentions);
        builder.append(", ");
        builder.append("mentionRoles=").append(this.mentionRoles);
        builder.append(", ");
        builder.append("mentionChannels=").append(Objects.toString(this.mentionChannels_value));
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("embeds=").append(this.embeds);
        builder.append(", ");
        builder.append("reactions=").append(Objects.toString(this.reactions_value));
        builder.append(", ");
        builder.append("nonce=").append(this.nonce().toString());
        builder.append(", ");
        builder.append("pinned=").append(this.pinned);
        builder.append(", ");
        builder.append("webhookId=").append(this.webhookId().toString());
        builder.append(", ");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("activity=").append(this.activity().toString());
        builder.append(", ");
        builder.append("application=").append(this.application().toString());
        builder.append(", ");
        builder.append("messageReference=").append(this.messageReference().toString());
        builder.append(", ");
        builder.append("flags=").append(this.flags().toString());
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageData fromJson(Json json) {
        Builder builder = ImmutableMessageData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.author != null) {
            builder.author(json.author);
        }
        if (json.member != null) {
            builder.member(json.member);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        if (json.editedTimestamp != null) {
            builder.editedTimestamp(json.editedTimestamp);
        }
        if (json.ttsIsSet) {
            builder.tts(json.tts);
        }
        if (json.mentionEveryoneIsSet) {
            builder.mentionEveryone(json.mentionEveryone);
        }
        if (json.mentions != null) {
            builder.addAllMentions(json.mentions);
        }
        if (json.mentionRoles != null) {
            builder.addAllMentionRoles(json.mentionRoles);
        }
        if (json.mentionChannels != null) {
            builder.mentionChannels(json.mentionChannels);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.embeds != null) {
            builder.addAllEmbeds(json.embeds);
        }
        if (json.reactions != null) {
            builder.reactions(json.reactions);
        }
        if (json.nonce != null) {
            builder.nonce(json.nonce);
        }
        if (json.pinnedIsSet) {
            builder.pinned(json.pinned);
        }
        if (json.webhookId != null) {
            builder.webhookId(json.webhookId);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.activity != null) {
            builder.activity(json.activity);
        }
        if (json.application != null) {
            builder.application(json.application);
        }
        if (json.messageReference != null) {
            builder.messageReference(json.messageReference);
        }
        if (json.flags != null) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutableMessageData of(String id, String channelId, Possible<String> guildId, UserData author, Possible<PartialMemberData> member, String content, String timestamp, Optional<String> editedTimestamp, boolean tts, boolean mentionEveryone, List<UserWithMemberData> mentions, List<String> mentionRoles, Possible<List<ChannelMentionData>> mentionChannels, List<AttachmentData> attachments, List<EmbedData> embeds, Possible<List<ReactionData>> reactions, Possible<Object> nonce, boolean pinned, Possible<String> webhookId, int type, Possible<MessageActivityData> activity, Possible<MessageApplicationData> application, Possible<MessageReferenceData> messageReference, Possible<Integer> flags) {
        return ImmutableMessageData.of(id, channelId, guildId, author, member, content, timestamp, editedTimestamp, tts, mentionEveryone, mentions, mentionRoles, mentionChannels, attachments, embeds, reactions, nonce, pinned, webhookId, type, activity, application, messageReference, flags);
    }

    public static ImmutableMessageData of(String id, String channelId, Possible<String> guildId, UserData author, Possible<PartialMemberData> member, String content, String timestamp, Optional<String> editedTimestamp, boolean tts, boolean mentionEveryone, Iterable<? extends UserWithMemberData> mentions, Iterable<String> mentionRoles, Possible<List<ChannelMentionData>> mentionChannels, Iterable<? extends AttachmentData> attachments, Iterable<? extends EmbedData> embeds, Possible<List<ReactionData>> reactions, Possible<Object> nonce, boolean pinned, Possible<String> webhookId, int type, Possible<MessageActivityData> activity, Possible<MessageApplicationData> application, Possible<MessageReferenceData> messageReference, Possible<Integer> flags) {
        return new ImmutableMessageData(id, channelId, guildId, author, member, content, timestamp, editedTimestamp, tts, mentionEveryone, mentions, mentionRoles, mentionChannels, attachments, embeds, reactions, nonce, pinned, webhookId, type, activity, application, messageReference, flags);
    }

    public static ImmutableMessageData copyOf(MessageData instance) {
        if (instance instanceof ImmutableMessageData) {
            return (ImmutableMessageData)instance;
        }
        return ImmutableMessageData.builder().from(instance).build();
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public String guildIdOrElse(String defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isMemberPresent() {
        return !this.member_absent;
    }

    public PartialMemberData memberOrElse(PartialMemberData defaultValue) {
        return !this.member_absent ? this.member_value : defaultValue;
    }

    public boolean isMentionChannelsPresent() {
        return !this.mentionChannels_absent;
    }

    public List<ChannelMentionData> mentionChannelsOrElse(List<ChannelMentionData> defaultValue) {
        return !this.mentionChannels_absent ? this.mentionChannels_value : defaultValue;
    }

    public boolean isReactionsPresent() {
        return !this.reactions_absent;
    }

    public List<ReactionData> reactionsOrElse(List<ReactionData> defaultValue) {
        return !this.reactions_absent ? this.reactions_value : defaultValue;
    }

    public boolean isNoncePresent() {
        return !this.nonce_absent;
    }

    public Object nonceOrElse(Object defaultValue) {
        return !this.nonce_absent ? this.nonce_value : defaultValue;
    }

    public boolean isWebhookIdPresent() {
        return !this.webhookId_absent;
    }

    public String webhookIdOrElse(String defaultValue) {
        return !this.webhookId_absent ? this.webhookId_value : defaultValue;
    }

    public boolean isActivityPresent() {
        return !this.activity_absent;
    }

    public MessageActivityData activityOrElse(MessageActivityData defaultValue) {
        return !this.activity_absent ? this.activity_value : defaultValue;
    }

    public boolean isApplicationPresent() {
        return !this.application_absent;
    }

    public MessageApplicationData applicationOrElse(MessageApplicationData defaultValue) {
        return !this.application_absent ? this.application_value : defaultValue;
    }

    public boolean isMessageReferencePresent() {
        return !this.messageReference_absent;
    }

    public MessageReferenceData messageReferenceOrElse(MessageReferenceData defaultValue) {
        return !this.messageReference_absent ? this.messageReference_value : defaultValue;
    }

    public boolean isFlagsPresent() {
        return !this.flags_absent;
    }

    public Integer flagsOrElse(Integer defaultValue) {
        return !this.flags_absent ? this.flags_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MessageData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_AUTHOR = 4L;
        private static final long INIT_BIT_CONTENT = 8L;
        private static final long INIT_BIT_TIMESTAMP = 16L;
        private static final long INIT_BIT_TTS = 32L;
        private static final long INIT_BIT_MENTION_EVERYONE = 64L;
        private static final long INIT_BIT_PINNED = 128L;
        private static final long INIT_BIT_TYPE = 256L;
        private long initBits = 511L;
        private Possible<String> guildId_possible = Possible.absent();
        private Possible<PartialMemberData> member_possible = Possible.absent();
        private List<ChannelMentionData> mentionChannels_list = null;
        private List<ReactionData> reactions_list = null;
        private Possible<Object> nonce_possible = Possible.absent();
        private Possible<String> webhookId_possible = Possible.absent();
        private Possible<MessageActivityData> activity_possible = Possible.absent();
        private Possible<MessageApplicationData> application_possible = Possible.absent();
        private Possible<MessageReferenceData> messageReference_possible = Possible.absent();
        private Possible<Integer> flags_possible = Possible.absent();
        private String id;
        private String channelId;
        private UserData author;
        private String content;
        private String timestamp;
        private String editedTimestamp;
        private boolean tts;
        private boolean mentionEveryone;
        private List<UserWithMemberData> mentions = new ArrayList<UserWithMemberData>();
        private List<String> mentionRoles = new ArrayList<String>();
        private List<AttachmentData> attachments = new ArrayList<AttachmentData>();
        private List<EmbedData> embeds = new ArrayList<EmbedData>();
        private boolean pinned;
        private int type;

        private Builder() {
        }

        public final Builder from(MessageData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.channelId(instance.channelId());
            this.guildId(instance.guildId());
            this.author(instance.author());
            this.member(instance.member());
            this.content(instance.content());
            this.timestamp(instance.timestamp());
            Optional<String> editedTimestampOptional = instance.editedTimestamp();
            if (editedTimestampOptional.isPresent()) {
                this.editedTimestamp(editedTimestampOptional);
            }
            this.tts(instance.tts());
            this.mentionEveryone(instance.mentionEveryone());
            this.addAllMentions(instance.mentions());
            this.addAllMentionRoles(instance.mentionRoles());
            this.mentionChannels(instance.mentionChannels());
            this.addAllAttachments(instance.attachments());
            this.addAllEmbeds(instance.embeds());
            this.reactions(instance.reactions());
            this.nonce(instance.nonce());
            this.pinned(instance.pinned());
            this.webhookId(instance.webhookId());
            this.type(instance.type());
            this.activity(instance.activity());
            this.application(instance.application());
            this.messageReference(instance.messageReference());
            this.flags(instance.flags());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel_id")
        public final Builder channelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<String> value) {
            this.guildId_possible = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="author")
        public final Builder author(UserData author) {
            this.author = Objects.requireNonNull(author, "author");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="member")
        public Builder member(Possible<PartialMemberData> value) {
            this.member_possible = value;
            return this;
        }

        public Builder member(PartialMemberData value) {
            this.member_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="content")
        public final Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="timestamp")
        public final Builder timestamp(String timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder editedTimestamp(String editedTimestamp) {
            this.editedTimestamp = Objects.requireNonNull(editedTimestamp, "editedTimestamp");
            return this;
        }

        @JsonProperty(value="edited_timestamp")
        public final Builder editedTimestamp(Optional<String> editedTimestamp) {
            this.editedTimestamp = editedTimestamp.orElse(null);
            return this;
        }

        @JsonProperty(value="tts")
        public final Builder tts(boolean tts) {
            this.tts = tts;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="mention_everyone")
        public final Builder mentionEveryone(boolean mentionEveryone) {
            this.mentionEveryone = mentionEveryone;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder addMention(UserWithMemberData element) {
            this.mentions.add(Objects.requireNonNull(element, "mentions element"));
            return this;
        }

        public final Builder addMentions(UserWithMemberData ... elements) {
            for (UserWithMemberData element : elements) {
                this.mentions.add(Objects.requireNonNull(element, "mentions element"));
            }
            return this;
        }

        @JsonProperty(value="mentions")
        public final Builder mentions(Iterable<? extends UserWithMemberData> elements) {
            this.mentions.clear();
            return this.addAllMentions(elements);
        }

        public final Builder addAllMentions(Iterable<? extends UserWithMemberData> elements) {
            for (UserWithMemberData userWithMemberData : elements) {
                this.mentions.add(Objects.requireNonNull(userWithMemberData, "mentions element"));
            }
            return this;
        }

        public final Builder addMentionRole(String element) {
            this.mentionRoles.add(Objects.requireNonNull(element, "mentionRoles element"));
            return this;
        }

        public final Builder addMentionRoles(String ... elements) {
            for (String element : elements) {
                this.mentionRoles.add(Objects.requireNonNull(element, "mentionRoles element"));
            }
            return this;
        }

        @JsonProperty(value="mention_roles")
        public final Builder mentionRoles(Iterable<String> elements) {
            this.mentionRoles.clear();
            return this.addAllMentionRoles(elements);
        }

        public final Builder addAllMentionRoles(Iterable<String> elements) {
            for (String element : elements) {
                this.mentionRoles.add(Objects.requireNonNull(element, "mentionRoles element"));
            }
            return this;
        }

        public Builder addMentionChannel(ChannelMentionData element) {
            this.mentionChannels_getOrCreate().add(element);
            return this;
        }

        public Builder addAllMentionChannels(List<ChannelMentionData> elements) {
            this.mentionChannels_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="mention_channels")
        public Builder mentionChannels(Possible<List<ChannelMentionData>> elements) {
            this.mentionChannels_list = null;
            elements.toOptional().ifPresent(e -> this.mentionChannels_getOrCreate().addAll((Collection<ChannelMentionData>)e));
            return this;
        }

        public Builder mentionChannels(List<ChannelMentionData> elements) {
            this.mentionChannels_list = new ArrayList<ChannelMentionData>(elements);
            return this;
        }

        public final Builder addAttachment(AttachmentData element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(AttachmentData ... elements) {
            for (AttachmentData element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        @JsonProperty(value="attachments")
        public final Builder attachments(Iterable<? extends AttachmentData> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends AttachmentData> elements) {
            for (AttachmentData attachmentData : elements) {
                this.attachments.add(Objects.requireNonNull(attachmentData, "attachments element"));
            }
            return this;
        }

        public final Builder addEmbed(EmbedData element) {
            this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            return this;
        }

        public final Builder addEmbeds(EmbedData ... elements) {
            for (EmbedData element : elements) {
                this.embeds.add(Objects.requireNonNull(element, "embeds element"));
            }
            return this;
        }

        @JsonProperty(value="embeds")
        public final Builder embeds(Iterable<? extends EmbedData> elements) {
            this.embeds.clear();
            return this.addAllEmbeds(elements);
        }

        public final Builder addAllEmbeds(Iterable<? extends EmbedData> elements) {
            for (EmbedData embedData : elements) {
                this.embeds.add(Objects.requireNonNull(embedData, "embeds element"));
            }
            return this;
        }

        public Builder addReaction(ReactionData element) {
            this.reactions_getOrCreate().add(element);
            return this;
        }

        public Builder addAllReactions(List<ReactionData> elements) {
            this.reactions_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="reactions")
        public Builder reactions(Possible<List<ReactionData>> elements) {
            this.reactions_list = null;
            elements.toOptional().ifPresent(e -> this.reactions_getOrCreate().addAll((Collection<ReactionData>)e));
            return this;
        }

        public Builder reactions(List<ReactionData> elements) {
            this.reactions_list = new ArrayList<ReactionData>(elements);
            return this;
        }

        @JsonProperty(value="nonce")
        public Builder nonce(Possible<Object> value) {
            this.nonce_possible = value;
            return this;
        }

        public Builder nonce(Object value) {
            this.nonce_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="pinned")
        public final Builder pinned(boolean pinned) {
            this.pinned = pinned;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="webhook_id")
        public Builder webhookId(Possible<String> value) {
            this.webhookId_possible = value;
            return this;
        }

        public Builder webhookId(String value) {
            this.webhookId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="activity")
        public Builder activity(Possible<MessageActivityData> value) {
            this.activity_possible = value;
            return this;
        }

        public Builder activity(MessageActivityData value) {
            this.activity_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="application")
        public Builder application(Possible<MessageApplicationData> value) {
            this.application_possible = value;
            return this;
        }

        public Builder application(MessageApplicationData value) {
            this.application_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="message_reference")
        public Builder messageReference(Possible<MessageReferenceData> value) {
            this.messageReference_possible = value;
            return this;
        }

        public Builder messageReference(MessageReferenceData value) {
            this.messageReference_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="flags")
        public Builder flags(Possible<Integer> value) {
            this.flags_possible = value;
            return this;
        }

        public Builder flags(Integer value) {
            this.flags_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableMessageData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageData(null, this.id, this.channelId, this.guildId_build(), this.author, this.member_build(), this.content, this.timestamp, this.editedTimestamp, this.tts, this.mentionEveryone, ImmutableMessageData.createUnmodifiableList(true, this.mentions), ImmutableMessageData.createUnmodifiableList(true, this.mentionRoles), this.mentionChannels_build(), ImmutableMessageData.createUnmodifiableList(true, this.attachments), ImmutableMessageData.createUnmodifiableList(true, this.embeds), this.reactions_build(), this.nonce_build(), this.pinned, this.webhookId_build(), this.type, this.activity_build(), this.application_build(), this.messageReference_build(), this.flags_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("channelId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("author");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("tts");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("mentionEveryone");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("pinned");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build MessageData, some of required attributes are not set " + attributes;
        }

        private Possible<String> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<PartialMemberData> member_build() {
            return this.member_possible;
        }

        private Possible<List<ChannelMentionData>> mentionChannels_build() {
            return this.mentionChannels_list == null ? Possible.absent() : Possible.of(this.mentionChannels_list);
        }

        private List<ChannelMentionData> mentionChannels_getOrCreate() {
            if (this.mentionChannels_list == null) {
                this.mentionChannels_list = new ArrayList<ChannelMentionData>();
            }
            return this.mentionChannels_list;
        }

        private Possible<List<ReactionData>> reactions_build() {
            return this.reactions_list == null ? Possible.absent() : Possible.of(this.reactions_list);
        }

        private List<ReactionData> reactions_getOrCreate() {
            if (this.reactions_list == null) {
                this.reactions_list = new ArrayList<ReactionData>();
            }
            return this.reactions_list;
        }

        private Possible<Object> nonce_build() {
            return this.nonce_possible;
        }

        private Possible<String> webhookId_build() {
            return this.webhookId_possible;
        }

        private Possible<MessageActivityData> activity_build() {
            return this.activity_possible;
        }

        private Possible<MessageApplicationData> application_build() {
            return this.application_possible;
        }

        private Possible<MessageReferenceData> messageReference_build() {
            return this.messageReference_possible;
        }

        private Possible<Integer> flags_build() {
            return this.flags_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MessageData", generator="Immutables")
    static final class Json
    implements MessageData {
        String id;
        String channelId;
        Possible<String> guildId;
        UserData author;
        Possible<PartialMemberData> member;
        String content;
        String timestamp;
        Optional<String> editedTimestamp = Optional.empty();
        boolean tts;
        boolean ttsIsSet;
        boolean mentionEveryone;
        boolean mentionEveryoneIsSet;
        List<UserWithMemberData> mentions = Collections.emptyList();
        List<String> mentionRoles = Collections.emptyList();
        Possible<List<ChannelMentionData>> mentionChannels;
        List<AttachmentData> attachments = Collections.emptyList();
        List<EmbedData> embeds = Collections.emptyList();
        Possible<List<ReactionData>> reactions;
        Possible<Object> nonce;
        boolean pinned;
        boolean pinnedIsSet;
        Possible<String> webhookId;
        int type;
        boolean typeIsSet;
        Possible<MessageActivityData> activity;
        Possible<MessageApplicationData> application;
        Possible<MessageReferenceData> messageReference;
        Possible<Integer> flags;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<String> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="author")
        public void setAuthor(UserData author) {
            this.author = author;
        }

        @JsonProperty(value="member")
        public void setMember(Possible<PartialMemberData> member) {
            this.member = member;
        }

        @JsonProperty(value="content")
        public void setContent(String content) {
            this.content = content;
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty(value="edited_timestamp")
        public void setEditedTimestamp(Optional<String> editedTimestamp) {
            this.editedTimestamp = editedTimestamp;
        }

        @JsonProperty(value="tts")
        public void setTts(boolean tts) {
            this.tts = tts;
            this.ttsIsSet = true;
        }

        @JsonProperty(value="mention_everyone")
        public void setMentionEveryone(boolean mentionEveryone) {
            this.mentionEveryone = mentionEveryone;
            this.mentionEveryoneIsSet = true;
        }

        @JsonProperty(value="mentions")
        public void setMentions(List<UserWithMemberData> mentions) {
            this.mentions = mentions;
        }

        @JsonProperty(value="mention_roles")
        public void setMentionRoles(List<String> mentionRoles) {
            this.mentionRoles = mentionRoles;
        }

        @JsonProperty(value="mention_channels")
        public void setMentionChannels(Possible<List<ChannelMentionData>> mentionChannels) {
            this.mentionChannels = mentionChannels;
        }

        @JsonProperty(value="attachments")
        public void setAttachments(List<AttachmentData> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="embeds")
        public void setEmbeds(List<EmbedData> embeds) {
            this.embeds = embeds;
        }

        @JsonProperty(value="reactions")
        public void setReactions(Possible<List<ReactionData>> reactions) {
            this.reactions = reactions;
        }

        @JsonProperty(value="nonce")
        public void setNonce(Possible<Object> nonce) {
            this.nonce = nonce;
        }

        @JsonProperty(value="pinned")
        public void setPinned(boolean pinned) {
            this.pinned = pinned;
            this.pinnedIsSet = true;
        }

        @JsonProperty(value="webhook_id")
        public void setWebhookId(Possible<String> webhookId) {
            this.webhookId = webhookId;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="activity")
        public void setActivity(Possible<MessageActivityData> activity) {
            this.activity = activity;
        }

        @JsonProperty(value="application")
        public void setApplication(Possible<MessageApplicationData> application) {
            this.application = application;
        }

        @JsonProperty(value="message_reference")
        public void setMessageReference(Possible<MessageReferenceData> messageReference) {
            this.messageReference = messageReference;
        }

        @JsonProperty(value="flags")
        public void setFlags(Possible<Integer> flags) {
            this.flags = flags;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<PartialMemberData> member() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String content() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String timestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> editedTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean mentionEveryone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserWithMemberData> mentions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> mentionRoles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<ChannelMentionData>> mentionChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AttachmentData> attachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<EmbedData> embeds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<ReactionData>> reactions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Object> nonce() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean pinned() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> webhookId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<MessageActivityData> activity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<MessageApplicationData> application() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<MessageReferenceData> messageReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Integer> flags() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="MessageData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build MessageData, attribute initializers form cycle " + attributes;
        }
    }
}

