/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ApplicationTeamMemberData;
import discord4j.discordjson.json.UserData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="ApplicationTeamMemberData", generator="Immutables")
public final class ImmutableApplicationTeamMemberData
implements ApplicationTeamMemberData {
    private final int membershipState;
    private final List<String> permissions;
    private final String teamId;
    private final UserData user;

    private ImmutableApplicationTeamMemberData(int membershipState, Iterable<String> permissions, String teamId, UserData user) {
        this.membershipState = membershipState;
        this.permissions = ImmutableApplicationTeamMemberData.createUnmodifiableList(false, ImmutableApplicationTeamMemberData.createSafeList(permissions, true, false));
        this.teamId = Objects.requireNonNull(teamId, "teamId");
        this.user = Objects.requireNonNull(user, "user");
    }

    private ImmutableApplicationTeamMemberData(ImmutableApplicationTeamMemberData original, int membershipState, List<String> permissions, String teamId, UserData user) {
        this.membershipState = membershipState;
        this.permissions = permissions;
        this.teamId = teamId;
        this.user = user;
    }

    @Override
    @JsonProperty(value="membership_state")
    public int membershipState() {
        return this.membershipState;
    }

    @Override
    @JsonProperty(value="permissions")
    public List<String> permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty(value="team_id")
    public String teamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty(value="user")
    public UserData user() {
        return this.user;
    }

    public final ImmutableApplicationTeamMemberData withMembershipState(int value) {
        if (this.membershipState == value) {
            return this;
        }
        return new ImmutableApplicationTeamMemberData(this, value, this.permissions, this.teamId, this.user);
    }

    public final ImmutableApplicationTeamMemberData withPermissions(String ... elements) {
        List<String> newValue = ImmutableApplicationTeamMemberData.createUnmodifiableList(false, ImmutableApplicationTeamMemberData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, newValue, this.teamId, this.user);
    }

    public final ImmutableApplicationTeamMemberData withPermissions(Iterable<String> elements) {
        if (this.permissions == elements) {
            return this;
        }
        List<String> newValue = ImmutableApplicationTeamMemberData.createUnmodifiableList(false, ImmutableApplicationTeamMemberData.createSafeList(elements, true, false));
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, newValue, this.teamId, this.user);
    }

    public final ImmutableApplicationTeamMemberData withTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "teamId");
        if (this.teamId.equals(newValue)) {
            return this;
        }
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, this.permissions, newValue, this.user);
    }

    public final ImmutableApplicationTeamMemberData withUser(UserData value) {
        if (this.user == value) {
            return this;
        }
        UserData newValue = Objects.requireNonNull(value, "user");
        return new ImmutableApplicationTeamMemberData(this, this.membershipState, this.permissions, this.teamId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApplicationTeamMemberData && this.equalTo((ImmutableApplicationTeamMemberData)another);
    }

    private boolean equalTo(ImmutableApplicationTeamMemberData another) {
        return this.membershipState == another.membershipState && this.permissions.equals(another.permissions) && this.teamId.equals(another.teamId) && this.user.equals(another.user);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.membershipState;
        h += (h << 5) + this.permissions.hashCode();
        h += (h << 5) + this.teamId.hashCode();
        h += (h << 5) + this.user.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationTeamMemberData{membershipState=" + this.membershipState + ", permissions=" + this.permissions + ", teamId=" + this.teamId + ", user=" + this.user + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApplicationTeamMemberData fromJson(Json json) {
        Builder builder = ImmutableApplicationTeamMemberData.builder();
        if (json.membershipStateIsSet) {
            builder.membershipState(json.membershipState);
        }
        if (json.permissions != null) {
            builder.addAllPermissions(json.permissions);
        }
        if (json.teamId != null) {
            builder.teamId(json.teamId);
        }
        if (json.user != null) {
            builder.user(json.user);
        }
        return builder.build();
    }

    public static ImmutableApplicationTeamMemberData of(int membershipState, List<String> permissions, String teamId, UserData user) {
        return ImmutableApplicationTeamMemberData.of(membershipState, permissions, teamId, user);
    }

    public static ImmutableApplicationTeamMemberData of(int membershipState, Iterable<String> permissions, String teamId, UserData user) {
        return new ImmutableApplicationTeamMemberData(membershipState, permissions, teamId, user);
    }

    public static ImmutableApplicationTeamMemberData copyOf(ApplicationTeamMemberData instance) {
        if (instance instanceof ImmutableApplicationTeamMemberData) {
            return (ImmutableApplicationTeamMemberData)instance;
        }
        return ImmutableApplicationTeamMemberData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ApplicationTeamMemberData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MEMBERSHIP_STATE = 1L;
        private static final long INIT_BIT_TEAM_ID = 2L;
        private static final long INIT_BIT_USER = 4L;
        private long initBits = 7L;
        private int membershipState;
        private List<String> permissions = new ArrayList<String>();
        private String teamId;
        private UserData user;

        private Builder() {
        }

        public final Builder from(ApplicationTeamMemberData instance) {
            Objects.requireNonNull(instance, "instance");
            this.membershipState(instance.membershipState());
            this.addAllPermissions(instance.permissions());
            this.teamId(instance.teamId());
            this.user(instance.user());
            return this;
        }

        @JsonProperty(value="membership_state")
        public final Builder membershipState(int membershipState) {
            this.membershipState = membershipState;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPermission(String element) {
            this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            return this;
        }

        public final Builder addPermissions(String ... elements) {
            for (String element : elements) {
                this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            }
            return this;
        }

        @JsonProperty(value="permissions")
        public final Builder permissions(Iterable<String> elements) {
            this.permissions.clear();
            return this.addAllPermissions(elements);
        }

        public final Builder addAllPermissions(Iterable<String> elements) {
            for (String element : elements) {
                this.permissions.add(Objects.requireNonNull(element, "permissions element"));
            }
            return this;
        }

        @JsonProperty(value="team_id")
        public final Builder teamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder user(UserData user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableApplicationTeamMemberData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApplicationTeamMemberData(null, this.membershipState, ImmutableApplicationTeamMemberData.createUnmodifiableList(true, this.permissions), this.teamId, this.user);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("membershipState");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("teamId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("user");
            }
            return "Cannot build ApplicationTeamMemberData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ApplicationTeamMemberData", generator="Immutables")
    static final class Json
    implements ApplicationTeamMemberData {
        int membershipState;
        boolean membershipStateIsSet;
        List<String> permissions = Collections.emptyList();
        String teamId;
        UserData user;

        Json() {
        }

        @JsonProperty(value="membership_state")
        public void setMembershipState(int membershipState) {
            this.membershipState = membershipState;
            this.membershipStateIsSet = true;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(List<String> permissions) {
            this.permissions = permissions;
        }

        @JsonProperty(value="team_id")
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty(value="user")
        public void setUser(UserData user) {
            this.user = user;
        }

        @Override
        public int membershipState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String teamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserData user() {
            throw new UnsupportedOperationException();
        }
    }
}

