/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.possible;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

public final class Possible<T> {
    private static final Object ABSENT_VALUE = new Object();
    private static final Possible<?> ABSENT = new Possible<Object>(ABSENT_VALUE);
    private final T value;

    public static <T> Possible<T> of(T value) {
        return new Possible<T>(Objects.requireNonNull(value));
    }

    public static <T> Possible<T> absent() {
        return ABSENT;
    }

    public static <T> Optional<T> flatOpt(Possible<Optional<T>> possible) {
        return possible.toOptional().flatMap(Function.identity());
    }

    private Possible(T value) {
        this.value = value;
    }

    public boolean isAbsent() {
        return this.value == ABSENT_VALUE;
    }

    public T get() {
        if (this.isAbsent()) {
            throw new NoSuchElementException();
        }
        return this.value;
    }

    public Optional<T> toOptional() {
        if (this.isAbsent()) {
            return Optional.empty();
        }
        return Optional.of(this.value);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Possible possible = (Possible)o;
        return Objects.equals(this.value, possible.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        if (this.isAbsent()) {
            return "Possible.absent";
        }
        return "Possible{" + this.value + '}';
    }
}

