/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.player;

import com.destroystokyo.paper.profile.PlayerProfile;
import java.net.InetAddress;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.jetbrains.annotations.NotNull;

public class AsyncPlayerPreLoginEvent
extends Event {
    private static final HandlerList handlers = new HandlerList();
    private Result result;
    private String message;
    private final InetAddress ipAddress;
    private PlayerProfile profile;

    @Deprecated
    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress) {
        this(name, ipAddress, null);
    }

    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress, @NotNull UUID uniqueId) {
        this(name, ipAddress, uniqueId, Bukkit.createProfile(uniqueId, name));
    }

    @NotNull
    public PlayerProfile getPlayerProfile() {
        return this.profile;
    }

    public void setPlayerProfile(@NotNull PlayerProfile profile) {
        this.profile = profile;
    }

    public AsyncPlayerPreLoginEvent(@NotNull String name, @NotNull InetAddress ipAddress, @NotNull UUID uniqueId, @NotNull PlayerProfile profile) {
        super(true);
        this.profile = profile;
        this.result = Result.ALLOWED;
        this.message = "";
        this.ipAddress = ipAddress;
    }

    @NotNull
    public Result getLoginResult() {
        return this.result;
    }

    @Deprecated
    @NotNull
    public PlayerPreLoginEvent.Result getResult() {
        return this.result == null ? null : this.result.old();
    }

    public void setLoginResult(@NotNull Result result) {
        this.result = result;
    }

    @Deprecated
    public void setResult(@NotNull PlayerPreLoginEvent.Result result) {
        this.result = result == null ? null : Result.valueOf(result.name());
    }

    @NotNull
    public String getKickMessage() {
        return this.message;
    }

    public void setKickMessage(@NotNull String message) {
        this.message = message;
    }

    public void allow() {
        this.result = Result.ALLOWED;
        this.message = "";
    }

    public void disallow(@NotNull Result result, @NotNull String message) {
        this.result = result;
        this.message = message;
    }

    @Deprecated
    public void disallow(@NotNull PlayerPreLoginEvent.Result result, @NotNull String message) {
        this.result = result == null ? null : Result.valueOf(result.name());
        this.message = message;
    }

    @NotNull
    public String getName() {
        return this.profile.getName();
    }

    @NotNull
    public InetAddress getAddress() {
        return this.ipAddress;
    }

    @NotNull
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }

    public static enum Result {
        ALLOWED,
        KICK_FULL,
        KICK_BANNED,
        KICK_WHITELIST,
        KICK_OTHER;


        @Deprecated
        @NotNull
        private PlayerPreLoginEvent.Result old() {
            return PlayerPreLoginEvent.Result.valueOf(this.name());
        }
    }
}

